/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.async.utils;

import com.ibm.lsid.client.async.utils.KillJob;
import com.ibm.lsid.client.async.utils.ProducerConsumerBuffer;
import com.ibm.lsid.client.async.utils.WorkerThread;
import java.util.Vector;

public class WorkPool {
    private int numthreads = 0;
    private ProducerConsumerBuffer workqueue;
    private static final long CLEANUP_WAIT_TIME = 4000L;
    private int maxthreads;
    private Vector workers = new Vector();

    public synchronized int workerCount() {
        return this.numthreads;
    }

    public WorkPool(int n) {
        this.maxthreads = n;
        this.workqueue = new ProducerConsumerBuffer();
    }

    public synchronized void addJob(Runnable runnable) {
        if (this.numthreads < this.maxthreads && !(runnable instanceof KillJob)) {
            WorkerThread workerThread = new WorkerThread(this.workqueue, this);
            this.workers.addElement(workerThread);
            ++this.numthreads;
            workerThread.start();
        }
        this.workqueue.put(runnable);
    }

    public synchronized void destroy() {
        int n = 0;
        while (n < this.numthreads) {
            this.addJob(new KillJob());
            ++n;
        }
        long l = 0L;
        while (l < 4000L) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l += 1000L;
            if (this.numthreads != 0) continue;
            l = 4000L;
        }
        int n2 = 0;
        while (n2 < this.numthreads) {
            WorkerThread workerThread = (WorkerThread)this.workers.elementAt(n2);
            workerThread.interrupt();
            ++n2;
        }
    }

    synchronized void removeWorker(WorkerThread workerThread) {
        if (this.workers.remove(workerThread)) {
            --this.numthreads;
        }
    }
}

