/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.cache;

import com.ibm.lsid.LSID;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.client.cache.LSIDCacheException;
import com.ibm.lsid.client.cache.LSIDCachingInputStreamListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LSIDCachingInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 1024;
    private InputStream objectData;
    private OutputStream cacheOut;
    private File cacheFile;
    private File tempFile;
    private LSID lsid;
    private LSIDAuthority authority;
    private LSIDCachingInputStreamListener listener;
    private LSIDCache lsidCache;
    private boolean closed = false;

    public LSIDCachingInputStream(InputStream inputStream, File file, LSIDAuthority lSIDAuthority, LSID lSID) throws LSIDCacheException {
        this.objectData = inputStream;
        this.cacheFile = file;
        this.authority = lSIDAuthority;
        this.lsid = lSID;
        file.getParentFile().mkdirs();
        this.lsidCache = LSIDCache.getSingletonInstance();
        if (this.lsidCache == null) {
            throw new LSIDCacheException("Error opening Data cache");
        }
        File file2 = new File(LSIDCache.getLocation(), "/temp/");
        file2.mkdirs();
        try {
            this.tempFile = File.createTempFile("cache", "tmp", file2);
            this.cacheOut = new BufferedOutputStream(new FileOutputStream(this.tempFile), 1024);
        }
        catch (IOException iOException) {
            throw new LSIDCacheException("Error opening temporary cache file");
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            byte[] byArray = new byte[1024];
            int n = this.objectData.read(byArray);
            while (n != -1) {
                this.cacheOut.write(byArray, 0, n);
                n = this.objectData.read(byArray);
            }
            this.cacheOut.flush();
            this.cacheOut.close();
            this.listener.inputStreamClosed(this.authority, this.lsid);
            if (this.cacheFile.exists()) {
                this.cacheFile.delete();
            }
            this.tempFile.renameTo(this.cacheFile);
            this.tempFile.delete();
        }
        catch (IOException iOException) {
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw iOException;
        }
        finally {
            try {
                if (this.cacheOut != null) {
                    this.cacheOut.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (this.objectData != null) {
                    this.objectData.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                super.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        try {
            int n = this.objectData.read();
            if (n == -1) {
                this.cacheOut.flush();
            } else {
                this.cacheOut.write(n);
            }
            return n;
        }
        catch (IOException iOException) {
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw iOException;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        try {
            int n3 = this.objectData.read(byArray, n, n2);
            if (n3 != -1) {
                this.cacheOut.write(byArray, n, n3);
            }
            return n3;
        }
        catch (IOException iOException) {
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw iOException;
        }
    }

    public int read(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        return this.read(byArray, 0, byArray.length);
    }

    public void setInputStreamListener(LSIDCachingInputStreamListener lSIDCachingInputStreamListener) {
        this.listener = lSIDCachingInputStreamListener;
    }
}

