/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.conf;

import com.ibm.lsid.LSID;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.conf.credentials.castor.Basic;
import com.ibm.lsid.client.conf.credentials.castor.Lsid;
import com.ibm.lsid.client.conf.credentials.castor.LsidCredentials;
import com.ibm.lsid.client.conf.credentials.castor.Port;
import com.ibm.lsid.wsdl.LSIDPort;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class LSIDCredentialConfig {
    public static final String LSID_CLIENT_HOME = "LSID_CLIENT_HOME";
    private static final String CREDENTIAL_FILE_NAME = "lsid-credentials.xml";
    private static final String LSID_CLIENT_HOME_DEFAULT_WIN32 = "/lsid-client";
    private static final String LSID_CLIENT_HOME_DEFAULT_UNIX = ".lsid-client";
    private static Hashtable knownPorts = new Hashtable();
    private static Hashtable knownLSIDs = new Hashtable();
    private File lsidHome = null;
    private static LSIDCredentialConfig instance = new LSIDCredentialConfig();

    public static LSIDCredentialConfig getInstance() {
        return instance;
    }

    public static Hashtable getCredentials(LSID lSID) {
        String string = lSID.toString();
        if (knownLSIDs.containsKey(string)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(string));
        }
        string = "urn:lsid:" + lSID.getAuthority() + ":" + lSID.getNamespace() + ":" + lSID.getObject();
        if (knownLSIDs.containsKey(string)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(string));
        }
        string = "urn:lsid:" + lSID.getAuthority() + ":" + lSID.getNamespace();
        if (knownLSIDs.containsKey(string)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(string));
        }
        string = "urn:lsid:" + lSID.getAuthority();
        if (knownLSIDs.containsKey(string)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(string));
        }
        return new Hashtable();
    }

    public static Hashtable getCredentials(LSIDAuthority lSIDAuthority) {
        String string = "urn:lsid:" + lSIDAuthority;
        if (knownLSIDs.containsKey(string)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(string));
        }
        return new Hashtable();
    }

    public static Hashtable getCredentials(LSIDPort lSIDPort) {
        String string = lSIDPort.getServiceName() + ":" + lSIDPort.getName();
        if (!knownPorts.containsKey(string) && lSIDPort.getServiceName() != null) {
            string = (String)knownPorts.get(lSIDPort.getServiceName());
        }
        if (string != null && knownPorts.containsKey(string)) {
            String string2 = (String)knownPorts.get(string);
            return LSIDCredentialConfig.addBasicAuth(string2);
        }
        return new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LSIDCredentialConfig() {
        File file;
        String string = System.getProperty(LSID_CLIENT_HOME);
        if (string == null) {
            char c = File.separatorChar;
            string = c == '/' ? LSID_CLIENT_HOME_DEFAULT_UNIX : LSID_CLIENT_HOME_DEFAULT_WIN32;
            System.err.println("No LSID_CLIENT_HOME specified, using default: " + string);
        }
        this.lsidHome = new File(string);
        if (!this.lsidHome.exists()) {
            this.lsidHome.mkdirs();
        }
        if ((file = new File(this.lsidHome, CREDENTIAL_FILE_NAME)).exists()) {
            Object object;
            InputStream inputStream = null;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            LsidCredentials lsidCredentials = LsidCredentials.unmarshalLsidCredentials(bufferedReader);
            Port[] portArray = lsidCredentials.getPort();
            int n = 0;
            while (n < portArray.length) {
                object = portArray[n].getBasic();
                knownPorts.put(portArray[n].getMap(), ((Basic)object).getUsername() + ":" + ((Basic)object).getPassword());
                ++n;
            }
            object = lsidCredentials.getLsid();
            int n2 = 0;
            while (n2 < ((Lsid[])object).length) {
                Basic basic = object[n2].getBasic();
                knownLSIDs.put(((Lsid)object[n2]).getMap(), basic.getUsername() + ":" + basic.getPassword());
                ++n2;
            }
            Object var12_15 = null;
            if (inputStream == null) return;
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
            {
                catch (IOException iOException) {
                    System.err.println("Error loading credential file, using default settings, exception trace follows");
                    iOException.printStackTrace();
                    this.writeDefaultCredentials();
                    Object var12_16 = null;
                    if (inputStream == null) return;
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    return;
                }
                catch (MarshalException marshalException) {
                    System.err.println("Error parsing credential file, using default settings, exception trace follows");
                    marshalException.printStackTrace();
                    Object var12_17 = null;
                    if (inputStream == null) return;
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return;
                }
                catch (ValidationException validationException) {
                    System.err.println("Error parsing credential file, using default settings, exception trace follows");
                    validationException.printStackTrace();
                    Object var12_18 = null;
                    if (inputStream == null) return;
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
        System.err.println("Credential file: " + file + " does not exist, using default settings");
        this.writeDefaultCredentials();
    }

    private static Hashtable addBasicAuth(String string) {
        Hashtable hashtable = new Hashtable();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            ArrayList<String> arrayList = new ArrayList<String>(3);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            if (arrayList.size() > 1) {
                hashtable.put("basicUsername", arrayList.get(0));
                hashtable.put("basicPassword", arrayList.get(1));
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDefaultCredentials() {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(CREDENTIAL_FILE_NAME);
            if (inputStream == null) {
                System.err.println("Non fatal error: no default credential exists in client installation");
                return;
            }
            outputStream = new FileOutputStream(new File(this.lsidHome, CREDENTIAL_FILE_NAME));
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("No fatal error: could not write default credentials file, stack trace follows");
            iOException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

