/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class SOAPHeader
extends MessageElement
implements javax.xml.soap.SOAPHeader {
    private static Log log = LogFactory.getLog((class$org$apache$axis$message$SOAPHeader == null ? (class$org$apache$axis$message$SOAPHeader = SOAPHeader.class$("org.apache.axis.message.SOAPHeader")) : class$org$apache$axis$message$SOAPHeader).getName());
    private Vector headers = new Vector();
    private SOAPConstants soapConstants;
    static /* synthetic */ Class class$org$apache$axis$message$SOAPHeader;

    SOAPHeader(SOAPEnvelope env, SOAPConstants soapConsts) {
        super("Header", "soapenv", soapConsts != null ? soapConsts.getEnvelopeURI() : Constants.DEFAULT_SOAP_VERSION.getEnvelopeURI());
        this.soapConstants = soapConsts != null ? soapConsts : Constants.DEFAULT_SOAP_VERSION;
        try {
            this.setParentElement(env);
            this.setEnvelope(env);
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    public SOAPHeader(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context, SOAPConstants soapConsts) throws AxisFault {
        super(namespace, localPart, prefix, attributes, context);
        this.soapConstants = soapConsts != null ? soapConsts : Constants.DEFAULT_SOAP_VERSION;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            SOAPEnvelope env = (SOAPEnvelope)parent;
            super.setParentElement(env);
            this.setEnvelope(env);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public void detachNode() {
        ((SOAPEnvelope)this.parent).removeHeaders();
        super.detachNode();
    }

    public javax.xml.soap.SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        SOAPHeaderElement headerElement = new SOAPHeaderElement(name);
        SOAPEnvelope envelope = this.getEnvelope();
        headerElement.setEnvelope(envelope);
        this.addHeader(headerElement);
        envelope.setDirty(true);
        return headerElement;
    }

    private Vector findHeaderElements(String actor) {
        ArrayList<String> actors = new ArrayList<String>();
        actors.add(actor);
        return this.getHeadersByActor(actors);
    }

    public Iterator examineHeaderElements(String actor) {
        return ((AbstractList)this.findHeaderElements(actor)).iterator();
    }

    public Iterator extractHeaderElements(String actor) {
        Vector results = this.findHeaderElements(actor);
        Iterator iterator = ((AbstractList)results).iterator();
        while (iterator.hasNext()) {
            ((SOAPHeaderElement)iterator.next()).detachNode();
        }
        return ((AbstractList)results).iterator();
    }

    Vector getHeaders() {
        return this.headers;
    }

    Vector getHeadersByActor(ArrayList actors) {
        Vector<SOAPHeaderElement> results = new Vector<SOAPHeaderElement>();
        Iterator i = ((AbstractList)this.headers).iterator();
        SOAPConstants soapVer = this.getEnvelope().getSOAPConstants();
        boolean isSOAP12 = soapVer == SOAPConstants.SOAP12_CONSTANTS;
        String nextActor = soapVer.getNextRoleURI();
        while (i.hasNext()) {
            SOAPHeaderElement header = (SOAPHeaderElement)i.next();
            String actor = header.getActor();
            if (isSOAP12 && "http://www.w3.org/2002/12/soap-envelope/role/none".equals(actor) || actor != null && !nextActor.equals(actor) && (!isSOAP12 || !"http://www.w3.org/2002/12/soap-envelope/role/ultimateReceiver".equals(actor)) && (actors == null || !actors.contains(actor))) continue;
            results.add(header);
        }
        return results;
    }

    void addHeader(SOAPHeaderElement header) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("addHeader00"));
        }
        try {
            header.setParentElement(this);
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    void removeHeader(SOAPHeaderElement header) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("removeHeader00"));
        }
        this.headers.removeElement(header);
    }

    SOAPHeaderElement getHeaderByName(String namespace, String localPart, boolean accessAllHeaders) {
        MessageContext mc;
        SOAPHeaderElement header = (SOAPHeaderElement)this.findElement(this.headers, namespace, localPart);
        if (!accessAllHeaders && (mc = MessageContext.getCurrentContext()) != null && header != null) {
            String actor = header.getActor();
            String nextActor = this.getEnvelope().getSOAPConstants().getNextRoleURI();
            if (nextActor.equals(actor)) {
                return header;
            }
            SOAPService soapService = mc.getService();
            if (soapService != null) {
                ArrayList actors = mc.getService().getActors();
                if (!(actor == null || actors != null && actors.contains(actor))) {
                    header = null;
                }
            }
        }
        return header;
    }

    private MessageElement findElement(Vector vec, String namespace, String localPart) {
        if (vec.isEmpty()) {
            return null;
        }
        QName qname = new QName(namespace, localPart);
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            MessageElement element = (MessageElement)e.nextElement();
            if (!element.getQName().equals(qname)) continue;
            return element;
        }
        return null;
    }

    Enumeration getHeadersByName(String namespace, String localPart, boolean accessAllHeaders) {
        ArrayList actors = null;
        boolean firstTime = false;
        Vector<SOAPHeaderElement> v = new Vector<SOAPHeaderElement>();
        Enumeration e = this.headers.elements();
        String nextActor = this.getEnvelope().getSOAPConstants().getNextRoleURI();
        while (e.hasMoreElements()) {
            SOAPHeaderElement header = (SOAPHeaderElement)e.nextElement();
            if (!header.getNamespaceURI().equals(namespace) || !header.getName().equals(localPart)) continue;
            if (!accessAllHeaders) {
                String actor;
                if (firstTime) {
                    MessageContext mc = MessageContext.getCurrentContext();
                    if (mc != null) {
                        actors = mc.getAxisEngine().getActorURIs();
                    }
                    firstTime = false;
                }
                if ((actor = header.getActor()) != null && !nextActor.equals(actor) && (actors == null || !actors.contains(actor))) continue;
            }
            v.addElement(header);
        }
        return v.elements();
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        boolean oldPretty = context.getPretty();
        context.setPretty(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.headers.size() + " " + Messages.getMessage("headers00")));
        }
        if (!this.headers.isEmpty()) {
            context.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Header"), null);
            Enumeration enumeration = this.headers.elements();
            while (enumeration.hasMoreElements()) {
                ((SOAPHeaderElement)enumeration.nextElement()).output(context);
            }
            context.endElement();
        }
        context.setPretty(oldPretty);
    }

    public void addChild(MessageElement el) throws SOAPException {
        this.headers.addElement(el);
    }

    public Iterator getChildElements() {
        return ((AbstractList)this.headers).iterator();
    }

    public Iterator getChildElements(Name name) {
        Vector<SOAPHeaderElement> v = new Vector<SOAPHeaderElement>();
        Enumeration e = this.headers.elements();
        while (e.hasMoreElements()) {
            SOAPHeaderElement header = (SOAPHeaderElement)e.nextElement();
            if (!header.getNamespaceURI().equals(name.getURI()) || !header.getName().equals(name.getLocalName())) continue;
            v.addElement(header);
        }
        return ((AbstractList)v).iterator();
    }

    /*
     * WARNING - void declaration
     */
    public void removeChild(MessageElement child) {
        int i;
        while ((i = this.headers.indexOf(child)) != -1) {
            void var2_2;
            this.headers.remove((int)var2_2);
        }
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        if (!(element instanceof javax.xml.soap.SOAPHeaderElement)) {
            throw new SOAPException(Messages.getMessage("badSOAPHeader00"));
        }
        return super.addChildElement(element);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPHeaderElement child = new SOAPHeaderElement(name.getURI(), name.getLocalName());
        this.addChild(child);
        child.setEnvelope(this.getEnvelope());
        return child;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        SOAPHeaderElement child = new SOAPHeaderElement(this.getNamespaceURI(), localName);
        this.addChild(child);
        child.setEnvelope(this.getEnvelope());
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        SOAPHeaderElement child = new SOAPHeaderElement(this.getNamespaceURI(prefix), localName);
        this.addChild(child);
        child.setEnvelope(this.getEnvelope());
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        SOAPHeaderElement child = new SOAPHeaderElement(uri, localName);
        child.setPrefix(prefix);
        child.addNamespaceDeclaration(prefix, uri);
        this.addChild(child);
        child.setEnvelope(this.getEnvelope());
        return child;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

