/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.ErrorHandledException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.HandlerException;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.ErrorSendingErrorException;
import edu.ucsb.nceas.metacat.util.ResponseUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.LSIDUtil;
import edu.ucsb.nceas.utilities.ParseLSIDException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.UtilException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ArchiveHandler {
    private static ArchiveHandler archiveHandler = null;
    private static Logger logMetacat = Logger.getLogger(ArchiveHandler.class);

    private ArchiveHandler() throws HandlerException {
    }

    public static ArchiveHandler getInstance() throws HandlerException {
        if (archiveHandler == null) {
            archiveHandler = new ArchiveHandler();
        }
        return archiveHandler;
    }

    public void readArchiveEntry(Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response, String user, String passWord, String[] groups) throws HandlerException, ErrorSendingErrorException, ErrorHandledException {
        String[] docs = new String[]{};
        String docid = "";
        String qformat = "";
        String[] archiveEntryNames = new String[]{};
        String archiveEntryName = "";
        try {
            if (params.containsKey("docid")) {
                docs = params.get("docid");
                docid = docs[0];
                if (docid.startsWith("urn:")) {
                    docid = LSIDUtil.getDocId((String)docid, (boolean)true);
                }
            } else {
                throw new HandlerException("ArchiveHandler.readArchiveEntry - Could not find doc id in params when reading archive entry");
            }
            if (!params.containsKey("archiveEntryName")) {
                throw new HandlerException("ArchiveHandler.readArchiveEntry - Could not find archiveEntryName in params when reading archive entry");
            }
            archiveEntryNames = params.get("archiveEntryName");
            archiveEntryName = archiveEntryNames[0];
            qformat = params.containsKey("qformat") ? params.get("qformat")[0] : "jar-file";
            String archiveFileBasePath = PropertyService.getProperty("application.datafilepath");
            String archiveFilePath = archiveFileBasePath + FileUtil.getFS() + docid;
            String expandedArchiveBasePath = PropertyService.getProperty("application.expandedArchivePath");
            String expandedArchivePath = expandedArchiveBasePath + FileUtil.getFS() + docid;
            String entryFilePath = expandedArchivePath + FileUtil.getFS() + archiveEntryName;
            if (!FileUtil.isDirectory((String)expandedArchivePath)) {
                FileUtil.createDirectory((String)expandedArchivePath);
            }
            if (FileUtil.getFileStatus((String)entryFilePath) == FileUtil.DOES_NOT_EXIST) {
                if (FileUtil.getFileStatus((String)archiveFilePath) < FileUtil.EXISTS_READABLE) {
                    throw new HandlerException("Could not find archive: " + archiveFilePath + " in order to get content file: " + archiveEntryName);
                }
                FileUtil.extractJarFile((String)archiveFilePath, (String)expandedArchivePath);
            }
            ResponseUtil.writeFileToOutput(response, expandedArchivePath, archiveEntryName);
        }
        catch (UtilException ue) {
            String errorString = "ArchiveHandler.readArchiveEntry - Utility error reading archive entry for docid: " + docid + " : " + ue.getMessage();
            ResponseUtil.sendErrorXML(response, ResponseUtil.GENERAL_UTILITY_ERROR, errorString);
            throw new ErrorHandledException(null);
        }
        catch (PropertyNotFoundException pnfe) {
            String errorString = "ArchiveHandler.readArchiveEntry -  Property error reading archive entry for docid: " + docid + " : " + pnfe.getMessage();
            ResponseUtil.sendErrorXML(response, ResponseUtil.PROPERTY_NOT_FOUND, errorString);
            throw new ErrorHandledException(null);
        }
        catch (MetacatUtilException mue) {
            String errorString = "ArchiveHandler.readArchiveEntry -  Metacat utility error reading archive entry for docid: " + docid + " : " + mue.getMessage();
            ResponseUtil.sendErrorXML(response, ResponseUtil.METACAT_UTILITY_ERROR, errorString);
            throw new ErrorHandledException(null);
        }
        catch (ParseLSIDException ple) {
            String errorString = "ArchiveHandler.readArchiveEntry -  LSID parsing error reading archive entry for docid: " + docid + " : " + ple.getMessage();
            ResponseUtil.sendErrorXML(response, ResponseUtil.METACAT_UTILITY_ERROR, errorString);
            throw new ErrorHandledException(null);
        }
    }
}

