/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.properties.SkinPropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DBTransform {
    private String configDir = null;
    private String defaultStyle = null;
    private Logger logMetacat = Logger.getLogger(DBTransform.class);
    private String httpServer = null;
    private String contextURL = null;
    private String servletURL = null;
    private String userManagementURL = null;

    public DBTransform() throws IOException, SQLException, ClassNotFoundException, PropertyNotFoundException {
        this.configDir = SystemUtil.getStyleSkinsDir();
        this.defaultStyle = PropertyService.getProperty("application.default-style");
        this.httpServer = SystemUtil.getServerURL();
        this.contextURL = SystemUtil.getContextURL();
        this.servletURL = SystemUtil.getServletURL();
        this.userManagementURL = PropertyService.getProperty("auth.userManagementUrl");
    }

    public void transformXMLDocument(String doc, String sourceType, String targetType, String qformat, Writer w, Hashtable<String, String[]> param, String sessionid) {
        String xslSystemId = this.getStyleSystemId(qformat, sourceType, targetType);
        try {
            if (xslSystemId != null) {
                doc = this.removeDOCTYPE(doc);
                StreamSource xml = new StreamSource(new StringReader(doc));
                StreamResult result = new StreamResult(w);
                this.doTransform(xml, result, xslSystemId, param, qformat, sessionid);
            } else {
                w.write(doc);
            }
        }
        catch (Exception e) {
            try {
                String msg = xslSystemId + ": Error transforming document in " + "DBTransform.transformXMLDocument: " + e.getMessage();
                w.write(msg);
                w.flush();
                this.logMetacat.error((Object)msg, (Throwable)e);
            }
            catch (IOException e1) {
                this.logMetacat.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private void doTransform(StreamSource xml, StreamResult resultOutput, String xslSystemId, Hashtable<String, String[]> param, String qformat, String sessionid) throws Exception {
        if (xslSystemId != null) {
            String value;
            String key;
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(xslSystemId));
            transformer.setParameter("qformat", qformat);
            this.logMetacat.info((Object)("DBTransform.doTransform - qformat: " + qformat));
            SortedProperties skinOptions = SkinPropertyService.getProperties(qformat);
            if (skinOptions != null) {
                for (Map.Entry entry : skinOptions.getProperties().entrySet()) {
                    key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    if (key.indexOf(46) != -1) continue;
                    transformer.setParameter(key, value);
                }
            }
            if (sessionid != null && !sessionid.equals("null")) {
                transformer.setParameter("sessid", sessionid);
            }
            String cgiPrefix = SystemUtil.getCGI_URL();
            this.logMetacat.debug((Object)("DBTransform.doTransform - cgi-prefix: " + cgiPrefix));
            this.logMetacat.debug((Object)("DBTransform.doTransform - httpServer: " + this.httpServer));
            this.logMetacat.debug((Object)("DBTransform.doTransform - contextURL: " + this.contextURL));
            this.logMetacat.debug((Object)("DBTransform.doTransform - serletURL: " + this.servletURL));
            this.logMetacat.debug((Object)("DBTransform.doTransform - userManagementURL: " + this.userManagementURL));
            transformer.setParameter("cgi-prefix", cgiPrefix);
            transformer.setParameter("httpServer", this.httpServer);
            transformer.setParameter("contextURL", this.contextURL);
            transformer.setParameter("servletURL", this.servletURL);
            transformer.setParameter("userManagementURL", this.userManagementURL);
            if (param != null) {
                Enumeration<String> en = param.keys();
                while (en.hasMoreElements()) {
                    key = en.nextElement();
                    value = param.get(key)[0];
                    this.logMetacat.info((Object)("DBTransform.doTransform - param: " + key + " -- " + value));
                    transformer.setParameter(key, value);
                }
            }
            transformer.transform(xml, resultOutput);
        }
    }

    public static NodeList getPathContent(File f, String path) {
        InputSource in;
        FileInputStream fs;
        if (f == null) {
            return null;
        }
        DOMParser parser = new DOMParser();
        try {
            fs = new FileInputStream(f);
            in = new InputSource(fs);
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
            return null;
        }
        try {
            parser.parse(in);
            fs.close();
        }
        catch (Exception e1) {
            System.err.println("File: " + f.getPath() + " : parse threw: " + e1.toString());
            return null;
        }
        Document doc = parser.getDocument();
        try {
            NodeList docNodeList = XPathAPI.selectNodeList((Node)doc, (String)path);
            return docNodeList;
        }
        catch (Exception se) {
            System.err.println("file: " + f.getPath() + " : parse threw: " + se.toString());
            return null;
        }
    }

    public String getStyleSystemId(String qformat, String sourcetype, String targettype) {
        String systemId = null;
        if (qformat == null || qformat.equals("html")) {
            qformat = this.defaultStyle;
        }
        try {
            boolean breakflag = false;
            String filename = this.configDir + "/" + qformat + "/" + qformat + ".xml";
            this.logMetacat.info((Object)("DBTransform.getStyleSystemId - Trying style-set file: " + filename));
            File f = new File(filename);
            NodeList nlDoctype = DBTransform.getPathContent(f, "/style-set/doctype");
            NodeList nlDefault = DBTransform.getPathContent(f, "/style-set/default-style");
            Node nDefault = nlDefault.item(0);
            systemId = nDefault.getFirstChild().getNodeValue();
            for (int i = 0; i < nlDoctype.getLength(); ++i) {
                Node nDoctype = nlDoctype.item(i);
                NamedNodeMap atts = nDoctype.getAttributes();
                Node nAtt = atts.getNamedItem("publicid");
                String doctype = nAtt.getFirstChild().getNodeValue();
                if (doctype.equals(sourcetype)) {
                    NodeList nlChildren = nDoctype.getChildNodes();
                    for (int j = 0; j < nlChildren.getLength(); ++j) {
                        NamedNodeMap childAtts;
                        Node nTargetPublicId;
                        String target;
                        Node nChild = nlChildren.item(j);
                        String childName = nChild.getNodeName();
                        if (childName.equals("target") && (target = (nTargetPublicId = (childAtts = nChild.getAttributes()).getNamedItem("publicid")).getFirstChild().getNodeValue()).equals(targettype)) {
                            NodeList nlTarget = nChild.getChildNodes();
                            for (int k = 0; k < nlTarget.getLength(); ++k) {
                                Node nChildText = nlTarget.item(k);
                                if (nChildText.getNodeType() != 3) continue;
                                systemId = nChildText.getNodeValue();
                                breakflag = true;
                                break;
                            }
                        }
                        if (breakflag) break;
                    }
                }
                if (!breakflag) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing style-set file: " + e.getMessage());
            e.printStackTrace();
        }
        if (systemId != null && !systemId.startsWith("http")) {
            systemId = this.contextURL + systemId;
        }
        this.logMetacat.info((Object)("DBTransform.getStyleSystemId - style system id is: " + systemId));
        return systemId;
    }

    private String removeDOCTYPE(String in) {
        String ret = "";
        int startpos = in.indexOf("<!DOCTYPE");
        if (startpos <= -1) {
            return in;
        }
        int stoppos = in.indexOf(">", startpos + 8);
        ret = in.substring(0, startpos) + in.substring(stoppos + 1, in.length());
        return ret;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Wrong number of arguments!!!");
            System.err.println("USAGE: java DBTransform");
            return;
        }
        try {
            StringBuffer testdoc = new StringBuffer();
            String encoding = "UTF-8";
            testdoc.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            testdoc.append("<eml-dataset><metafile_id>NCEAS-0001</metafile_id>");
            testdoc.append("<dataset_id>DS001</dataset_id>");
            testdoc.append("<title>My test doc</title></eml-dataset>");
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)System.out, encoding);
            DBTransform dbt = new DBTransform();
            dbt.transformXMLDocument(testdoc.toString(), "-//NCEAS//eml-dataset//EN", "-//W3C//HTML//EN", "knb", w, null, null);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION HANDLING REQUIRED");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

