/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.IndexingQueueObject;
import edu.ucsb.nceas.metacat.IndexingTask;
import edu.ucsb.nceas.metacat.common.query.EnabledQueryEngines;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class IndexingQueue {
    private static Logger logMetacat = Logger.getLogger(IndexingQueue.class);
    private HashMap<String, IndexingQueueObject> indexingMap = new HashMap();
    private Vector<IndexingTask> currentThreads = new Vector();
    public Vector<String> currentDocidsBeingIndexed = new Vector();
    private boolean metacatRunning = true;
    private static IndexingQueue instance = null;
    static final int NUMBEROFINDEXINGTHREADS;

    private IndexingQueue() {
        if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
            return;
        }
        for (int i = 0; i < NUMBEROFINDEXINGTHREADS; ++i) {
            IndexingTask thread = new IndexingTask();
            thread.start();
            this.currentThreads.add(thread);
        }
    }

    public static synchronized IndexingQueue getInstance() {
        if (instance == null) {
            instance = new IndexingQueue();
        }
        return instance;
    }

    public void add(String docid, String rev) {
        if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
            return;
        }
        this.add(new IndexingQueueObject(docid, rev, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(IndexingQueueObject queueObject) {
        HashMap<String, IndexingQueueObject> hashMap = this.indexingMap;
        synchronized (hashMap) {
            if (!this.indexingMap.containsKey(queueObject.getDocid())) {
                this.indexingMap.put(queueObject.getDocid(), queueObject);
                this.indexingMap.notify();
            } else {
                IndexingQueueObject oldQueueObject = this.indexingMap.get(queueObject.getDocid());
                if (oldQueueObject.compareTo(queueObject) < 0) {
                    this.indexingMap.put(queueObject.getDocid(), queueObject);
                    this.indexingMap.notify();
                }
            }
        }
    }

    public boolean getMetacatRunning() {
        return this.metacatRunning;
    }

    public void setMetacatRunning(boolean metacatRunning) {
        if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
            return;
        }
        this.metacatRunning = metacatRunning;
        if (!metacatRunning) {
            for (int count = 0; count < this.currentThreads.size(); ++count) {
                this.currentThreads.get((int)count).metacatRunning = false;
                this.currentThreads.get(count).interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexingQueueObject getNext() {
        IndexingQueueObject returnVal = null;
        HashMap<String, IndexingQueueObject> hashMap = this.indexingMap;
        synchronized (hashMap) {
            while (this.indexingMap.isEmpty() && this.metacatRunning) {
                try {
                    this.indexingMap.wait();
                }
                catch (InterruptedException ex) {
                    logMetacat.error((Object)"Interrupted");
                }
            }
            if (this.metacatRunning) {
                String docid = this.indexingMap.keySet().iterator().next();
                returnVal = this.indexingMap.get(docid);
                this.indexingMap.remove(docid);
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String docid, String rev) {
        if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
            return;
        }
        HashMap<String, IndexingQueueObject> hashMap = this.indexingMap;
        synchronized (hashMap) {
            if (this.indexingMap.containsKey(docid)) {
                logMetacat.debug((Object)("Removing indexing queue task for docid: " + docid));
                this.indexingMap.remove(docid);
            }
        }
    }

    static {
        int numIndexingThreads = 0;
        try {
            numIndexingThreads = Integer.parseInt(PropertyService.getProperty("database.numberOfIndexingThreads"));
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("Could not get property in static block: " + pnfe.getMessage()));
        }
        NUMBEROFINDEXINGTHREADS = numIndexingThreads;
    }
}

