/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.ArchiveHandler;
import edu.ucsb.nceas.metacat.EML201DocumentCorrector;
import edu.ucsb.nceas.metacat.ErrorHandledException;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.IndexingQueue;
import edu.ucsb.nceas.metacat.IndexingTimerTask;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.MetacatHandler;
import edu.ucsb.nceas.metacat.MetacatVersion;
import edu.ucsb.nceas.metacat.ReadOnlyChecker;
import edu.ucsb.nceas.metacat.common.query.EnabledQueryEngines;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.database.DatabaseService;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.plugin.MetacatHandlerPlugin;
import edu.ucsb.nceas.metacat.plugin.MetacatHandlerPluginManager;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.properties.SkinPropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.service.XMLSchemaService;
import edu.ucsb.nceas.metacat.shared.BaseException;
import edu.ucsb.nceas.metacat.shared.HandlerException;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.spatial.SpatialHarvester;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.ConfigurationUtil;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.ErrorSendingErrorException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.ResponseUtil;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.metacat.workflow.WorkflowSchedulerClient;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.UtilException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class MetaCatServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Timer timer = null;
    private static boolean _firstHalfInitialized = false;
    private static boolean _fullyInitialized = false;
    private MetacatHandler handler = null;
    public static final String SCHEMALOCATIONKEYWORD = ":schemaLocation";
    public static final String NONAMESPACELOCATION = ":noNamespaceSchemaLocation";
    public static final String EML2KEYWORD = ":eml";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static String LOG_CONFIG_NAME = null;
    public static final String APPLICATION_NAME = "metacat";
    public static final String DEFAULT_ENCODING = "UTF-8";

    public void init(ServletConfig config) throws ServletException {
        Logger logMetacat = Logger.getLogger(MetaCatServlet.class);
        try {
            if (_firstHalfInitialized) {
                return;
            }
            super.init(config);
            ServletContext context = config.getServletContext();
            context.setAttribute("APPLICATION_NAME", (Object)APPLICATION_NAME);
            ServiceService serviceService = ServiceService.getInstance(context);
            logMetacat.debug((Object)("MetaCatServlet.init - ServiceService singleton created " + serviceService));
            String dirPath = ServiceService.getRealConfigDir();
            LOG_CONFIG_NAME = dirPath + "/log4j.properties";
            PropertyConfigurator.configureAndWatch((String)LOG_CONFIG_NAME);
            ServiceService.registerService("PropertyService", PropertyService.getInstance(context));
            ServiceService.registerService("SkinPropertyService", SkinPropertyService.getInstance());
            ServiceService.registerService("SessionService", SessionService.getInstance());
            if (!ConfigurationUtil.bypassConfiguration() && !ConfigurationUtil.isMetacatConfigured()) {
                return;
            }
            _firstHalfInitialized = true;
            this.initSecondHalf(context);
        }
        catch (ServiceException se) {
            String errorMessage = "Service problem while intializing MetaCat Servlet: " + se.getMessage();
            logMetacat.error((Object)("MetaCatServlet.init - " + errorMessage));
            throw new ServletException(errorMessage);
        }
        catch (MetacatUtilException mue) {
            String errorMessage = "Metacat utility problem while intializing MetaCat Servlet: " + mue.getMessage();
            logMetacat.error((Object)("MetaCatServlet.init - " + errorMessage));
            throw new ServletException(errorMessage);
        }
    }

    public void initSecondHalf(ServletContext context) throws ServletException {
        Logger logMetacat = Logger.getLogger(MetaCatServlet.class);
        try {
            ServiceService.registerService("DatabaseService", DatabaseService.getInstance());
            DBConnectionPool connPool = DBConnectionPool.getInstance();
            logMetacat.debug((Object)("MetaCatServlet.initSecondHalf - DBConnection pool initialized: " + connPool.toString()));
            ServiceService.registerService("XMLSchemaService", XMLSchemaService.getInstance());
            String correctedEML201Doc = PropertyService.getProperty("document.eml201DocumentCorrected");
            if (correctedEML201Doc != null && correctedEML201Doc.equals(FALSE)) {
                logMetacat.info((Object)"MetaCatServlet.initSecondHalf - Start to correct eml201 documents");
                EML201DocumentCorrector correct = new EML201DocumentCorrector();
                boolean success = correct.run();
                if (success) {
                    PropertyService.setProperty("document.eml201DocumentCorrected", TRUE);
                }
                logMetacat.info((Object)"MetaCatServlet.initSecondHalf - Finish to correct eml201 documents");
            }
            this.checkIndexPaths();
            IndexingQueue.getInstance();
            int indexingTimerTaskTime = Integer.parseInt(PropertyService.getProperty("database.indexingTimerTaskTime"));
            int delayTime = Integer.parseInt(PropertyService.getProperty("database.indexingInitialDelay"));
            if (indexingTimerTaskTime > 0) {
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new IndexingTimerTask(), delayTime, (long)indexingTimerTaskTime);
            }
            if (PropertyService.getProperty("spatial.runSpatialOption").equals(TRUE) && PropertyService.getProperty("spatial.regenerateCacheOnRestart").equals(TRUE)) {
                long before = System.currentTimeMillis();
                SpatialHarvester sh = new SpatialHarvester();
                sh.regenerate();
                sh.destroy();
                PropertyService.setProperty("spatial.regenerateCacheOnRestart", FALSE);
                long after = System.currentTimeMillis();
                logMetacat.info((Object)("MetaCatServlet.initSecondHalf - Spatial Harvester Time  " + (after - before) + "ms"));
            } else {
                logMetacat.info((Object)"MetaCatServlet.initSecondHalf - Spatial cache is not set to regenerate on restart");
            }
            String replicationLogPath = PropertyService.getProperty("replication.logdir") + FileUtil.getFS() + "metacatreplication.log";
            if (FileUtil.getFileStatus((String)replicationLogPath) == FileUtil.DOES_NOT_EXIST) {
                FileUtil.createFile((String)replicationLogPath);
            }
            if (FileUtil.getFileStatus((String)replicationLogPath) < FileUtil.EXISTS_READ_WRITABLE) {
                logMetacat.error((Object)("MetaCatServlet.initSecondHalf - Replication log file: " + replicationLogPath + " does not exist read/writable."));
            }
            System.setProperty("replication.logfile.name", replicationLogPath);
            PropertyConfigurator.configureAndWatch((String)LOG_CONFIG_NAME);
            SessionService.getInstance().unRegisterAllSessions();
            this.handler = new MetacatHandler(this.timer);
            this.handler.set_sitemapScheduled(false);
            MetacatHandlerPluginManager.getInstance();
            ServiceService.registerService("HazelcastService", HazelcastService.getInstance());
            _fullyInitialized = true;
            logMetacat.warn((Object)("MetaCatServlet.initSecondHalf - Metacat (" + MetacatVersion.getVersionID() + ") initialized."));
        }
        catch (SQLException e) {
            String errorMessage = "SQL problem while intializing MetaCat Servlet: " + e.getMessage();
            logMetacat.error((Object)("MetaCatServlet.initSecondHalf - " + errorMessage));
            throw new ServletException(errorMessage);
        }
        catch (IOException ie) {
            String errorMessage = "IO problem while intializing MetaCat Servlet: " + ie.getMessage();
            logMetacat.error((Object)("MetaCatServlet.initSecondHalf - " + errorMessage));
            throw new ServletException(errorMessage);
        }
        catch (GeneralPropertyException gpe) {
            String errorMessage = "Could not retrieve property while intializing MetaCat Servlet: " + gpe.getMessage();
            logMetacat.error((Object)("MetaCatServlet.initSecondHalf - " + errorMessage));
            throw new ServletException(errorMessage);
        }
        catch (ServiceException se) {
            String errorMessage = "Service problem while intializing MetaCat Servlet: " + se.getMessage();
            logMetacat.error((Object)("MetaCatServlet.initSecondHalf - " + errorMessage));
            throw new ServletException(errorMessage);
        }
        catch (UtilException ue) {
            String errorMessage = "Utility problem while intializing MetaCat Servlet: " + ue.getMessage();
            logMetacat.error((Object)("MetaCatServlet.initSecondHalf - " + errorMessage));
            throw new ServletException(errorMessage);
        }
    }

    public void destroy() {
        Logger logMetacat = Logger.getLogger(MetaCatServlet.class);
        ServiceService.stopAllServices();
        logMetacat.warn((Object)"MetaCatServlet.destroy - Destroying MetacatServlet");
        this.timer.cancel();
        IndexingQueue.getInstance().setMetacatRunning(false);
        DBConnectionPool.release();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndexPaths() {
        Logger logMetacat = Logger.getLogger(MetaCatServlet.class);
        logMetacat.debug((Object)"MetaCatServlet.checkIndexPaths - starting....");
        if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
            logMetacat.info((Object)"MetaCatServlet.checkIndexPaths - the pathquery is disabled and it does nothing for checking path_index");
            return;
        }
        logMetacat.debug((Object)"MetaCatServlet.checkIndexPaths - after checking is the pathquery enabled or not...");
        Vector<String> pathsForIndexing = null;
        try {
            pathsForIndexing = SystemUtil.getPathsForIndexing();
        }
        catch (MetacatUtilException ue) {
            pathsForIndexing = null;
            logMetacat.error((Object)("MetaCatServlet.checkIndexPaths - not find index paths.  Setting pathsForIndexing to null: " + ue.getMessage()));
        }
        if (pathsForIndexing != null && !pathsForIndexing.isEmpty()) {
            logMetacat.debug((Object)"MetaCatServlet.checkIndexPaths - Indexing paths specified in metacat.properties....");
            DBConnection conn = null;
            int serialNumber = -1;
            PreparedStatement pstmt = null;
            PreparedStatement pstmt1 = null;
            ResultSet rs = null;
            for (String pathIndex : pathsForIndexing) {
                logMetacat.debug((Object)("MetaCatServlet.checkIndexPaths - Checking if '" + pathIndex + "' is indexed.... "));
                try {
                    conn = DBConnectionPool.getDBConnection("MetaCatServlet.checkIndexPaths");
                    serialNumber = conn.getCheckOutSerialNumber();
                    pstmt = conn.prepareStatement("SELECT * FROM xml_path_index WHERE path = ?");
                    pstmt.setString(1, pathIndex);
                    pstmt.execute();
                    rs = pstmt.getResultSet();
                    if (!rs.next()) {
                        logMetacat.debug((Object)"MetaCatServlet.checkIndexPaths - not indexed yet.");
                        rs.close();
                        pstmt.close();
                        conn.increaseUsageCount(1);
                        logMetacat.debug((Object)("MetaCatServlet.checkIndexPaths - Inserting following path in xml_path_index: " + pathIndex));
                        pstmt = pathIndex.indexOf("@") < 0 ? conn.prepareStatement("SELECT DISTINCT n.docid, n.nodedata, n.nodedatanumerical, n.nodedatadate, n.parentnodeid FROM xml_nodes n, xml_index i WHERE i.path = ? and n.parentnodeid=i.nodeid and n.nodetype LIKE 'TEXT' order by n.parentnodeid") : conn.prepareStatement("SELECT DISTINCT n.docid, n.nodedata, n.nodedatanumerical, n.nodedatadate, n.parentnodeid FROM xml_nodes n, xml_index i WHERE i.path = ? and n.nodeid=i.nodeid and n.nodetype LIKE 'ATTRIBUTE' order by n.parentnodeid");
                        pstmt.setString(1, pathIndex);
                        pstmt.execute();
                        rs = pstmt.getResultSet();
                        int count = 0;
                        logMetacat.debug((Object)("MetaCatServlet.checkIndexPaths - Executed the select statement for: " + pathIndex));
                        try {
                            while (rs.next()) {
                                String docid = rs.getString(1);
                                String nodedata = rs.getString(2);
                                float nodedatanumerical = rs.getFloat(3);
                                Timestamp nodedatadate = rs.getTimestamp(4);
                                int parentnodeid = rs.getInt(5);
                                if (nodedata.trim().equals("")) continue;
                                pstmt1 = conn.prepareStatement("INSERT INTO xml_path_index (docid, path, nodedata, nodedatanumerical, nodedatadate, parentnodeid) VALUES (?, ?, ?, ?, ?, ?)");
                                pstmt1.setString(1, docid);
                                pstmt1.setString(2, pathIndex);
                                pstmt1.setString(3, nodedata);
                                pstmt1.setFloat(4, nodedatanumerical);
                                pstmt1.setTimestamp(5, nodedatadate);
                                pstmt1.setInt(6, parentnodeid);
                                pstmt1.execute();
                                pstmt1.close();
                                ++count;
                            }
                        }
                        catch (Exception e) {
                            logMetacat.error((Object)("MetaCatServlet.checkIndexPaths - Exception:" + e.getMessage()));
                            e.printStackTrace();
                        }
                        rs.close();
                        pstmt.close();
                        conn.increaseUsageCount(1);
                        logMetacat.info((Object)("MetaCatServlet.checkIndexPaths - Indexed " + count + " records from xml_nodes for '" + pathIndex + "'"));
                    } else {
                        logMetacat.debug((Object)"MetaCatServlet.checkIndexPaths - already indexed.");
                    }
                    rs.close();
                    pstmt.close();
                    conn.increaseUsageCount(1);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("MetaCatServlet.checkIndexPaths - Error in MetaCatServlet.checkIndexPaths: " + e.getMessage()));
                }
                finally {
                    DBConnectionPool.returnDBConnection(conn, serialNumber);
                }
            }
            logMetacat.debug((Object)"MetaCatServlet.checkIndexPaths - Path Indexing Completed");
        }
    }

    private void handleGetOrPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Logger logMetacat = Logger.getLogger(MetaCatServlet.class);
        String requestEncoding = request.getCharacterEncoding();
        if (requestEncoding == null) {
            logMetacat.debug((Object)"null requestEncoding, setting to application default: UTF-8");
            request.setCharacterEncoding(DEFAULT_ENCODING);
        }
        logMetacat.debug((Object)("requestEncoding: " + requestEncoding));
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            SessionService.getInstance().touchSession(httpSession.getId());
        }
        if (!ConfigurationUtil.isMetacatConfigured()) {
            try {
                RequestUtil.forwardRequest(request, response, "/admin?action=configure", null);
                return;
            }
            catch (MetacatUtilException mue) {
                logMetacat.error((Object)("MetacatServlet.handleGetOrPost - utility error when forwarding to configuration screen: " + mue.getMessage()));
                throw new ServletException("MetacatServlet.handleGetOrPost - utility error when forwarding to configuration screen: " + mue.getMessage());
            }
        }
        logMetacat.info((Object)("MetacatServlet.handleGetOrPost - the _fullyInitailzied value is " + _fullyInitialized));
        if (!_fullyInitialized) {
            this.initSecondHalf(request.getSession().getServletContext());
        }
        DBConnectionPool.shrinkDBConnectionPoolSize();
        try {
            DBConnectionPool mue = DBConnectionPool.getInstance();
        }
        catch (SQLException e) {
            logMetacat.error((Object)("MetaCatServlet.handleGetOrPost - Error in MetacatServlet.handleGetOrPost: " + e.getMessage()));
            e.printStackTrace();
        }
        try {
            String cleanMessage;
            Writer out;
            Writer out2;
            String[] path;
            String ctype = request.getContentType();
            if (ctype != null && ctype.startsWith("multipart/form-data")) {
                if (MetaCatServlet.isReadOnly(response)) {
                    return;
                }
                this.handler.handleMultipartForm(request, response);
                return;
            }
            String name = null;
            String[] value = null;
            String[] docid = new String[3];
            Hashtable<String, String[]> params = new Hashtable<String, String[]>();
            String pathInfo = request.getPathInfo();
            if (pathInfo != null && (path = pathInfo.split("/")).length > 1) {
                String docidToRead = path[1];
                String[] docs = new String[]{docidToRead};
                logMetacat.debug((Object)("MetaCatServlet.handleGetOrPost - READING DOCID FROM PATHINFO: " + docs[0]));
                params.put("docid", docs);
                String skin = null;
                if (path.length > 2) {
                    skin = path[2];
                    String[] skins = new String[]{skin};
                    params.put("qformat", skins);
                }
                if (!skin.equals("xml")) {
                    String uiContext = PropertyService.getProperty("ui.context");
                    String docidNoRev = DocumentUtil.getSmartDocId(docidToRead);
                    int rev = DocumentUtil.getRevisionFromAccessionNumber(docidToRead);
                    String pid = null;
                    try {
                        pid = IdentifierManager.getInstance().getGUID(docidNoRev, rev);
                        response.sendRedirect(SystemUtil.getServerURL() + "/" + uiContext + "/#view/" + pid);
                        return;
                    }
                    catch (McdbDocNotFoundException nfe) {
                        logMetacat.warn((Object)("Could not locate PID for docid: " + docidToRead), (Throwable)nfe);
                    }
                }
                this.handler.handleReadAction(params, request, response, "public", null, null);
                return;
            }
            Enumeration paramlist = request.getParameterNames();
            while (paramlist.hasMoreElements()) {
                name = (String)paramlist.nextElement();
                value = request.getParameterValues(name);
                if (name.endsWith(".y")) {
                    docid[0] = name.substring(0, name.length() - 2);
                    params.put("docid", docid);
                    name = "ypos";
                }
                if (name.endsWith(".x")) {
                    name = "xpos";
                }
                params.put(name, value);
            }
            if (params.isEmpty() || params == null) {
                return;
            }
            if (params.get("action") == null) {
                PrintWriter out3 = response.getWriter();
                response.setContentType("text/xml");
                out3.println("<?xml version=\"1.0\"?>");
                out3.println("<error>");
                out3.println("Action not specified");
                out3.println("</error>");
                out3.close();
                return;
            }
            String action = ((String[])params.get("action"))[0];
            logMetacat.info((Object)("MetaCatServlet.handleGetOrPost - Action is: " + action));
            String userName = null;
            String password = null;
            String[] groupNames = null;
            String sessionId = null;
            name = null;
            if (action.equals("login")) {
                out2 = new OutputStreamWriter((OutputStream)response.getOutputStream(), DEFAULT_ENCODING);
                this.handler.handleLoginAction(out2, params, request, response);
                out2.close();
            } else if (action.equals("logout")) {
                out2 = new OutputStreamWriter((OutputStream)response.getOutputStream(), DEFAULT_ENCODING);
                this.handler.handleLogoutAction(out2, params, request, response);
                out2.close();
            } else if (action.equals("validatesession")) {
                String token = request.getHeader("Authorization");
                if (token != null && !token.equals("")) {
                    out = new OutputStreamWriter((OutputStream)response.getOutputStream(), DEFAULT_ENCODING);
                    SessionData sessionData = RequestUtil.getSessionData(request);
                    response.setContentType("text/xml");
                    out.write("<?xml version=\"1.0\"?>");
                    out.write("<validateSession><status>");
                    if (sessionData != null) {
                        out.write("valid");
                    } else {
                        out.write("invalid");
                    }
                    out.write("</status>");
                    if (sessionData != null) {
                        out.write("<userInformation>");
                        out.write("<name>");
                        out.write(sessionData.getUserName());
                        out.write("</name>");
                        out.write("<fullName>");
                        out.write(sessionData.getName());
                        out.write("</fullName>");
                        String[] groups = sessionData.getGroupNames();
                        if (groups != null) {
                            for (String groupName : groups) {
                                out.write("<group>");
                                out.write(groupName);
                                out.write("</group>");
                            }
                        }
                        out.write("</userInformation>");
                    }
                    out.write("<sessionId>" + sessionId + "</sessionId></validateSession>");
                    out.close();
                } else {
                    out = new OutputStreamWriter((OutputStream)response.getOutputStream(), DEFAULT_ENCODING);
                    String idToValidate = null;
                    String[] idsToValidate = params.get("sessionid");
                    if (idsToValidate != null) {
                        idToValidate = idsToValidate[0];
                    } else {
                        SessionData sessionData = RequestUtil.getSessionData(request);
                        if (sessionData != null) {
                            idToValidate = sessionData.getId();
                        }
                    }
                    SessionService.getInstance().validateSession(out, response, idToValidate);
                    out.close();
                }
            } else {
                SessionData sessionData = RequestUtil.getSessionData(request);
                if (sessionData != null) {
                    userName = sessionData.getUserName();
                    password = sessionData.getPassword();
                    groupNames = sessionData.getGroupNames();
                    sessionId = sessionData.getId();
                }
                logMetacat.info((Object)("MetaCatServlet.handleGetOrPost - The user is : " + userName));
            }
            if (action.equals("query")) {
                out2 = new OutputStreamWriter((OutputStream)response.getOutputStream(), DEFAULT_ENCODING);
                this.handler.handleQuery(out2, params, response, userName, groupNames, sessionId);
                out2.close();
            } else if (action.equals("squery")) {
                out2 = new OutputStreamWriter((OutputStream)response.getOutputStream(), DEFAULT_ENCODING);
                if (params.containsKey("query")) {
                    this.handler.handleSQuery(out2, params, response, userName, groupNames, sessionId);
                    out2.close();
                } else {
                    out2.write("Illegal action squery without \"query\" parameter");
                    out2.close();
                }
            } else if (action.trim().equals("spatial_query")) {
                logMetacat.debug((Object)"MetaCatServlet.handleGetOrPost - ******************* SPATIAL QUERY ********************");
                out2 = new OutputStreamWriter((OutputStream)response.getOutputStream(), DEFAULT_ENCODING);
                this.handler.handleSpatialQuery(out2, params, response, userName, groupNames, sessionId);
                out2.close();
            } else if (action.trim().equals("dataquery")) {
                logMetacat.debug((Object)"MetaCatServlet.handleGetOrPost - ******************* DATA QUERY ********************");
                this.handler.handleDataquery(params, response, sessionId);
            } else if (action.trim().equals("editcart")) {
                logMetacat.debug((Object)"MetaCatServlet.handleGetOrPost - ******************* EDIT CART ********************");
                this.handler.handleEditCart(params, response, sessionId);
            } else if (action.equals("export")) {
                this.handler.handleExportAction(params, response, userName, groupNames, password);
            } else if (action.equals("read")) {
                if (params.get("archiveEntryName") != null) {
                    ArchiveHandler.getInstance().readArchiveEntry(params, request, response, userName, password, groupNames);
                } else {
                    this.handler.handleReadAction(params, request, response, userName, password, groupNames);
                }
            } else if (action.equals("readinlinedata")) {
                this.handler.handleReadInlineDataAction(params, request, response, userName, password, groupNames);
            } else if (action.equals("insert") || action.equals("update")) {
                if (MetaCatServlet.isReadOnly(response)) {
                    return;
                }
                out2 = response.getWriter();
                if (userName != null && !userName.equals("public")) {
                    String formatId = null;
                    this.handler.handleInsertOrUpdateAction(request.getRemoteAddr(), request.getHeader("User-Agent"), response, (PrintWriter)out2, params, userName, groupNames, true, true, null, formatId);
                } else {
                    response.setContentType("text/xml");
                    ((PrintWriter)out2).println("<?xml version=\"1.0\"?>");
                    ((PrintWriter)out2).println("<error>");
                    cleanMessage = StringEscapeUtils.escapeXml((String)("Permission denied for user " + userName + " " + action));
                    ((PrintWriter)out2).println(cleanMessage);
                    ((PrintWriter)out2).println("</error>");
                }
                ((PrintWriter)out2).close();
            } else if (action.equals("delete")) {
                if (MetaCatServlet.isReadOnly(response)) {
                    return;
                }
                out2 = response.getWriter();
                if (userName != null && !userName.equals("public")) {
                    this.handler.handleDeleteAction((PrintWriter)out2, params, request, response, userName, groupNames);
                } else {
                    response.setContentType("text/xml");
                    ((PrintWriter)out2).println("<?xml version=\"1.0\"?>");
                    ((PrintWriter)out2).println("<error>");
                    cleanMessage = StringEscapeUtils.escapeXml((String)("Permission denied for " + action));
                    ((PrintWriter)out2).println(cleanMessage);
                    ((PrintWriter)out2).println("</error>");
                }
                ((PrintWriter)out2).close();
            } else if (action.equals("validate")) {
                out2 = response.getWriter();
                this.handler.handleValidateAction((PrintWriter)out2, params);
                ((PrintWriter)out2).close();
            } else if (action.equals("setaccess")) {
                if (MetaCatServlet.isReadOnly(response)) {
                    return;
                }
                out2 = response.getWriter();
                this.handler.handleSetAccessAction((PrintWriter)out2, params, userName, request, response);
                ((PrintWriter)out2).close();
            } else if (action.equals("getaccesscontrol")) {
                out2 = response.getWriter();
                this.handler.handleGetAccessControlAction((PrintWriter)out2, params, response, userName, groupNames);
                ((PrintWriter)out2).close();
            } else if (action.equals("isauthorized")) {
                out2 = response.getWriter();
                DocumentUtil.isAuthorized((PrintWriter)out2, params, request, response);
                ((PrintWriter)out2).close();
            } else if (action.equals("getprincipals")) {
                out2 = new OutputStreamWriter((OutputStream)response.getOutputStream(), DEFAULT_ENCODING);
                this.handler.handleGetPrincipalsAction(out2, userName, password);
                out2.close();
            } else if (action.equals("getdoctypes")) {
                out2 = response.getWriter();
                this.handler.handleGetDoctypesAction((PrintWriter)out2, params, response);
                ((PrintWriter)out2).close();
            } else if (action.equals("getdtdschema")) {
                out2 = response.getWriter();
                this.handler.handleGetDTDSchemaAction((PrintWriter)out2, params, response);
                ((PrintWriter)out2).close();
            } else if (action.equals("getdocid")) {
                this.handler.handleGetDocid(params, response);
            } else if (action.equals("getlastdocid")) {
                out2 = response.getWriter();
                this.handler.handleGetMaxDocidAction((PrintWriter)out2, params, response);
                ((PrintWriter)out2).close();
            } else if (action.equals("getalldocids")) {
                out2 = response.getWriter();
                this.handler.handleGetAllDocidsAction((PrintWriter)out2, params, response);
                ((PrintWriter)out2).close();
            } else if (action.equals("isregistered")) {
                out2 = response.getWriter();
                this.handler.handleIdIsRegisteredAction((PrintWriter)out2, params, response);
                ((PrintWriter)out2).close();
            } else if (action.equals("getrevisionanddoctype")) {
                out2 = response.getWriter();
                this.handler.handleGetRevisionAndDocTypeAction((PrintWriter)out2, params);
                ((PrintWriter)out2).close();
            } else if (action.equals("getversion")) {
                response.setContentType("text/xml");
                out2 = response.getWriter();
                ((PrintWriter)out2).println(MetacatVersion.getVersionAsXml());
                ((PrintWriter)out2).close();
            } else if (action.equals("getlog")) {
                this.handler.handleGetLogAction(params, request, response, userName, groupNames, sessionId);
            } else if (action.equals("getloggedinuserinfo")) {
                out2 = response.getWriter();
                response.setContentType("text/xml");
                ((PrintWriter)out2).println("<?xml version=\"1.0\"?>");
                ((PrintWriter)out2).println("\n<user>\n");
                ((PrintWriter)out2).println("\n<username>\n");
                ((PrintWriter)out2).println(userName);
                ((PrintWriter)out2).println("\n</username>\n");
                if (name != null) {
                    ((PrintWriter)out2).println("\n<name>\n");
                    ((PrintWriter)out2).println(name);
                    ((PrintWriter)out2).println("\n</name>\n");
                }
                if (AuthUtil.isAdministrator(userName, groupNames)) {
                    ((PrintWriter)out2).println("<isAdministrator></isAdministrator>\n");
                }
                if (AuthUtil.isModerator(userName, groupNames)) {
                    ((PrintWriter)out2).println("<isModerator></isModerator>\n");
                }
                ((PrintWriter)out2).println("\n</user>\n");
                ((PrintWriter)out2).close();
            } else if (action.equals("buildindex")) {
                if (MetaCatServlet.isReadOnly(response)) {
                    return;
                }
                this.handler.handleBuildIndexAction(params, request, response, userName, groupNames);
            } else if (action.equals("reindex")) {
                if (MetaCatServlet.isReadOnly(response)) {
                    return;
                }
                this.handler.handleReindexAction(params, request, response, userName, groupNames);
            } else if (action.equals("reindexall")) {
                if (MetaCatServlet.isReadOnly(response)) {
                    return;
                }
                this.handler.handleReindexAllAction(params, request, response, userName, groupNames);
            } else if (!action.equals("login") && !action.equals("logout")) {
                if (action.equals("refreshServices")) {
                    ServiceService.refreshService("XMLSchemaService");
                    return;
                }
                if (action.equals("scheduleWorkflow")) {
                    if (MetaCatServlet.isReadOnly(response)) {
                        return;
                    }
                    try {
                        WorkflowSchedulerClient.getInstance().scheduleJob(request, response, params, userName, groupNames);
                        return;
                    }
                    catch (BaseException be) {
                        ResponseUtil.sendErrorXML(response, ResponseUtil.SCHEDULE_WORKFLOW_ERROR, be);
                        return;
                    }
                }
                if (action.equals("unscheduleWorkflow")) {
                    if (MetaCatServlet.isReadOnly(response)) {
                        return;
                    }
                    try {
                        WorkflowSchedulerClient.getInstance().unScheduleJob(request, response, params, userName, groupNames);
                        return;
                    }
                    catch (BaseException be) {
                        ResponseUtil.sendErrorXML(response, ResponseUtil.UNSCHEDULE_WORKFLOW_ERROR, be);
                        return;
                    }
                }
                if (action.equals("rescheduleWorkflow")) {
                    if (MetaCatServlet.isReadOnly(response)) {
                        return;
                    }
                    try {
                        WorkflowSchedulerClient.getInstance().reScheduleJob(request, response, params, userName, groupNames);
                        return;
                    }
                    catch (BaseException be) {
                        ResponseUtil.sendErrorXML(response, ResponseUtil.RESCHEDULE_WORKFLOW_ERROR, be);
                        return;
                    }
                }
                if (action.equals("getScheduledWorkflow")) {
                    try {
                        WorkflowSchedulerClient.getInstance().getJobs(request, response, params, userName, groupNames);
                        return;
                    }
                    catch (BaseException be) {
                        ResponseUtil.sendErrorXML(response, ResponseUtil.GET_SCHEDULED_WORKFLOW_ERROR, be);
                        return;
                    }
                }
                if (action.equals("deleteScheduledWorkflow")) {
                    if (MetaCatServlet.isReadOnly(response)) {
                        return;
                    }
                    try {
                        WorkflowSchedulerClient.getInstance().deleteJob(request, response, params, userName, groupNames);
                        return;
                    }
                    catch (BaseException be) {
                        ResponseUtil.sendErrorXML(response, ResponseUtil.DELETE_SCHEDULED_WORKFLOW_ERROR, be);
                        return;
                    }
                }
                if (action.equals("shrink")) {
                    out2 = response.getWriter();
                    if (!AuthUtil.isAdministrator(userName, groupNames)) {
                        ((PrintWriter)out2).println("The user " + userName + " is not the administrator of the Metacat and doesn't have the permission to call the method.");
                        ((PrintWriter)out2).close();
                        return;
                    }
                    boolean success = false;
                    success = DBConnectionPool.shrinkConnectionPoolSize();
                    if (success) {
                        ((PrintWriter)out2).println("DBConnection Pool shrunk successfully.");
                    } else {
                        ((PrintWriter)out2).println("DBConnection pool did not shrink successfully.");
                    }
                    ((PrintWriter)out2).close();
                } else {
                    MetacatHandlerPlugin handlerPlugin = MetacatHandlerPluginManager.getInstance().getHandler(action);
                    if (handlerPlugin != null) {
                        if (MetaCatServlet.isReadOnly(response)) {
                            return;
                        }
                        handlerPlugin.handleAction(action, params, request, response, userName, groupNames, sessionId);
                    } else {
                        out = response.getWriter();
                        ((PrintWriter)out).println("<?xml version=\"1.0\"?>");
                        ((PrintWriter)out).println("<error>");
                        String cleanMessage2 = StringEscapeUtils.escapeXml((String)("Error: action: " + action + " not registered.  Please report this error."));
                        ((PrintWriter)out).println(cleanMessage2);
                        ((PrintWriter)out).println("</error>");
                        ((PrintWriter)out).close();
                    }
                }
            }
            this.handler.scheduleSitemapGeneration(request);
        }
        catch (PropertyNotFoundException pnfe) {
            String errorString = "Critical property not found: " + pnfe.getMessage();
            logMetacat.error((Object)("MetaCatServlet.handleGetOrPost - " + errorString));
            throw new ServletException(errorString);
        }
        catch (MetacatUtilException ue) {
            String errorString = "Utility error: " + ue.getMessage();
            logMetacat.error((Object)("MetaCatServlet.handleGetOrPost - " + errorString));
            throw new ServletException(errorString);
        }
        catch (ServiceException ue) {
            String errorString = "Service error: " + ue.getMessage();
            logMetacat.error((Object)("MetaCatServlet.handleGetOrPost - " + errorString));
            throw new ServletException(errorString);
        }
        catch (HandlerException he) {
            String errorString = "Handler error: " + he.getMessage();
            logMetacat.error((Object)("MetaCatServlet.handleGetOrPost - " + errorString));
            throw new ServletException(errorString);
        }
        catch (ErrorSendingErrorException esee) {
            String errorString = "Error sending error message: " + esee.getMessage();
            logMetacat.error((Object)("MetaCatServlet.handleGetOrPost - " + errorString));
            throw new ServletException(errorString);
        }
        catch (ErrorHandledException errorHandledException) {
            // empty catch block
        }
    }

    public static boolean isFullyInitialized() {
        return _fullyInitialized;
    }

    public static boolean isReadOnly(HttpServletResponse response) throws IOException {
        boolean readOnly = false;
        ReadOnlyChecker checker = new ReadOnlyChecker();
        readOnly = checker.isReadOnly();
        if (readOnly) {
            PrintWriter out = response.getWriter();
            response.setContentType("text/xml");
            out.println("<?xml version=\"1.0\"?>");
            out.println("<error>");
            out.println("The Metacat is on the read-only mode and your request can't be fulfiled. Please try again later.");
            out.println("</error>");
            out.close();
        }
        return readOnly;
    }
}

