/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade;

import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.dataone.DOIService;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;

public class UpdateDOI
implements UpgradeUtilityInterface {
    private static Log log = LogFactory.getLog(UpdateDOI.class);
    private int serverLocation = 1;

    public int getServerLocation() {
        return this.serverLocation;
    }

    public void setServerLocation(int serverLocation) {
        this.serverLocation = serverLocation;
    }

    private void updateDOIRegistration(List<String> identifiers) {
        String prefix = "doi:";
        for (String pid : identifiers) {
            try {
                if (!pid.startsWith(prefix)) continue;
                Identifier identifier = new Identifier();
                identifier.setValue(pid);
                SystemMetadata sysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)identifier);
                DOIService.getInstance().registerDOI(sysMeta);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean upgrade() throws AdminException {
        boolean success = true;
        try {
            Vector<String> idList = null;
            idList = DBUtil.getAllDocidsByType(DocumentImpl.EML2_0_0NAMESPACE, true, this.serverLocation);
            Collections.sort(idList);
            this.updateDOIRegistration(idList);
            idList = DBUtil.getAllDocidsByType(DocumentImpl.EML2_0_1NAMESPACE, true, this.serverLocation);
            Collections.sort(idList);
            this.updateDOIRegistration(idList);
            idList = DBUtil.getAllDocidsByType(DocumentImpl.EML2_1_0NAMESPACE, true, this.serverLocation);
            Collections.sort(idList);
            this.updateDOIRegistration(idList);
            idList = DBUtil.getAllDocidsByType(DocumentImpl.EML2_1_1NAMESPACE, true, this.serverLocation);
            Collections.sort(idList);
            this.updateDOIRegistration(idList);
        }
        catch (Exception e) {
            String msg = "Problem updating DOIs: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            success = false;
            throw new AdminException(msg);
        }
        return success;
    }

    public boolean upgradeById(List<String> ids) throws AdminException {
        boolean success = true;
        try {
            this.updateDOIRegistration(ids);
        }
        catch (Exception e) {
            String msg = "Problem updating DOIs: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            success = false;
            throw new AdminException(msg);
        }
        return success;
    }

    public boolean upgradeByFormatId(List<String> formatIds) throws AdminException {
        boolean success = true;
        ArrayList<String> idList = new ArrayList<String>();
        try {
            for (String formatId : formatIds) {
                Vector<String> docids = DBUtil.getAllDocidsByType(formatId, true, this.serverLocation);
                for (String id : docids) {
                    String docid = DocumentUtil.getDocIdFromAccessionNumber(id);
                    int rev = DocumentUtil.getRevisionFromAccessionNumber(id);
                    String guid = IdentifierManager.getInstance().getGUID(docid, rev);
                    idList.add(guid);
                }
                Collections.sort(idList);
                this.updateDOIRegistration(idList);
            }
        }
        catch (Exception e) {
            String msg = "Problem updating DOIs: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            success = false;
            throw new AdminException(msg);
        }
        return success;
    }
}

