/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.annotation;

import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OrcidService {
    private static Logger logMetacat = Logger.getLogger(OrcidService.class);
    private static final String REST_URL = "http://pub.orcid.org/v1.1/search/orcid-bio";

    public static String lookupOrcid(String text, String surName, List<String> givenNames, List<String> otherNames) {
        String url = null;
        try {
            String urlParameters = "";
            if (text != null) {
                urlParameters = urlParameters + "\"" + text + "\"";
            } else {
                if (surName != null) {
                    urlParameters = urlParameters + "+family-name:\"" + surName + "\"";
                }
                if (otherNames != null) {
                    for (String otherName : otherNames) {
                        urlParameters = urlParameters + "+other-names:\"" + otherName + "\"";
                    }
                }
                if (givenNames != null) {
                    for (String givenName : givenNames) {
                        urlParameters = urlParameters + "+given-names:\"" + givenName + "\"";
                    }
                }
            }
            urlParameters = URLEncoder.encode(urlParameters, "UTF-8");
            url = "http://pub.orcid.org/v1.1/search/orcid-bio?q=" + urlParameters + "&rows=1";
            URL restURL = new URL(url);
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(url);
            method.addRequestHeader("Accept", "application/orcid+xml");
            client.executeMethod((HttpMethod)method);
            InputStream is = method.getResponseBodyAsStream();
            String results = IOUtils.toString((InputStream)is, (String)"UTF-8");
            logMetacat.debug((Object)("RESULTS: " + results));
            Node doc = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)new StringReader(results));
            Node orcidUriNodeList = XMLUtilities.getNodeWithXPath((Node)doc, (String)"//*[local-name()=\"orcid-identifier\"]/*[local-name()=\"uri\"]");
            if (orcidUriNodeList != null) {
                String orcidUri = orcidUriNodeList.getFirstChild().getNodeValue();
                logMetacat.info((Object)("Found ORCID URI: " + orcidUri));
                return orcidUri;
            }
        }
        catch (Exception e) {
            logMetacat.error((Object)("Could not lookup ORCID using: " + url), (Throwable)e);
        }
        return null;
    }

    public static List<String> lookupCreators(boolean includeObsolete) {
        ArrayList<String> retList = null;
        try {
            MockHttpServletRequest request;
            InputStream results;
            Node rootNode;
            NodeList nodeList;
            String query = "q=-obsoletedBy:[* TO *]&rows=0&facet=true&facet.limit=-1&facet.field=origin";
            if (includeObsolete) {
                query = "q=*:*&rows=0&facet=true&facet.limit=-1&facet.field=origin";
            }
            if ((nodeList = XMLUtilities.getNodeListWithXPath((Node)(rootNode = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)new InputStreamReader(results = MNodeService.getInstance((HttpServletRequest)(request = new MockHttpServletRequest(null, null, null))).query(null, "solr", query), "UTF-8"))), (String)"//lst[@name=\"origin\"]/int/@name")) != null && nodeList.getLength() > 0) {
                retList = new ArrayList<String>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String found = nodeList.item(i).getFirstChild().getNodeValue();
                    retList.add(found);
                }
            }
        }
        catch (Exception e) {
            logMetacat.error((Object)("Error checking for creators[s]: " + e.getMessage()), (Throwable)e);
        }
        return retList;
    }
}

