/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.hazelcast;

import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapStore;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;

public class SystemMetadataMap
implements MapStore<Identifier, SystemMetadata>,
MapLoader<Identifier, SystemMetadata> {
    private Logger logMetacat = Logger.getLogger(SystemMetadataMap.class);

    public void delete(Identifier arg0) {
        if (arg0 != null) {
            this.logMetacat.debug((Object)("delete the identifier" + arg0.getValue()));
            boolean success = IdentifierManager.getInstance().deleteSystemMetadata(arg0.getValue());
            if (!success) {
                throw new RuntimeException("SystemMetadataMap.delete - the system metadata of guid - " + arg0.getValue() + " can't be removed successfully.");
            }
        }
    }

    public void deleteAll(Collection<Identifier> arg0) {
    }

    public void store(Identifier pid, SystemMetadata sm) {
        try {
            this.logMetacat.debug((Object)("Storing System Metadata to store: " + pid.getValue()));
            IdentifierManager.getInstance().insertOrUpdateSystemMetadata(sm);
        }
        catch (McdbDocNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvalidSystemMetadata e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void storeAll(Map<Identifier, SystemMetadata> map) {
        for (Identifier key : map.keySet()) {
            this.store(key, map.get(key));
        }
    }

    public SystemMetadata load(Identifier pid) {
        SystemMetadata sm = null;
        try {
            this.logMetacat.debug((Object)("loading from store: " + pid.getValue()));
            sm = IdentifierManager.getInstance().getSystemMetadata(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            this.logMetacat.warn((Object)("could not load system metadata for: " + pid.getValue()), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return sm;
    }

    public Map<Identifier, SystemMetadata> loadAll(Collection<Identifier> keys) {
        HashMap<Identifier, SystemMetadata> map = new HashMap<Identifier, SystemMetadata>();
        for (Identifier key : keys) {
            SystemMetadata value = this.load(key);
            map.put(key, value);
        }
        return map;
    }

    public Set<Identifier> loadAllKeys() {
        return null;
    }
}

