/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataquery;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;

public class MetacatEcogridEndPoint
implements EcogridEndPointInterface {
    private String metacatEcogridEndPoint = null;
    private String metacatEcogridAuthEndPoint = null;
    private String metacatEcogridPutEndPoint = null;
    private String metacatEcogridIdentifierEndPoint = null;
    private String srbEcogridEndPoint = null;
    private String srbMachineName = null;
    protected String baseURL = null;

    public MetacatEcogridEndPoint() {
        if (!this.loadProperties()) {
            try {
                this.baseURL = "http://" + PropertyService.getProperty("server.name") + ":" + PropertyService.getProperty("server.httpPort") + "/" + PropertyService.getProperty("application.context") + "/services/";
                this.metacatEcogridEndPoint = this.baseURL + "QueryService";
                this.metacatEcogridAuthEndPoint = this.baseURL + "AuthenticationService";
                this.metacatEcogridPutEndPoint = this.baseURL + "PutService";
                this.metacatEcogridIdentifierEndPoint = this.baseURL + "IdentificationService";
            }
            catch (PropertyNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean loadProperties() {
        try {
            this.metacatEcogridEndPoint = PropertyService.getProperty("datamanager.endpoint.query");
            this.metacatEcogridAuthEndPoint = PropertyService.getProperty("datamanager.endpoint.authentication");
            this.metacatEcogridPutEndPoint = PropertyService.getProperty("datamanager.endpoint.put");
            this.metacatEcogridIdentifierEndPoint = PropertyService.getProperty("datamanager.endpoint.identifier");
            this.srbEcogridEndPoint = PropertyService.getProperty("datamanager.srb.endpoint");
            this.srbMachineName = PropertyService.getProperty("datamanager.srb.machinename");
        }
        catch (PropertyNotFoundException e) {
            return false;
        }
        return this.metacatEcogridEndPoint != null && this.metacatEcogridEndPoint.length() != 0;
    }

    public String getMetacatEcogridEndPoint() {
        return this.metacatEcogridEndPoint;
    }

    public String getMetacatEcogridAuthEndPoint() {
        return this.metacatEcogridAuthEndPoint;
    }

    public String getMetacatEcogridPutEndPoint() {
        return this.metacatEcogridPutEndPoint;
    }

    public String getMetacatEcogridIdentifierEndPoint() {
        return this.metacatEcogridIdentifierEndPoint;
    }

    public String getSRBEcogridEndPoint() {
        return this.srbEcogridEndPoint;
    }

    public String getSRBMachineName() {
        return this.srbMachineName;
    }
}

