/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.dbadapter.AbstractDatabase;
import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.NodeRecord;
import edu.ucsb.nceas.metacat.PermissionController;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.utilities.LSIDUtil;
import edu.ucsb.nceas.utilities.ParseLSIDException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DocumentUtil {
    private static int documentIdCounter = 0;
    public static AbstractDatabase dbAdapter;
    private static Logger logMetacat;
    private static char separator;
    private static String prefix;

    public static String getDocIdWithRevFromOnlineURL(String url) {
        String docid = null;
        String DOCID = "docid";
        boolean find = false;
        char limited = '&';
        int count = 0;
        Vector<Integer> list = new Vector<Integer>();
        if (url == null) {
            logMetacat.debug((Object)"DocumentUtil.getDocIdWithRevFromOnlineURL - url is null and null will be returned");
            return docid;
        }
        list.add(new Integer(0));
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) != limited) continue;
            list.add(new Integer(i));
            String str = url.substring((Integer)list.elementAt(++count - 1), i);
            logMetacat.debug((Object)("DocumentUtil.getDocIdWithRevFromOnlineURL - substring between two & is: " + str));
            if (str.indexOf(DOCID) == -1) continue;
            int start = DocumentUtil.getIndexForGivenChar(str, '=') + 1;
            int end = str.length();
            docid = str.substring(start, end);
            find = true;
        }
        if (!find) {
            logMetacat.debug((Object)"DocumentUtil.getDocIdWithRevFromOnlineURL - Checking the last substring");
            String str = url.substring((Integer)list.elementAt(count) + 1, url.length());
            logMetacat.debug((Object)("DocumentUtil.getDocIdWithRevFromOnlineURL - Last substring is: " + str));
            if (str.indexOf(DOCID) != -1) {
                int start = DocumentUtil.getIndexForGivenChar(str, '=') + 1;
                int end = str.length();
                docid = str.substring(start, end);
                find = true;
            }
        }
        logMetacat.debug((Object)("DocumentUtil.getDocIdWithRevFromOnlineURL - The docid from online url is:" + docid));
        return docid.trim();
    }

    public static String getAccessionNumberFromEcogridIdentifier(String identifier) {
        String accessionNumber = null;
        if (identifier != null && identifier.startsWith("ecogrid://")) {
            int indexOfLastSlash = identifier.lastIndexOf("/");
            int start = indexOfLastSlash + 1;
            int end = identifier.length();
            accessionNumber = identifier.substring(start, end);
        }
        logMetacat.info((Object)("DocumentUtil.getAccessionNumberFromEcogridIdentifier - The accession number from url is " + accessionNumber));
        return accessionNumber;
    }

    private static int getIndexForGivenChar(String str, char character) {
        int index = -1;
        if (str == null) {
            logMetacat.debug((Object)"DocumentUtil.getIndexForGivenChar - The given str is null and -1 will be returned");
            return index;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != character) continue;
            index = i;
            break;
        }
        logMetacat.info((Object)("DocumentUtil.getIndexForGivenChar - the index for char " + character + " is: " + index));
        return index;
    }

    public static String getDocIdFromString(String str) {
        String docId = null;
        if (str == null) {
            logMetacat.debug((Object)"DocumentUtil.getDocIdFromString - The given str is null and null will be returned in getDocIdfromString");
            return docId;
        }
        int dotNumber = 0;
        int indexOfLastDot = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != separator) continue;
            ++dotNumber;
            indexOfLastDot = i;
        }
        if (dotNumber > 2 || dotNumber < 1) {
            docId = null;
        } else if (dotNumber == 2) {
            docId = str.substring(0, indexOfLastDot);
        } else if (dotNumber == 1) {
            docId = str;
        }
        return docId;
    }

    public static int getVersionFromString(String str) throws NumberFormatException {
        int version = -1;
        String versionString = null;
        int dotNumber = 0;
        int indexOfLastDot = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != separator) continue;
            ++dotNumber;
            indexOfLastDot = i;
        }
        if (dotNumber > 2 || dotNumber < 1) {
            version = -2;
        } else if (dotNumber == 2 && indexOfLastDot != str.length() - 1) {
            versionString = str.substring(indexOfLastDot + 1, str.length());
            version = Integer.parseInt(versionString);
        } else if (dotNumber == 1) {
            version = -1;
        }
        return version;
    }

    public static String getRevisionStringFromString(String str) throws NumberFormatException {
        String versionString = null;
        int dotNumber = 0;
        int indexOfLastDot = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != separator) continue;
            ++dotNumber;
            indexOfLastDot = i;
        }
        if (dotNumber > 2 || dotNumber < 1) {
            versionString = null;
        } else if (dotNumber == 2 && indexOfLastDot != str.length() - 1) {
            versionString = str.substring(indexOfLastDot + 1, str.length());
        } else if (dotNumber == 1) {
            versionString = null;
        }
        return versionString;
    }

    public static String appendRev(String docid) throws PropertyNotFoundException, SQLException, McdbDocNotFoundException {
        int lastIndex;
        String newAccNum = null;
        String separator = PropertyService.getProperty("document.accNumSeparator");
        int firstIndex = docid.indexOf(separator);
        if (firstIndex == (lastIndex = docid.lastIndexOf(separator))) {
            int rev = DBUtil.getLatestRevisionInDocumentTable(docid);
            if (rev == -1) {
                throw new McdbDocNotFoundException("the requested docid '" + docid + "' does not exist");
            }
            newAccNum = docid + separator + rev;
        } else {
            newAccNum = docid;
        }
        return newAccNum;
    }

    public static String getDocIdFromAccessionNumber(String accessionNumber) {
        String docid = null;
        if (accessionNumber == null) {
            return docid;
        }
        int indexOfLastSeperator = accessionNumber.lastIndexOf(separator);
        docid = accessionNumber.substring(0, indexOfLastSeperator);
        logMetacat.debug((Object)("DocumentUtil.getDocIdFromAccessionNumber - after parsing accession number, docid is " + docid));
        return docid;
    }

    public static String getInlineDataIdWithoutRev(String accessionNumber) {
        String docid = null;
        if (accessionNumber == null) {
            return docid;
        }
        int indexOfLastSeperator = accessionNumber.lastIndexOf(separator);
        String version = accessionNumber.substring(indexOfLastSeperator, accessionNumber.length());
        accessionNumber = accessionNumber.substring(0, indexOfLastSeperator);
        indexOfLastSeperator = accessionNumber.lastIndexOf(separator);
        docid = accessionNumber.substring(0, indexOfLastSeperator) + version;
        logMetacat.debug((Object)("DocumentUtil.getInlineDataIdWithoutRev - after parsing accessionnumber, docid is " + docid));
        return docid;
    }

    public static String getSmartDocId(String str) {
        String docid = null;
        docid = DocumentUtil.getDocIdFromString(str);
        if (docid == null) {
            docid = DocumentUtil.getDocIdFromAccessionNumber(str);
        }
        logMetacat.debug((Object)("DocumentUtil.getSmartDocId - The docid get from smart docid getor is " + docid));
        return docid;
    }

    public static int getRevisionFromAccessionNumber(String accessionNumber) throws NumberFormatException {
        String rev = null;
        int revNumber = -1;
        if (accessionNumber == null) {
            return revNumber;
        }
        int indexOfLastSeperator = accessionNumber.lastIndexOf(separator);
        rev = accessionNumber.substring(indexOfLastSeperator + 1, accessionNumber.length());
        revNumber = Integer.parseInt(rev);
        logMetacat.debug((Object)("DocumentUtil.getRevisionFromAccessionNumber - after parsing accessionnumber, rev is " + revNumber));
        return revNumber;
    }

    public static String getDocIdFromInlineDataID(String inlineDataID) {
        String docidWithoutRev = null;
        if (inlineDataID == null) {
            return docidWithoutRev;
        }
        char charSeperator = separator;
        int targetNumberOfSeperator = 3;
        int numberOfSeperator = 0;
        for (int i = 0; i < inlineDataID.length(); ++i) {
            if (inlineDataID.charAt(i) == charSeperator) {
                ++numberOfSeperator;
            }
            if (numberOfSeperator != targetNumberOfSeperator) continue;
            docidWithoutRev = inlineDataID.substring(0, i);
            break;
        }
        logMetacat.debug((Object)("DocumentUtil.getDocIdWithoutRevFromInlineDataID - Docid without rev from inlinedata id: " + docidWithoutRev));
        return docidWithoutRev;
    }

    public static Stack<NodeRecord> reviseStack(Stack<NodeRecord> stack) {
        Stack<NodeRecord> result = new Stack();
        if (stack == null || stack.isEmpty()) {
            result = stack;
            return result;
        }
        while (!stack.isEmpty()) {
            NodeRecord obj = stack.pop();
            result.push(obj);
        }
        return result;
    }

    public static void isAuthorized(PrintWriter out, Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response) throws MetacatUtilException {
        String[] resourceLsids = params.get("resourceLsid");
        if (resourceLsids == null) {
            throw new MetacatUtilException("DocumentUtil.isAuthorized - resourceLsid parameter cannot be null.");
        }
        String resourceLsid = resourceLsids[0];
        String[] permissions = params.get("permission");
        if (permissions == null) {
            throw new MetacatUtilException("DocumentUtil.isAuthorized - permission parameter cannot be null.");
        }
        String permission = permissions[0];
        String[] sessionIds = params.get("sessionId");
        if (sessionIds == null) {
            throw new MetacatUtilException("DocumentUtil.isAuthorized - sessionId parameter cannot be null.");
        }
        String sessionId = sessionIds[0];
        String isAuthorized = "false";
        String message = "";
        String result = "<resourceAuthorization>";
        result = result + "<resourceId>" + resourceLsid + "</resourceId>";
        result = result + "<permission>" + permission + "</permission>";
        result = result + "<sessionId>" + sessionId + "</sessionId>";
        if (!SessionService.getInstance().isSessionRegistered(sessionId)) {
            message = "Session is not logged in";
        } else {
            SessionData sessionData = SessionService.getInstance().getRegisteredSession(sessionId);
            String docId = null;
            try {
                docId = LSIDUtil.getDocId((String)resourceLsid, (boolean)true);
                PermissionController pc = new PermissionController(docId);
                if (pc.hasPermission(sessionData.getUserName(), sessionData.getGroupNames(), permission)) {
                    isAuthorized = "true";
                    message = " docid: " + docId + " is authorized for session";
                }
            }
            catch (ParseLSIDException ple) {
                message = "unparseable resource lsid: " + ple.getMessage();
            }
            catch (McdbException me) {
                message = "could not create permission controller for docid: " + docId + " : " + me.getMessage();
            }
            catch (SQLException sqle) {
                message = "SQL error getting permissions for docid: " + docId + " : " + sqle.getMessage();
            }
        }
        result = result + "<isAuthorized>" + isAuthorized + "</isAuthorized>";
        result = result + "<message>" + message + "</message>";
        result = result + "</resourceAuthorization>";
        out.write(result);
    }

    public static String generateDocumentId(int revision) {
        return DocumentUtil.generateDocumentId(prefix, revision);
    }

    public static String generateDocumentId(String idPrefix, int revision) {
        StringBuffer docid = new StringBuffer(idPrefix);
        docid.append(".");
        String[] ids = TimeZone.getAvailableIDs(-28800000);
        SimpleTimeZone pdt = new SimpleTimeZone(-28800000, ids[0]);
        pdt.setStartRule(3, 1, 1, 0x6DDD00);
        pdt.setEndRule(9, -1, 1, 0x6DDD00);
        GregorianCalendar calendar = new GregorianCalendar(pdt);
        Date trialTime = new Date();
        calendar.setTime(trialTime);
        if (documentIdCounter > 100) {
            documentIdCounter = 0;
        }
        docid.append(String.format("%04d%02d%02d%02d%02d%02d%03d%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), documentIdCounter++));
        if (revision > 0) {
            docid.append(".").append(revision);
        }
        return docid.toString();
    }

    static {
        logMetacat = Logger.getLogger(DocumentUtil.class);
        separator = (char)46;
        prefix = "autogen";
        try {
            separator = PropertyService.getProperty("document.accNumSeparator").charAt(0);
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("DocumentUtil() - Could not retrieve accession number separator. Separator set to '.' : " + pnfe.getMessage()));
        }
        try {
            prefix = PropertyService.getProperty("document.accNumPrefix");
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("DocumentUtil() - Could not retrieve accession number prefix. Prefix set to " + prefix + ": " + pnfe.getMessage()));
        }
    }
}

