/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.DocumentImplWrapper;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.XMLSchemaService;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.ecoinformatics.eml.EMLParser;

public class EMLVersionsTransformer {
    private static Logger logMetacat = Logger.getLogger(EMLVersionsTransformer.class);
    private static String eml210StyleFile = null;
    private static String DOT;
    private static int CAP;

    public void upgrade() {
        this.upgradeEML200ToEML210();
    }

    private void upgradeEML200ToEML210() {
        Vector list = this.getEML2DocList();
        if (list != null) {
            int size = list.size();
            if (size > CAP) {
                size = CAP;
            }
            for (int i = 0; i < size; ++i) {
                OwnerAndDocid pair = (OwnerAndDocid)list.elementAt(i);
                String docid = pair.getDocid();
                String owner = pair.getOwner();
                try {
                    this.handleSingleEML200Document(docid, owner);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        logMetacat.warn((Object)"Couldn't sleep 5 seconds");
                    }
                    continue;
                }
                catch (Exception e) {
                    logMetacat.warn((Object)("The docid " + docid + " with owner " + owner + " couldn't be transformed to eml-2.1.0 since " + e.getMessage()));
                    EMLVersionsTransformer.transformErrorLog("The docid " + docid + " with owner " + owner + " couldn't be transformed to eml-2.1.0 since " + e.getMessage());
                }
            }
        }
    }

    private void handleSingleEML200Document(String docidWithRev, String owner) throws Exception {
        DocumentImpl docImpl = new DocumentImpl(docidWithRev);
        String eml200Content = docImpl.toString();
        StringReader eml200Source = new StringReader(eml200Content);
        StringWriter strWriter = new StringWriter();
        String newId = EMLVersionsTransformer.increaseRevisionNumber(docidWithRev);
        if (newId != null) {
            EMLVersionsTransformer.transformEML200ToEML210(eml200Source, eml210StyleFile, strWriter, newId);
            String eml210Content = strWriter.toString();
            String rule = "eml210";
            EMLParser parser = new EMLParser(eml210Content);
            DocumentImplWrapper documentWrapper = new DocumentImplWrapper(rule, true, true);
            String doAction = "UPDATE";
            String pub = null;
            String[] groups = null;
            DBConnection dbconn = null;
            Reader dtd = null;
            int serialNumber = -1;
            Object formatId = null;
            try {
                dbconn = DBConnectionPool.getDBConnection("EMLVersionsTransformer.handleSingleEML200Document");
                serialNumber = dbconn.getCheckOutSerialNumber();
                String schemaLocation = XMLSchemaService.getInstance().getNameSpaceAndLocationStringWithoutFormatId();
                documentWrapper.write(dbconn, eml210Content, pub, dtd, doAction, newId, owner, groups, null, schemaLocation);
                logMetacat.warn((Object)("Doc " + docidWithRev + " was transformed to eml210 with new id " + newId));
                EMLVersionsTransformer.transformLog("Doc " + docidWithRev + " was transformed to eml210 with new id " + newId);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                DBConnectionPool.returnDBConnection(dbconn, serialNumber);
            }
        } else {
            logMetacat.warn((Object)("Couldn't increase docid " + docidWithRev + "'s revision"));
        }
    }

    private static void transformEML200ToEML210(Reader reader, String xslfile, Writer writer, String packageid) throws Exception {
        Hashtable<String, String> param = null;
        if (packageid != null) {
            param = new Hashtable<String, String>();
            param.put("package-id", packageid);
        }
        EMLVersionsTransformer.transform(reader, xslfile, writer, param);
    }

    private static void transform(Reader doc, String xslSystemId, Writer pw, Hashtable param) throws Exception {
        StreamSource xslSource = new StreamSource(xslSystemId);
        xslSource.setSystemId(xslSystemId);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(xslSource);
        if (param != null) {
            Enumeration en = param.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = (String)param.get(key);
                transformer.setParameter(key, value);
            }
        }
        StreamSource ss = new StreamSource(doc);
        StreamResult sr = new StreamResult(pw);
        transformer.transform(ss, sr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector getEML2DocList() {
        Vector<OwnerAndDocid> list = new Vector<OwnerAndDocid>();
        DBConnection dbconn = null;
        int serialNumber = -1;
        String sql = "select docid, rev, user_owner from xml_documents where doctype like 'eml://ecoinformatics.org/eml-2.0.1' or doctype like 'eml://ecoinformatics.org/eml-2.0.0'";
        Statement pstmt = null;
        try {
            dbconn = DBConnectionPool.getDBConnection("EMLVersionsTransformer.getEML2DocList");
            serialNumber = dbconn.getCheckOutSerialNumber();
            pstmt = dbconn.prepareStatement(sql.toString());
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            while (tableHasRows) {
                String docidWithoutRev = rs.getString(1);
                int rev = rs.getInt(2);
                String owner = rs.getString(3);
                String docidWithRev = docidWithoutRev + DOT + rev;
                logMetacat.info((Object)("The docid " + docidWithRev + " with owner " + owner + " will be added into list which will be transformed to eml-2.1.0"));
                OwnerAndDocid pair = new OwnerAndDocid(owner, docidWithRev);
                list.add(pair);
                tableHasRows = rs.next();
            }
            pstmt.close();
            return list;
        }
        catch (SQLException e) {
            logMetacat.error((Object)("error in DocumentImpl.getDocumentInfo: " + e.getMessage()));
            e.printStackTrace(System.out);
            return list;
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("error in DocumentImple.getDocumentInfo: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbconn, serialNumber);
            }
        }
    }

    private static String increaseRevisionNumber(String docidWithRev) {
        String newid = null;
        try {
            int index;
            if (docidWithRev != null && (index = docidWithRev.lastIndexOf(DOT)) != -1) {
                String firstTwoParts = docidWithRev.substring(0, index);
                String revStr = docidWithRev.substring(index + 1);
                Integer revObj = new Integer(revStr);
                int rev = revObj;
                newid = firstTwoParts + DOT + ++rev;
            }
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Couldn't increase revision number since " + e.getMessage()));
        }
        return newid;
    }

    private static void transformLog(String message) {
        try {
            FileOutputStream fos = new FileOutputStream(PropertyService.getProperty("replication.logdir") + "/transform.log", true);
            PrintWriter pw = new PrintWriter(fos);
            SimpleDateFormat formatter = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            Date localtime = new Date();
            String dateString = formatter.format(localtime);
            dateString = dateString + " :: " + message;
            pw.println(dateString);
            pw.flush();
        }
        catch (Exception e) {
            logMetacat.warn((Object)("error writing to transform log from EMLVersionTransformer.transformlLog: " + e.getMessage()));
        }
    }

    private static void transformErrorLog(String message) {
        try {
            FileOutputStream fos = new FileOutputStream(PropertyService.getProperty("replication.logdir") + "/transformerror.log", true);
            PrintWriter pw = new PrintWriter(fos);
            SimpleDateFormat formatter = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            Date localtime = new Date();
            String dateString = formatter.format(localtime);
            dateString = dateString + " :: " + message;
            pw.println(dateString);
            pw.flush();
        }
        catch (Exception e) {
            logMetacat.warn((Object)("error writing to transforming error log from EMLVersionTransformer.transformErrorLog: " + e.getMessage()));
        }
    }

    static {
        try {
            eml210StyleFile = PropertyService.getProperty("application.deployDir") + "/" + PropertyService.getProperty("application.context") + "/style/common/eml201to210.xsl";
        }
        catch (Exception e) {
            logMetacat.warn((Object)"Couldn't get eml201to210.xsl stylesheet");
        }
        DOT = ".";
        CAP = 100000;
    }

    class OwnerAndDocid {
        private String owner = null;
        private String docidWithRev = null;

        public OwnerAndDocid(String owner, String docidWithRev) {
            this.owner = owner;
            this.docidWithRev = docidWithRev;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getDocid() {
            return this.docidWithRev;
        }
    }
}

