/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.workflow;

import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.scheduler.MetacatSchedulerException;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.ErrorSendingErrorException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.ResponseUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class WorkflowSchedulerClient {
    private static WorkflowSchedulerClient WorkflowSchedulerClient = null;
    private static Logger logMetacat = Logger.getLogger(WorkflowSchedulerClient.class);

    private WorkflowSchedulerClient() {
    }

    public static WorkflowSchedulerClient getInstance() {
        if (WorkflowSchedulerClient == null) {
            WorkflowSchedulerClient = new WorkflowSchedulerClient();
        }
        return WorkflowSchedulerClient;
    }

    public void scheduleJob(HttpServletRequest request, HttpServletResponse response, Hashtable<String, String[]> params, String username, String[] groups) throws MetacatSchedulerException {
        try {
            logMetacat.debug((Object)"WorkflowSchedulerClient.scheduleJob");
            params.put("action", new String[]{"scheduleWorkflow"});
            params.put("sessionid", new String[]{RequestUtil.getSessionData(request).getId()});
            String schedulerUrl = PropertyService.getProperty("workflowScheduler.url");
            String result = RequestUtil.get(schedulerUrl, params);
            String[] forwardTos = params.get("forwardto");
            if (forwardTos == null || forwardTos.length == 0) {
                ResponseUtil.sendSuccessXML(response, result);
            } else {
                String forwardTo = forwardTos[0];
                String qformat = null;
                String[] qformats = params.get("qformat");
                qformat = qformats == null || qformats.length == 0 ? "xml" : qformats[0];
                String destination = "/style/skins/" + qformat + "/" + forwardTo;
                RequestUtil.forwardRequest(request, response, destination, params);
            }
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.scheduleJob - property error when scheduling job: " + pnfe.getMessage());
        }
        catch (MetacatUtilException mue) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.scheduleJob - utility issue when scheduling job: " + mue.getMessage());
        }
        catch (ErrorSendingErrorException esee) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.scheduleJob - Issue sending error when scheduling job: " + esee.getMessage());
        }
    }

    public void unScheduleJob(HttpServletRequest request, HttpServletResponse response, Hashtable<String, String[]> params, String username, String[] groups) throws MetacatSchedulerException {
        try {
            logMetacat.debug((Object)"WorkflowSchedulerClient.unScheduleJob");
            params.put("action", new String[]{"unscheduleWorkflow"});
            params.put("sessionid", new String[]{RequestUtil.getSessionData(request).getId()});
            String schedulerUrl = PropertyService.getProperty("workflowScheduler.url");
            String result = RequestUtil.get(schedulerUrl, params);
            String[] forwardTos = params.get("forwardto");
            if (forwardTos == null || forwardTos.length == 0) {
                ResponseUtil.sendSuccessXML(response, result);
            } else {
                String forwardTo = forwardTos[0];
                String qformat = null;
                String[] qformats = params.get("qformat");
                qformat = qformats == null || qformats.length == 0 ? "xml" : qformats[0];
                String destination = "/style/skins/" + qformat + "/" + forwardTo;
                RequestUtil.forwardRequest(request, response, destination, params);
            }
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.unScheduleJob - property error when unscheduling job: " + pnfe.getMessage());
        }
        catch (MetacatUtilException mue) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.unScheduleJob - utility issue when unscheduling job: " + mue.getMessage());
        }
        catch (ErrorSendingErrorException esee) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.unScheduleJob - Issue sending error when unscheduling job: " + esee.getMessage());
        }
    }

    public void reScheduleJob(HttpServletRequest request, HttpServletResponse response, Hashtable<String, String[]> params, String username, String[] groups) throws MetacatSchedulerException {
        try {
            logMetacat.debug((Object)"WorkflowSchedulerClient.reScheduleJob");
            params.put("action", new String[]{"rescheduleWorkflow"});
            params.put("sessionid", new String[]{RequestUtil.getSessionData(request).getId()});
            String schedulerUrl = PropertyService.getProperty("workflowScheduler.url");
            String result = RequestUtil.get(schedulerUrl, params);
            String[] forwardTos = params.get("forwardto");
            if (forwardTos == null || forwardTos.length == 0) {
                ResponseUtil.sendSuccessXML(response, result);
            } else {
                RequestUtil.forwardRequest(request, response, params);
            }
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.reScheduleJob - property error when rescheduling job: " + pnfe.getMessage());
        }
        catch (MetacatUtilException mue) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.reScheduleJob - utility issue  when rescheduling job: " + mue.getMessage());
        }
        catch (ErrorSendingErrorException esee) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.reScheduleJob - Issue sending error when rescheduling job: " + esee.getMessage());
        }
    }

    public void deleteJob(HttpServletRequest request, HttpServletResponse response, Hashtable<String, String[]> params, String username, String[] groups) throws MetacatSchedulerException {
        try {
            logMetacat.debug((Object)"WorkflowSchedulerClient.deleteJob");
            params.put("action", new String[]{"deleteScheduledWorkflow"});
            params.put("sessionid", new String[]{RequestUtil.getSessionData(request).getId()});
            String schedulerUrl = PropertyService.getProperty("workflowScheduler.url");
            String result = RequestUtil.get(schedulerUrl, params);
            String[] forwardTos = params.get("forwardto");
            if (forwardTos == null || forwardTos.length == 0) {
                ResponseUtil.sendSuccessXML(response, result);
            } else {
                String forwardTo = forwardTos[0];
                String qformat = null;
                String[] qformats = params.get("qformat");
                qformat = qformats == null || qformats.length == 0 ? "xml" : qformats[0];
                String destination = "/style/skins/" + qformat + "/" + forwardTo;
                RequestUtil.forwardRequest(request, response, destination, params);
            }
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.deleteJob - property error when deleting job: " + pnfe.getMessage());
        }
        catch (MetacatUtilException mue) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.deleteJob - utility issue  when deleting job: " + mue.getMessage());
        }
        catch (ErrorSendingErrorException esee) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.deleteJob - Issue sending error when deleting job: " + esee.getMessage());
        }
    }

    public void getJobs(HttpServletRequest request, HttpServletResponse response, Hashtable<String, String[]> params, String username, String[] groups) throws MetacatSchedulerException {
        try {
            logMetacat.debug((Object)"WorkflowSchedulerClient.getJobs");
            params.put("action", new String[]{"getScheduledWorkflow"});
            String schedulerUrl = PropertyService.getProperty("workflowScheduler.url");
            String result = RequestUtil.get(schedulerUrl, params);
            String[] qformats = params.get("qformat");
            String qformat = null;
            qformat = qformats == null || qformats.length == 0 ? "xml" : qformats[0];
            PrintWriter out = response.getWriter();
            DBTransform dbt = new DBTransform();
            dbt.transformXMLDocument(result, "-//NCEAS//scheduledWorkflowResultset//EN", "-//W3C//HTML//EN", qformat, out, params, null);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.getJobs - Property error when getting jobs for workflow: " + pnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.getJobs - I/O error when getting jobs for workflow: " + ioe.getMessage());
        }
        catch (MetacatUtilException mue) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.getJobs - Metacat utility error  when getting jobs for workflow: " + mue.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.getJobs - Error finding class when getting jobs for workflow: " + cnfe.getMessage());
        }
        catch (SQLException sqle) {
            throw new MetacatSchedulerException("WorkflowSchedulerClient.getJobs - SQL error when getting jobs for workflow: " + sqle.getMessage());
        }
    }
}

