/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.digir.impl;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.servlet.ServletException;
import org.apache.commons.httpclient.DefaultMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.ecoinformatics.ecogrid.EcogridQueryTransformer;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.ResultsetType;
import org.ecoinformatics.ecogrid.digir.impl.DigirJavaToEcogridJavaResultsetTransformer;
import org.ecoinformatics.ecogrid.digir.impl.DigirProviderInfo;
import org.ecoinformatics.ecogrid.digir.impl.EcogridJavaToDigirJavaQueryTransformer;
import org.ecoinformatics.ecogrid.stub.EcoGridQueryInterfaceLevelOnePortType;
import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.gridforum.ogsi.CardinalityViolationFaultType;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.ExtensibilityNotSupportedFaultType;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.ExtensibilityTypeFaultType;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.IncorrectValueFaultType;
import org.gridforum.ogsi.ModifiabilityViolationFaultType;
import org.gridforum.ogsi.MutabilityViolationFaultType;
import org.gridforum.ogsi.PartialFailureFaultType;
import org.gridforum.ogsi.ServiceNotDestroyedFaultType;
import org.gridforum.ogsi.TargetInvalidFaultType;
import org.gridforum.ogsi.TerminationTimeType;
import org.gridforum.ogsi.TerminationTimeUnchangedFaultType;
import org.gridforum.ogsi.TypeViolationFaultType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DigirProxyImpl
implements EcoGridQueryInterfaceLevelOnePortType {
    public static int kNoError = 0;
    public static int kError = 1;
    public static int kHttpError = 2;
    public static int kNotDoneError = 3;
    public static int kIOError = 4;
    public static int kURLError = 5;
    private GridServiceImpl _gridServImpl = null;
    private static HttpClient _httpClient = null;
    private int _status = kNoError;
    private String _digirQuery = "";
    private boolean _useDiskCaching = false;
    private String _httpReplyStr = null;
    private File _cacheDataFile = null;
    private boolean _busy = false;
    private static final String XMLFILEPATH = "@xml.file.path@";
    private static final String DATAFILEPATH = "@data.file.path@";

    public DigirProxyImpl() {
        EcogridUtils.setDebug((boolean)true);
        EcogridUtils.debugMessage((String)"*******************************************", (int)1);
        EcogridUtils.debugMessage((String)"DigirProxy Impl has been created", (int)1);
    }

    public void finalize() {
        this.cleanUp();
    }

    public void cleanUp() {
        if (this._cacheDataFile != null) {
            System.out.println("*** DigirProxyImpl removing cache file [" + this._cacheDataFile + "]");
            this._cacheDataFile.delete();
            this._cacheDataFile = null;
        }
    }

    public DigirProxyImpl(GridServiceImpl aImpl) {
        this._gridServImpl = aImpl;
        EcogridUtils.setDebug((boolean)true);
        EcogridUtils.debugMessage((String)"*******************************************", (int)1);
        EcogridUtils.debugMessage((String)"DigirProxy Impl has been created with Grid Service Impl", (int)1);
    }

    private void doError(String aMsg) {
        EcogridUtils.debugMessage((String)aMsg);
    }

    public int getStatus() {
        return this._status;
    }

    public String getDigirResultsetStr() {
        if (this._useDiskCaching) {
            StringBuffer httpReplyStr = null;
            try {
                BufferedReader bufReader = this.getDataStream();
                if (bufReader != null) {
                    String data;
                    httpReplyStr = new StringBuffer();
                    bufReader.readLine();
                    while ((data = bufReader.readLine()) != null) {
                        httpReplyStr.append(data);
                    }
                }
                bufReader.close();
            }
            catch (Exception e) {
                System.err.println("*** Error in getDigirResultsetStr" + e);
            }
            return httpReplyStr.toString();
        }
        return this._httpReplyStr;
    }

    public BufferedReader getDataStream() throws FileNotFoundException {
        if (this._useDiskCaching) {
            return this._cacheDataFile == null ? null : new BufferedReader(new InputStreamReader(new FileInputStream(this._cacheDataFile)));
        }
        return this._httpReplyStr == null ? null : new BufferedReader(new StringReader(this._httpReplyStr));
    }

    public File getCacheFile() {
        return this._cacheDataFile;
    }

    public boolean usingDiskCaching() {
        return this._useDiskCaching;
    }

    public long getResultsetSize() {
        return this._cacheDataFile == null ? 0L : this._cacheDataFile.length();
    }

    public void printNode(Node aNode, int aLevel) {
        String spaces = "";
        for (int i = 0; i < aLevel; ++i) {
            spaces = spaces + "..";
        }
        EcogridUtils.debugMessage((String)(spaces + "Name:  " + aNode.getNodeName()));
        EcogridUtils.debugMessage((String)(spaces + "Type:  " + aNode.getNodeType()));
        EcogridUtils.debugMessage((String)(spaces + "Value: " + aNode.getNodeValue()));
        NodeList list = aNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            this.printNode(child, aLevel + 1);
        }
    }

    public int doHTTPRequest(String aURL) {
        int status = kNoError;
        EcogridUtils.debugMessage((String)"*** Doing doHTTPRequest!");
        if (_httpClient == null) {
            MultiThreadedHttpConnectionManager connMan = new MultiThreadedHttpConnectionManager();
            int maxConns = 3;
            connMan.setMaxTotalConnections(maxConns);
            connMan.setMaxConnectionsPerHost(maxConns);
            _httpClient = new HttpClient((HttpConnectionManager)connMan);
            int timeOut = 30;
            _httpClient.setHttpConnectionFactoryTimeout((long)(timeOut * 1000));
            _httpClient.setConnectionTimeout(timeOut * 1000);
            _httpClient.setTimeout(timeOut * 1000);
        }
        try {
            PostMethod method = new PostMethod(aURL);
            int retries = 3;
            if (retries < 0) {
                retries = 0;
            }
            DefaultMethodRetryHandler retrier = new DefaultMethodRetryHandler();
            retrier.setRetryCount(retries);
            method.setMethodRetryHandler((MethodRetryHandler)retrier);
            int httpStatusCode = -1;
            boolean done = false;
            try {
                EcogridUtils.debugMessage((String)("Making request at: " + aURL));
                httpStatusCode = _httpClient.executeMethod((HttpMethod)method);
            }
            catch (HttpRecoverableException hre) {
                method.releaseConnection();
                done = true;
                String msg = "HTTP error making request.  (" + hre.toString() + ")";
                this.doError(msg);
                status = kHttpError;
            }
            catch (HttpConnection.ConnectionTimeoutException cte) {
                method.releaseConnection();
                done = true;
                this.doError("HTTP connection timeout making request.  (" + cte.toString() + ")");
                status = kHttpError;
            }
            catch (ConnectException ce) {
                method.releaseConnection();
                done = true;
                this.doError("Could not make HTTP connection.  (" + ce.toString() + ")");
                status = kHttpError;
            }
            catch (HttpException he) {
                method.releaseConnection();
                done = true;
                this.doError("Http problem making request.  (" + he.toString() + ")");
                status = kHttpError;
            }
            catch (IOException ioe) {
                method.releaseConnection();
                done = true;
                this.doError("IO problem making request.  (" + ioe.toString() + ")");
                status = kIOError;
            }
            EcogridUtils.debugMessage((String)("status code: " + status));
            if (status == kNoError) {
                if (httpStatusCode == -1) {
                    if (!done) {
                        method.releaseConnection();
                        done = true;
                        this.doError("Invalid HTTP response code making request.  (" + httpStatusCode + ")");
                        status = kHttpError;
                    }
                } else if (httpStatusCode >= 400 && httpStatusCode < 600) {
                    if (!done) {
                        method.releaseConnection();
                        done = true;
                        this.doError("Error level HTTP response code making request.  (" + httpStatusCode + ")");
                        status = kHttpError;
                    }
                } else {
                    EcogridUtils.debugMessage((String)"<hr>");
                    EcogridUtils.debugMessage((String)("Got HTTP response code: " + httpStatusCode));
                    this._cacheDataFile = File.createTempFile("digir", "data");
                    BufferedOutputStream bos = null;
                    if (this._useDiskCaching) {
                        EcogridUtils.debugMessage((String)("Writing Data to: " + this._cacheDataFile));
                        bos = new BufferedOutputStream(new FileOutputStream(this._cacheDataFile));
                    }
                    InputStream is = method.getResponseBodyAsStream();
                    BufferedReader buf = new BufferedReader(new InputStreamReader(is));
                    String data = null;
                    StringBuffer resultBuffer = new StringBuffer();
                    while ((data = buf.readLine()) != null) {
                        if (this._useDiskCaching) {
                            bos.write(data.getBytes());
                            continue;
                        }
                        resultBuffer.append(data);
                    }
                    buf.close();
                    is.close();
                    if (this._useDiskCaching) {
                        bos.close();
                    } else {
                        this._httpReplyStr = resultBuffer.toString();
                    }
                    method.releaseConnection();
                    EcogridUtils.debugMessage((String)("************* \nHTTP Reply is:\n" + this.getDigirResultsetStr() + "\n******* Done ******"));
                }
            }
        }
        catch (MalformedURLException mue) {
            this.doError("Invalid URL constructed.  (" + mue.toString() + ")");
            status = kURLError;
        }
        catch (IOException ioe) {
            this.doError("IO problem.  (" + ioe.toString() + ")");
            status = kIOError;
        }
        catch (Exception e) {
            this.doError("Unexpected error.  (" + e.toString() + ")");
            status = kError;
        }
        EcogridUtils.debugMessage((String)"***********************************");
        EcogridUtils.debugMessage((String)(" Done with HTTP Request (Status: " + status + ")"));
        EcogridUtils.debugMessage((String)"***********************************");
        return status;
    }

    public static String getFullDigirURL(String aDigirQueryStr) {
        String fullURL = "";
        if (aDigirQueryStr != null && aDigirQueryStr.length() > 0) {
            String dispatcher = "http://129.237.127.19:8080/portal/PortalServlet";
            try {
                String docAsEncString = DigirProxyImpl.getDocumentAsEncodedString(aDigirQueryStr);
                fullURL = dispatcher + "?doc=" + docAsEncString;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return fullURL;
    }

    public int doDigirQuery(String aDigirQueryStr) {
        if (aDigirQueryStr != null && aDigirQueryStr.length() > 0) {
            EcogridUtils.debugMessage((String)"*** Doing doDigirQuery from serialized string!");
            this._digirQuery = aDigirQueryStr;
            return this.doHTTPRequest(DigirProxyImpl.getFullDigirURL(aDigirQueryStr));
        }
        return kError;
    }

    public int doDigirQuery(QueryType query) throws IOException, ServletException {
        int status = kNoError;
        EcogridJavaToDigirJavaQueryTransformer ecogrid2DigirTransformer = new EcogridJavaToDigirJavaQueryTransformer();
        EcogridUtils.debugMessage((String)"*** Starting Digir Query from QueryType!");
        try {
            Vector<DigirProviderInfo> providerList = new Vector<DigirProviderInfo>();
            boolean useNewWay = true;
            if (useNewWay) {
                String[] urlsArray = new String[]{"http://www.calacademy.org:80/digir/digir.php", "CAS Mammals", "http://digir.fieldmuseum.org:80/digir/DiGIR.php", "MammalsDwC2", "http://nhmuseum.ups.edu:80/DiGIRprov/www/DiGIR.php", "PSMMammalsDwC2", "http://manis.lam.mus.ca.us:80/DiGIRprov/www/DiGIR.php", "MammalsDwC2", "http://130.39.185.43:80/digir/mammals/DiGIR.php", "MammalsDwC2", "http://128.32.146.143:80/DiGIRprov/ttuwww/DiGIR.php", "MammalsDwC2", "http://manis.mvz.berkeley.edu:80/DiGIRprov/www/DiGIR.php", "MammalsDwC2", "http://digir.rom.on.ca:80/digir/DiGIR.php", "MammalDwC2", "http://speciesanalyst.net/digir/DiGIR.php", "MammalsDWC2", "http://www.manis.ummz.lsa.umich.edu:80/DiGIRprov/www/DiGIR.php", "MammalsDwC2", "http://160.94.76.31:80/digir/DiGIR.php", "MMNH", "http://128.32.146.143:80/DiGIRprov/msbwww/DiGIR.php", "MammalsDwC2", "http://128.95.54.132:80/DiGIRprov/www/DiGIR.php", "MammalsDwC2", "http://manis.umnh.utah.edu:80/DiGIRprov/www/DiGIR.php", "MammalsDwC2"};
                for (int i = 0; i < urlsArray.length / 2; i += 2) {
                    DigirProviderInfo provider = new DigirProviderInfo(urlsArray[i], urlsArray[i + 1]);
                    providerList.addElement(provider);
                }
            } else {
                DigirProviderInfo provider = new DigirProviderInfo("http://digir.nhm.ku.edu/digir/DiGIR.php", "KUHerps");
                providerList.addElement(provider);
            }
            String digirQueryStr = ecogrid2DigirTransformer.transform(query, providerList);
            status = this.doDigirQuery(digirQueryStr);
        }
        catch (Exception e) {
            this.doError("Unexpected error. (" + e.toString() + ")");
            status = kError;
        }
        return status;
    }

    public ResultsetType query(QueryType query) throws RemoteException {
        EcogridUtils.debugMessage((String)("DigirImpl: start query method in grid service" + this + " is busy " + this._busy), (int)1);
        if (this._busy) {
            System.err.println("DigirImpl: Request made while it was all ready busy.");
            return null;
        }
        ResultsetType resultset = null;
        this._busy = true;
        try {
            EcogridUtils.debugMessage((String)"DigirImpl: after searching result transforming to ecogrid result java object", (int)1);
            this._status = this.doDigirQuery(query);
            boolean doDebug = false;
            if (doDebug) {
                System.err.println(EcogridQueryTransformer.toXMLString((QueryType)query));
            }
            if (this._status == kNoError) {
                DigirJavaToEcogridJavaResultsetTransformer ecogrid2ResultTransformer = new DigirJavaToEcogridJavaResultsetTransformer();
                resultset = this._useDiskCaching ? ecogrid2ResultTransformer.transform(this._cacheDataFile) : ecogrid2ResultTransformer.transform(EcogridUtils.convertXMLStr2DOM((String)this._httpReplyStr));
                this.cleanUp();
            }
            EcogridUtils.debugMessage((String)("DigirImpl: Result Status: " + this._status), (int)1);
        }
        catch (Exception e) {
            this._busy = false;
            EcogridUtils.debugMessage((String)("DigirImpl: The exception is: " + e.getMessage()), (int)1);
            throw new RemoteException(e.getMessage());
        }
        this._busy = false;
        return resultset;
    }

    public byte[] get(String identifier) throws RemoteException {
        byte[] output = null;
        if (identifier == null) {
            throw new RemoteException("Please sepcify the identifier");
        }
        return output;
    }

    public String getDigirQuery() {
        return this._digirQuery;
    }

    public static String getDocumentAsString(Document aDoc) throws IOException {
        OutputFormat format = new OutputFormat(aDoc, "UTF-8", true);
        format.setIndent(3);
        StringWriter outputString = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)outputString, format);
        serial.asDOMSerializer();
        serial.serialize(aDoc.getDocumentElement());
        return outputString.toString();
    }

    public static String getDocumentAsEncodedString(Document aDOM) throws IOException {
        return URLEncoder.encode(DigirProxyImpl.getDocumentAsString(aDOM), "UTF-8");
    }

    public static String getDocumentAsEncodedString(String aStr) throws IOException {
        return URLEncoder.encode(aStr, "UTF-8");
    }

    public ExtensibilityType setServiceData(ExtensibilityType updateExpression) throws RemoteException, ModifiabilityViolationFaultType, PartialFailureFaultType, TypeViolationFaultType, MutabilityViolationFaultType, CardinalityViolationFaultType, ExtensibilityTypeFaultType, IncorrectValueFaultType, ExtensibilityNotSupportedFaultType, FaultType {
        return null;
    }

    public void destroy() throws RemoteException, ServiceNotDestroyedFaultType, FaultType {
    }

    public TerminationTimeType requestTerminationAfter(ExtendedDateTimeType terminationTime) throws RemoteException, TerminationTimeUnchangedFaultType, FaultType {
        return null;
    }

    public TerminationTimeType requestTerminationBefore(ExtendedDateTimeType terminationTime) throws RemoteException, TerminationTimeUnchangedFaultType, FaultType {
        return null;
    }

    public ExtensibilityType findServiceData(ExtensibilityType queryExpression) throws RemoteException, TargetInvalidFaultType, ExtensibilityTypeFaultType, ExtensibilityNotSupportedFaultType, FaultType {
        return null;
    }
}

