/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SocketFactory;
import org.apache.axis.components.net.SocketFactoryFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.ChunkedInputStream;
import org.apache.axis.transport.http.ChunkedOutputStream;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.SocketInputStream;
import org.apache.axis.utils.Messages;
import org.apache.log4j.Logger;
import org.globus.axis.util.Util;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class GSIHTTPSender
extends BasicHandler {
    protected static Logger log = Logger.getLogger((String)(class$org$globus$axis$transport$GSIHTTPSender == null ? (class$org$globus$axis$transport$GSIHTTPSender = GSIHTTPSender.class$("org.globus.axis.transport.GSIHTTPSender")) : class$org$globus$axis$transport$GSIHTTPSender).getName());
    static /* synthetic */ Class class$org$globus$axis$transport$GSIHTTPSender;

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"enter00", (String)"HTTPSender::invoke"));
        }
        try {
            BooleanHolder useFullURL = new BooleanHolder(false);
            StringBuffer otherHeaders = new StringBuffer();
            URL targetURL = new URL(msgContext.getStrProp("transport.url"));
            String host = targetURL.getHost();
            int port = targetURL.getPort();
            Socket sock = null;
            sock = this.getSocket(targetURL.getProtocol(), host, port, otherHeaders, useFullURL, msgContext);
            if (msgContext.getTimeout() != 0) {
                sock.setSoTimeout(msgContext.getTimeout());
            }
            InputStream inp = this.writeToSocket(sock, msgContext, targetURL, otherHeaders, host, port, useFullURL);
            Hashtable headers = new Hashtable();
            inp = this.readHeadersFromSocket(sock, msgContext, inp, headers);
            this.readFromSocket(sock, msgContext, inp, headers);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw AxisFault.makeFault((Exception)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"exit00", (String)"HTTPDispatchHandler::invoke"));
        }
    }

    private Socket getSocket(String protocol, String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL, MessageContext msgContext) throws Exception {
        if (!protocol.equalsIgnoreCase("httpg")) {
            return this.getSocket(protocol, host, port, otherHeaders, useFullURL);
        }
        GSSCredential cred = null;
        Authorization auth = null;
        String mode = null;
        cred = (GSSCredential)Util.getProperty(msgContext, "org.globus.gsi.credentials");
        auth = (Authorization)Util.getProperty(msgContext, "org.globus.gsi.authorization");
        mode = (String)Util.getProperty(msgContext, "org.globus.gsi.mode");
        if (auth == null) {
            auth = HostAuthorization.getInstance();
        }
        if (mode == null) {
            mode = "gsi";
        }
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = null;
        context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, cred, 0);
        if (mode.equalsIgnoreCase("gsilimited")) {
            context.requestCredDeleg(true);
            context.setOption(GSSConstants.DELEGATION_TYPE, (Object)GSIConstants.DELEGATION_TYPE_LIMITED);
        } else if (mode.equalsIgnoreCase("gsifull")) {
            context.requestCredDeleg(true);
            context.setOption(GSSConstants.DELEGATION_TYPE, (Object)GSIConstants.DELEGATION_TYPE_FULL);
        } else if (mode.equalsIgnoreCase("gsi")) {
            context.requestCredDeleg(false);
        } else if (mode.equalsIgnoreCase("ssl")) {
            context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_SSL);
        } else {
            throw new Exception("Invalid GSI MODE: " + mode);
        }
        int lport = port == -1 ? 8443 : port;
        GssSocketFactory factory = GssSocketFactory.getDefault();
        GssSocket gsiSocket = (GssSocket)factory.createSocket(host, lport, (GSSContext)context);
        gsiSocket.setAuthorization(auth);
        return gsiSocket;
    }

    private Socket getSocket(String protocol, String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        SocketFactory factory = SocketFactoryFactory.getFactory((String)protocol, (Hashtable)this.getOptions());
        return factory.create(host, port, otherHeaders, useFullURL);
    }

    private InputStream writeToSocket(Socket sock, MessageContext msgContext, URL tmpURL, StringBuffer otherHeaders, String host, int port, BooleanHolder useFullURL) throws IOException {
        Hashtable userHeaderTable;
        String action;
        String userID = null;
        String passwd = null;
        String reqEnv = null;
        userID = msgContext.getUsername();
        passwd = msgContext.getPassword();
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if (userID == null && tmpURL.getUserInfo() != null) {
            String info = tmpURL.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(userID).append(":").append(passwd == null ? "" : passwd);
            otherHeaders.append("Authorization").append(": Basic ").append(Base64.encode((byte[])tmpBuf.toString().getBytes())).append("\r\n");
        }
        if (msgContext.getMaintainSession()) {
            String cookie = msgContext.getStrProp("Cookie");
            String cookie2 = msgContext.getStrProp("Cookie2");
            if (cookie != null) {
                otherHeaders.append("Cookie").append(": ").append(cookie).append("\r\n");
            }
            if (cookie2 != null) {
                otherHeaders.append("Cookie2").append(": ").append(cookie2).append("\r\n");
            }
        }
        StringBuffer header = new StringBuffer();
        String webMethod = null;
        boolean posting = true;
        if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
            webMethod = msgContext.getStrProp("soap12.webmethod");
        }
        if (webMethod == null) {
            webMethod = "POST";
        } else {
            posting = webMethod.equals("POST");
        }
        header.append(webMethod).append(" ");
        if (useFullURL.value) {
            header.append(tmpURL.toExternalForm());
        } else {
            header.append(tmpURL.getFile() == null || tmpURL.getFile().equals("") ? "/" : tmpURL.getFile());
        }
        Message reqMessage = msgContext.getRequestMessage();
        boolean http10 = true;
        boolean httpChunkStream = false;
        boolean httpContinueExpected = false;
        String httpConnection = null;
        String httpver = msgContext.getStrProp("axis.transport.version");
        if (null == httpver) {
            httpver = HTTPConstants.HEADER_PROTOCOL_V10;
        }
        if ((httpver = httpver.trim()).equals(HTTPConstants.HEADER_PROTOCOL_V11)) {
            http10 = false;
        }
        if ((userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers")) != null) {
            if (null == otherHeaders) {
                otherHeaders = new StringBuffer(1024);
            }
            Iterator e = userHeaderTable.entrySet().iterator();
            while (e.hasNext()) {
                String val;
                Map.Entry me = e.next();
                Object keyObj = me.getKey();
                if (null == keyObj) continue;
                String key = keyObj.toString().trim();
                if (key.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                    if (http10 || null == (val = me.getValue().toString()) || !val.trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    httpChunkStream = true;
                    continue;
                }
                if (key.equalsIgnoreCase("Host") || key.equalsIgnoreCase("Content-Type") || key.equalsIgnoreCase("SOAPAction") || key.equalsIgnoreCase("Content-Length") || key.equalsIgnoreCase("Cookie") || key.equalsIgnoreCase("Cookie2") || key.equalsIgnoreCase("Authorization") || key.equalsIgnoreCase("Proxy-Authorization")) continue;
                if (key.equalsIgnoreCase("Connection")) {
                    if (http10 || !(val = me.getValue().toString()).trim().equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) continue;
                    httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
                    continue;
                }
                if (!http10 && key.equalsIgnoreCase("Expect") && null != (val = me.getValue().toString()) && val.trim().equalsIgnoreCase("100-continue")) {
                    httpContinueExpected = true;
                }
                otherHeaders.append(key).append(": ").append(me.getValue()).append("\r\n");
            }
        }
        if (!http10) {
            httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
        }
        header.append(" ");
        header.append(http10 ? "HTTP/1.0" : "HTTP/1.1").append("\r\n");
        if (posting) {
            header.append("Content-Type").append(": ").append(reqMessage.getContentType(msgContext.getSOAPConstants())).append("\r\n");
        }
        header.append("Accept").append(": ").append("application/soap+xml").append(", ").append("application/dime").append(", ").append("multipart/related").append(", ").append("text/*").append("\r\n").append("User-Agent").append(": ").append(Messages.getMessage((String)"axisUserAgent")).append("\r\n").append("Host").append(": ").append(host).append(port == -1 ? "" : ":" + port).append("\r\n").append("Cache-Control").append(": ").append("no-cache").append("\r\n").append("Pragma").append(": ").append("no-cache").append("\r\n").append("SOAPAction").append(": \"").append(action).append("\"\r\n");
        if (posting) {
            if (!httpChunkStream) {
                header.append("Content-Length").append(": ").append(reqMessage.getContentLength()).append("\r\n");
            } else {
                header.append(HTTPConstants.HEADER_TRANSFER_ENCODING).append(": ").append(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED).append("\r\n");
            }
        }
        if (null != httpConnection) {
            header.append("Connection");
            header.append(": ");
            header.append(httpConnection);
            header.append("\r\n");
        }
        if (null != otherHeaders) {
            header.append((Object)otherHeaders);
        }
        header.append("\r\n");
        OutputStream out = sock.getOutputStream();
        if (!posting) {
            out.write(header.toString().getBytes("iso-8859-1"));
            out.flush();
            return null;
        }
        InputStream inp = null;
        if (httpChunkStream) {
            out.write(header.toString().getBytes("iso-8859-1"));
        }
        if (httpContinueExpected) {
            out.flush();
            Hashtable cheaders = new Hashtable();
            inp = this.readHeadersFromSocket(sock, msgContext, null, cheaders);
            int returnCode = -1;
            Integer Irc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
            if (null != Irc) {
                returnCode = Irc;
            }
            if (100 == returnCode) {
                msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            } else {
                String statusMessage = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                fault.setFaultDetailString(Messages.getMessage((String)"return01", (String)("" + returnCode), (String)""));
                throw fault;
            }
        }
        if (httpChunkStream) {
            ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(out);
            out = new BufferedOutputStream((OutputStream)chunkedOutputStream, 8192);
            try {
                reqMessage.writeTo(out);
            }
            catch (SOAPException e) {
                log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            }
            out.flush();
            chunkedOutputStream.eos();
        } else {
            out = new BufferedOutputStream(out, 8192);
            try {
                out.write(header.toString().getBytes("iso-8859-1"));
                reqMessage.writeTo(out);
            }
            catch (SOAPException e) {
                log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            }
            out.flush();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"xmlSent00"));
            log.debug((Object)"---------------------------------------------------");
            log.debug((Object)(header + reqEnv));
        }
        return inp;
    }

    private InputStream readHeadersFromSocket(Socket sock, MessageContext msgContext, InputStream inp, Hashtable headers) throws IOException {
        int b = 0;
        int len = 0;
        int colonIndex = -1;
        int returnCode = 0;
        if (null == inp) {
            inp = new BufferedInputStream(sock.getInputStream());
        }
        if (headers == null) {
            headers = new Hashtable<String, String>();
        }
        boolean readTooMuch = false;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4097);
        while (true) {
            String value;
            String name;
            if (!readTooMuch) {
                b = (byte)inp.read();
            }
            if (b == -1) break;
            readTooMuch = false;
            if (b != 13 && b != 10) {
                if (b == 58 && colonIndex == -1) {
                    colonIndex = len;
                }
                ++len;
                buf.write(b);
                continue;
            }
            if (b == 13) continue;
            if (len == 0) break;
            b = (byte)inp.read();
            readTooMuch = true;
            if (b == 32 || b == 9) continue;
            buf.close();
            byte[] hdata = buf.toByteArray();
            buf.reset();
            if (colonIndex != -1) {
                name = new String(hdata, 0, colonIndex, "iso-8859-1");
                value = new String(hdata, colonIndex + 1, len - 1 - colonIndex, "iso-8859-1");
                colonIndex = -1;
            } else {
                name = new String(hdata, 0, len, "iso-8859-1");
                value = "";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(name + value));
            }
            if (msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE) == null) {
                int start = name.indexOf(32) + 1;
                String tmp = name.substring(start).trim();
                int end = tmp.indexOf(32);
                if (end != -1) {
                    tmp = tmp.substring(0, end);
                }
                returnCode = Integer.parseInt(tmp);
                msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, (Object)new Integer(returnCode));
                msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, (Object)name.substring(start + end + 1));
            } else {
                headers.put(name.toLowerCase(), value);
            }
            len = 0;
        }
        return inp;
    }

    /*
     * WARNING - void declaration
     */
    private InputStream readFromSocket(Socket sock, MessageContext msgContext, InputStream inp, Hashtable headers) throws IOException {
        String contentType;
        Message outMsg = null;
        Integer rc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
        int returnCode = 0;
        if (rc != null) {
            returnCode = rc;
        }
        String string = contentType = null == (contentType = (String)headers.get("Content-Type".toLowerCase())) ? null : contentType.trim();
        if (!(returnCode > 199 && returnCode < 300 || contentType != null && !contentType.startsWith("text/html") && returnCode > 499 && returnCode < 600)) {
            byte b;
            ByteArrayOutputStream buf = new ByteArrayOutputStream(4097);
            while (-1 != (b = (byte)inp.read())) {
                void var6_11;
                buf.write((int)var6_11);
            }
            String statusMessage = msgContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
            fault.setFaultDetailString(Messages.getMessage((String)"return01", (String)("" + returnCode), (String)buf.toString()));
            throw fault;
        }
        String contentLocation = (String)headers.get("Content-Location".toLowerCase());
        contentLocation = null == contentLocation ? null : contentLocation.trim();
        String contentLength = (String)headers.get("Content-Length".toLowerCase());
        contentLength = null == contentLength ? null : contentLength.trim();
        String transferEncoding = (String)headers.get(HTTPConstants.HEADER_TRANSFER_ENCODING.toLowerCase());
        if (null != transferEncoding && transferEncoding.trim().equals(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
            inp = new ChunkedInputStream(inp);
        }
        outMsg = new Message((Object)new SocketInputStream(inp, sock), false, contentType, contentLocation);
        outMsg.setMessageType("response");
        msgContext.setResponseMessage(outMsg);
        if (log.isDebugEnabled()) {
            if (null == contentLength) {
                log.debug((Object)("\n" + Messages.getMessage((String)"no00", (String)"Content-Length")));
            }
            log.debug((Object)("\n" + Messages.getMessage((String)"xmlRecd00")));
            log.debug((Object)"-----------------------------------------------");
            log.debug((Object)outMsg.getSOAPPartAsString());
        }
        if (msgContext.getMaintainSession()) {
            this.handleCookie("Cookie", "Set-Cookie", headers, msgContext);
            this.handleCookie("Cookie2", "Set-Cookie2", headers, msgContext);
        }
        return inp;
    }

    public void handleCookie(String cookieName, String setCookieName, Hashtable headers, MessageContext msgContext) {
        if (headers.containsKey(setCookieName.toLowerCase())) {
            String cookie = (String)headers.get(setCookieName.toLowerCase());
            int index = (cookie = cookie.trim()).indexOf(59);
            if (index != -1) {
                cookie = cookie.substring(0, index);
            }
            msgContext.setProperty(cookieName, (Object)cookie);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

