/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import java.util.Calendar;
import javax.xml.rpc.Stub;
import org.globus.ogsa.utils.GetOpts;
import org.globus.ogsa.utils.MessageUtils;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.GridService;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.InfinityType;
import org.gridforum.ogsi.OGSIServiceGridLocator;

public class RequestTermination {
    public static void main(String[] args) {
        block6: {
            GetOpts opts = new GetOpts("Usage: RequestTermination [options] <seconds|infinity> <handle>", 2);
            String error = opts.parse(args);
            if (error != null) {
                System.err.println(error);
                return;
            }
            String handle = opts.getArg(1);
            try {
                ExtendedDateTimeType dateTime = new ExtendedDateTimeType();
                String time = opts.getArg(0);
                if (time.equalsIgnoreCase("infinity")) {
                    dateTime.setValue(InfinityType.infinity);
                } else {
                    Calendar timeout = Calendar.getInstance();
                    timeout.add(13, Integer.parseInt(time));
                    dateTime.setValue(timeout);
                }
                OGSIServiceGridLocator terminationService = new OGSIServiceGridLocator();
                GridService termination = terminationService.getGridServicePort(new HandleType(handle));
                opts.setOptions((Stub)termination);
                termination.requestTerminationAfter(dateTime);
            }
            catch (Exception e) {
                if (opts.isDebug()) {
                    System.err.println(MessageUtils.toString(e));
                    break block6;
                }
                System.err.println("Error: " + opts.getErrorMessage(e));
            }
        }
    }
}

