/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceURL {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$client$ServiceURL == null ? (class$org$globus$ogsa$client$ServiceURL = ServiceURL.class$("org.globus.ogsa.client.ServiceURL")) : class$org$globus$ogsa$client$ServiceURL).getName());
    private static final String URL_SEPARATOR = "://";
    private static Properties properties;
    public static final String PORT_PROPERTY = "service.port";
    public static final String DEFAULT_PORT = "8080";
    public static final String PROTOCOL_PROPERTY = "binding.protocol";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String OGSA_PROPERTIES_FILE = "ogsa.properties";
    public static final String DEFAULT_SERVICE_CONTEXT = "ogsa/services/";
    private String contactString;
    private String serviceName;
    private URL url;
    static /* synthetic */ Class class$org$globus$ogsa$client$ServiceURL;

    public static String getServicePath(String serviceName) {
        return "/ogsa/services/" + serviceName;
    }

    private static String getDefaultProtocol() {
        return ServiceURL.getOGSAProperty(PROTOCOL_PROPERTY, DEFAULT_PROTOCOL);
    }

    private static String getDefaultHost() {
        String serviceRoot = ServiceURL.getOGSAProperty("service.root", "http://127.0.0.1");
        int hostIndex = serviceRoot.indexOf(URL_SEPARATOR) + URL_SEPARATOR.length();
        return serviceRoot.substring(hostIndex, serviceRoot.length());
    }

    private static int getDefaultPort() {
        int defaultPort;
        String defaultPortString = DEFAULT_PORT;
        try {
            defaultPortString = ServiceURL.getOGSAProperty(PORT_PROPERTY, DEFAULT_PORT);
            defaultPort = Integer.parseInt(defaultPortString);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)nfe);
            throw new RuntimeException("Invalid integer format in " + defaultPortString + " - " + nfe.getMessage());
        }
        return defaultPort;
    }

    private static String getOGSAProperty(String propertyName, String defaultValue) {
        String property = defaultValue;
        property = ServiceURL.getProperties().getProperty(propertyName, defaultValue);
        logger.debug((Object)("property = " + property));
        return property;
    }

    private static Properties getProperties() {
        block3: {
            if (properties != null) break block3;
            properties = new Properties();
            File propertiesFile = new File(System.getProperty("user.dir"), OGSA_PROPERTIES_FILE);
            if (!propertiesFile.exists()) {
                String globusLocation = System.getProperty("globus.location");
                propertiesFile = new File(globusLocation, OGSA_PROPERTIES_FILE);
            }
            try {
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(propertiesFile));
                logger.debug((Object)"loading property file");
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException ioe) {
                logger.warn((Object)"Could not find or read ogsa.properties. Default values will be used.");
            }
        }
        return properties;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public URL getURL() throws MalformedURLException {
        if (this.url == null) {
            String contactURLString = this.contactString;
            if (this.contactString.indexOf(URL_SEPARATOR) == -1) {
                contactURLString = ServiceURL.getDefaultProtocol() + URL_SEPARATOR + this.contactString;
            }
            this.url = new URL(contactURLString);
            String protocol = this.url.getProtocol();
            String host = this.url.getHost();
            int port = this.url.getPort();
            String path = this.url.getPath();
            if (host.equals("")) {
                host = ServiceURL.getDefaultHost();
            }
            if (port == -1) {
                port = ServiceURL.getDefaultPort();
            }
            if (path.equals("")) {
                if (this.serviceName != null && !this.serviceName.equals("")) {
                    path = ServiceURL.getServicePath(this.serviceName);
                } else {
                    throw new RuntimeException("Service name must be specified since no path was found.");
                }
            }
            try {
                this.url = new URL(protocol, host, port, path);
            }
            catch (MalformedURLException e) {
                logger.error((Object)e);
                throw new RuntimeException("Could not reconstruct URL");
            }
        }
        return this.url;
    }

    public static URL getURL(String contactString, String serviceName) throws MalformedURLException {
        URL url = null;
        ServiceURL serviceURL = new ServiceURL(contactString);
        serviceURL.setServiceName(serviceName);
        url = serviceURL.getURL();
        logger.debug((Object)("Resolved contact string to URL:" + url.toExternalForm()));
        return url;
    }

    public ServiceURL(String contactString) {
        if (contactString == null) {
            try {
                InetAddress ipAddress = InetAddress.getLocalHost();
                contactString = ipAddress.getHostName();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new RuntimeException(e.getMessage());
            }
        }
        this.contactString = contactString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

