/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.encoding;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.encoding.ObjectDeserializationContext;
import org.globus.ogsa.utils.AnyHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ObjectSerializer {
    public static Element toElement(Object obj) throws GridServiceException {
        try {
            StringReader reader = new StringReader(ObjectSerializer.toString(obj));
            Document doc = XMLUtils.newDocument((InputSource)new InputSource(reader));
            if (doc == null) {
                return null;
            }
            return doc.getDocumentElement();
        }
        catch (GridServiceException gse) {
            throw gse;
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public static String toString(Object obj) throws GridServiceException {
        try {
            StringWriter writer = new StringWriter();
            MessageElement messageElement = AnyHelper.toAny(obj);
            MessageContext messageContext = new MessageContext(ContainerConfig.getConfig().getEngine());
            messageContext.setEncodingStyle("");
            messageContext.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            SerializationContextImpl context = new SerializationContextImpl((Writer)writer, messageContext);
            messageElement.output((SerializationContext)context);
            writer.flush();
            return writer.toString();
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public static Object toObject(Element element) throws GridServiceException {
        return ObjectSerializer.toObject(element, null);
    }

    public static Object toObject(Element element, Class javaClass) throws GridServiceException {
        try {
            ObjectDeserializationContext deserializer = new ObjectDeserializationContext(element, javaClass);
            deserializer.parse();
            return deserializer.getValue();
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }
}

