/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.logging;

import org.apache.commons.logging.Log;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.globus.ogsa.core.logging.LogMessageElement;
import org.globus.ogsa.impl.core.logging.OGSALogFactory;
import org.globus.ogsa.impl.core.logging.OGSALogUtil;

public class OGSALog4jLog
implements Log,
OGSALogUtil {
    private boolean debugEnabled = false;
    private boolean fatalEnabled = true;
    private boolean errorEnabled = true;
    private boolean infoEnabled = false;
    private boolean warnEnabled = true;
    private boolean traceEnabled = false;
    private static final String FQCN = (class$org$globus$ogsa$impl$core$logging$OGSALog4jLog == null ? (class$org$globus$ogsa$impl$core$logging$OGSALog4jLog = OGSALog4jLog.class$("org.globus.ogsa.impl.core.logging.OGSALog4jLog")) : class$org$globus$ogsa$impl$core$logging$OGSALog4jLog).getName();
    private static boolean initialized = false;
    private static String LAYOUT = "[%d{MM/dd/yyyy HH:mm:ss:SSS} ] %c [%M:%L] %p: %m%n";
    public Logger logit = null;
    public PatternLayout thePattern = new PatternLayout(LAYOUT);
    private LogWrite logger = new LogWrite();
    private OGSALogFactory callFactory;
    private String myLoggerName;
    public ConsoleAppender consoleAppender = new ConsoleAppender((Layout)this.thePattern, "System.out");
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$logging$OGSALog4jLog;

    public OGSALog4jLog() {
        if (!initialized) {
            this.initialize();
        }
    }

    public OGSALog4jLog(String name) {
        if (!initialized) {
            this.initialize();
        }
        this.logit = Logger.getLogger((String)name);
    }

    public OGSALog4jLog(Logger loger, OGSALogFactory oGSALogFactory, String aName) {
        this.callFactory = oGSALogFactory;
        if (!initialized) {
            this.initialize();
        }
        this.logit = loger;
        this.myLoggerName = aName;
    }

    public OGSALog4jLog(Logger loger) {
        if (!initialized) {
            this.initialize();
        }
        this.logit = loger;
    }

    private void initialize() {
        this.consoleAppender.setName("ogsi-logging");
        initialized = true;
    }

    public Logger getLogger() {
        return this.logit;
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.logger.log(FQCN, Priority.DEBUG, message, null);
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.logger.log(FQCN, Priority.DEBUG, message, t);
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.logger.log(FQCN, Priority.DEBUG, message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger.log(FQCN, Priority.DEBUG, message, t);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.logger.log(FQCN, Priority.INFO, message, null);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger.log(FQCN, Priority.INFO, message, t);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.logger.log(FQCN, Priority.WARN, message, null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logger.log(FQCN, Priority.WARN, message, t);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.logger.log(FQCN, Priority.ERROR, message, null);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logger.log(FQCN, Priority.ERROR, message, t);
        }
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.logger.log(FQCN, Priority.FATAL, message, null);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.logger.log(FQCN, Priority.FATAL, message, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    public boolean isFatalEnabled() {
        return this.fatalEnabled;
    }

    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    public void enableTrace() {
        this.traceEnabled = true;
    }

    public void disableTrace() {
        this.traceEnabled = false;
    }

    public void enableFatal() {
        this.fatalEnabled = true;
    }

    public void disableFatal() {
        this.fatalEnabled = false;
    }

    public void enableDebug() {
        this.debugEnabled = true;
    }

    public void disableDebug() {
        this.debugEnabled = false;
    }

    public void enableError() {
        this.errorEnabled = true;
    }

    public void disableError() {
        this.errorEnabled = false;
    }

    public void enableWarn() {
        this.warnEnabled = true;
    }

    public void disableWarn() {
        this.warnEnabled = false;
    }

    public void enableInfo() {
        this.infoEnabled = true;
    }

    public void disableInfo() {
        this.infoEnabled = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LogWrite {
        private LogWrite() {
        }

        public void log(String s, Priority p, Object m, Throwable t) {
            OGSALog4jLog.this.logit.log(s, p, m, t);
            LogMessageElement lme = new LogMessageElement();
            lme.setLevel(p.toString());
            String msg = m.toString();
            if (t != null) {
                msg = msg + " " + t.toString();
            }
            lme.setMessage(msg);
            OGSALog4jLog.this.callFactory.writeToServiceData(lme);
        }
    }
}

