/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.core.logging.LogMessageElement;
import org.globus.ogsa.core.logging.UnableToPersistFaultElement;
import org.globus.ogsa.impl.core.logging.OGSALog4jLog;
import org.globus.ogsa.impl.core.logging.OGSALogUtil;
import org.globus.ogsa.impl.core.logging.OgsiLogging;

public class OGSALogFactory
extends LogFactory {
    private Hashtable attributes = new Hashtable();
    private Hashtable instances = new Hashtable();
    private static ResourceBundle configBundle = null;
    private static String conFile = "ogsilogging_parms";
    private InputStream m_oPropStreamIn;
    private FileOutputStream m_oPropStreamOut;
    private Properties m_oProps;
    private Properties c_oProps;
    private boolean logForJ = true;
    private static String logEngine_key = "LogEngine";
    private OgsiLogging log_service = null;
    private boolean logging_service_active = false;
    private String persistentAttributeLocation = "";
    private String logDestinationBasePath = "";
    private static String base_path_key = "logDestinationBasePath";
    private static String location_key = "persistentAttributeLocation";
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$logging$OGSALogFactory;

    public OGSALogFactory() {
        try {
            this.loadParms();
            try {
                this.loadAttributesFisrt();
            }
            catch (Exception e) {
                System.out.println("OGSA Logfactory encountered unexpected error=" + e.toString());
                e.printStackTrace();
            }
        }
        catch (Exception e) {}
    }

    private String getContainerConfigPath() {
        try {
            return ContainerConfig.getPath();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void loadParms() {
        ResourceBundle myparms = OGSALogFactory.getConfig();
        if (myparms != null) {
            Enumeration<String> parms = myparms.getKeys();
            while (parms.hasMoreElements()) {
                String key = parms.nextElement();
                String value = myparms.getString(key);
                if (key.equalsIgnoreCase(base_path_key)) {
                    this.logDestinationBasePath = value;
                    continue;
                }
                if (!key.equalsIgnoreCase(location_key)) continue;
                this.persistentAttributeLocation = value;
            }
        } else {
            System.out.println("OGSI LogFactory parms are missing/defaulted.");
        }
    }

    public String getLogDestinationBasePath() {
        return this.logDestinationBasePath;
    }

    public void saveRuntime() throws UnableToPersistFaultElement {
        this.m_oProps = new Properties();
        this.m_oProps.putAll((Map<?, ?>)this.attributes);
        UnableToPersistFaultElement utp = new UnableToPersistFaultElement();
        try {
            this.m_oPropStreamOut = new FileOutputStream(this.getContainerConfigPath() + this.persistentAttributeLocation.trim());
        }
        catch (FileNotFoundException e) {
            utp.setFaultDetailString("OGSA log attribute cache SAVE error, file not found" + e.toString());
            throw utp;
        }
        try {
            this.m_oProps.store(this.m_oPropStreamOut, "ogsi log properties");
            this.m_oPropStreamOut.close();
        }
        catch (IOException e) {
            utp.setFaultDetailString("OGSA log attribute cache SAVE error during store operation:" + e.toString());
            throw utp;
        }
        this.m_oProps = null;
    }

    private void loadTempProperties() throws UnableToPersistFaultElement {
        this.c_oProps = new Properties();
        UnableToPersistFaultElement utp = new UnableToPersistFaultElement();
        try {
            this.m_oPropStreamIn = new FileInputStream(this.getContainerConfigPath() + this.persistentAttributeLocation.trim());
            if (this.c_oProps != null) {
                this.c_oProps.load(this.m_oPropStreamIn);
                this.m_oPropStreamIn.close();
            }
        }
        catch (FileNotFoundException e) {
            this.c_oProps = null;
            utp.setFaultDetailString(e.toString());
            throw utp;
        }
        catch (IOException e) {
            this.c_oProps = null;
            utp.setFaultDetailString(e.toString());
            throw utp;
        }
    }

    private void saveTempProperties() throws UnableToPersistFaultElement {
        UnableToPersistFaultElement utp = new UnableToPersistFaultElement();
        try {
            this.m_oPropStreamOut = new FileOutputStream(this.getContainerConfigPath() + this.persistentAttributeLocation.trim());
        }
        catch (FileNotFoundException e) {
            utp.setFaultDetailString(e.toString());
            throw utp;
        }
        try {
            this.c_oProps.store(this.m_oPropStreamOut, "ogsi log properties");
            this.m_oPropStreamOut.close();
        }
        catch (IOException e) {
            utp.setFaultDetailString(e.toString());
            throw utp;
        }
    }

    public void loadAttributesFisrt() {
        this.c_oProps = new Properties();
        try {
            File file = new File(this.getContainerConfigPath() + this.persistentAttributeLocation.trim());
            try {
                this.m_oPropStreamIn = new FileInputStream(this.getContainerConfigPath() + this.persistentAttributeLocation.trim());
            }
            catch (FileNotFoundException e) {
                this.m_oPropStreamIn = (class$org$globus$ogsa$impl$core$logging$OGSALogFactory == null ? (class$org$globus$ogsa$impl$core$logging$OGSALogFactory = OGSALogFactory.class$("org.globus.ogsa.impl.core.logging.OGSALogFactory")) : class$org$globus$ogsa$impl$core$logging$OGSALogFactory).getClassLoader().getResourceAsStream(this.persistentAttributeLocation.trim());
            }
            if (this.c_oProps != null) {
                this.c_oProps.load(this.m_oPropStreamIn);
                this.attributes.putAll(this.c_oProps);
                this.m_oPropStreamIn.close();
            }
        }
        catch (FileNotFoundException e) {
            this.c_oProps = null;
            System.out.println("OGSA logfactory: ogsilogging.properties error=" + e.toString());
        }
        catch (IOException e) {
            this.c_oProps = null;
            System.out.println("OGSA logfactory: ogsilogging.properties error=" + e.toString());
        }
    }

    public void loadAttributes() throws UnableToPersistFaultElement {
        UnableToPersistFaultElement utp = new UnableToPersistFaultElement();
        this.c_oProps = new Properties();
        try {
            this.m_oPropStreamIn = new FileInputStream(this.getContainerConfigPath() + this.persistentAttributeLocation.trim());
            if (this.c_oProps != null) {
                this.c_oProps.load(this.m_oPropStreamIn);
                this.attributes.putAll(this.c_oProps);
                this.m_oPropStreamIn.close();
                Enumeration keys = this.attributes.keys();
                while (keys.hasMoreElements()) {
                    String tok = (String)keys.nextElement();
                    String value = (String)this.getAttribute(tok);
                    this.setAttribute(tok, value);
                }
            }
        }
        catch (FileNotFoundException e) {
            this.c_oProps = null;
            utp.setFaultDetailString("OGSA logfactory: ogsilogging.properties error=" + e.toString());
            throw utp;
        }
        catch (IOException e) {
            this.c_oProps = null;
            utp.setFaultDetailString("OGSA logfactory: ogsilogging.properties error=" + e.toString());
            throw utp;
        }
    }

    public static String getDefaultFileName() throws UnableToPersistFaultElement {
        String filename;
        block3: {
            filename = null;
            ResourceBundle config = OGSALogFactory.getConfig();
            if (config == null) break block3;
            try {
                String defaultAttributes = config.getString("default");
                StringTokenizer st = new StringTokenizer(defaultAttributes);
                if (st.hasMoreTokens()) {
                    filename = st.nextToken(",");
                }
            }
            catch (Exception e) {
                System.out.println("default file not set in ogsilogging.properties " + e.toString());
            }
        }
        return filename;
    }

    public void setAttributeConfig(String aName, Object aValue) throws UnableToPersistFaultElement {
        this.loadTempProperties();
        if (this.c_oProps != null) {
            if (aValue == null) {
                if (this.c_oProps.containsKey(aName)) {
                    this.c_oProps.remove(aName);
                }
            } else if (this.c_oProps.containsKey(aName)) {
                this.c_oProps.remove(aName);
                this.c_oProps.put(aName, aValue);
            } else {
                this.c_oProps.put(aName, aValue);
            }
            this.saveTempProperties();
        }
    }

    public Object getAttributeConfig(String aName) throws UnableToPersistFaultElement {
        this.loadTempProperties();
        if (this.c_oProps != null) {
            if (this.c_oProps.containsKey(aName)) {
                return this.c_oProps.get(aName);
            }
            return "";
        }
        return "";
    }

    public boolean hasAttributeConfig(String aName) throws UnableToPersistFaultElement {
        this.loadTempProperties();
        if (this.c_oProps != null) {
            return this.c_oProps.containsKey(aName);
        }
        return false;
    }

    public void removeAttributeConfig(String aName) throws UnableToPersistFaultElement {
        this.loadTempProperties();
        if (this.c_oProps != null && this.c_oProps.containsKey(aName)) {
            this.c_oProps.remove(aName);
            this.saveTempProperties();
        }
    }

    public void setAttribute(String aName, Object aValue) {
        if (aValue == null) {
            this.removeAttribute(aName);
        } else {
            if (this.attributes.containsKey(aName)) {
                this.removeAttribute(aName);
                this.attributes.put(aName, aValue);
            } else {
                this.attributes.put(aName, aValue);
            }
            this.modifyRuntime(aName);
        }
    }

    protected void modifyRuntime(String aName) {
        boolean ok_to_mod = false;
        Log log = (Log)this.instances.get(aName);
        if (log != null) {
            StringTokenizer st;
            int numToks;
            String mode = "console";
            String level = "default";
            String filename = "unknown";
            String dtag = "";
            if (this.hasAttribute("default") && (numToks = (st = new StringTokenizer(this.getAttribute("default").toString(), ",")).countTokens()) > 1) {
                if (numToks < 3) {
                    mode = st.nextToken(",");
                    level = st.nextToken();
                } else if (numToks < 4) {
                    mode = st.nextToken(",");
                    level = st.nextToken(",");
                    dtag = st.nextToken();
                }
            }
            if (this.hasAttribute(aName)) {
                st = new StringTokenizer(this.getAttribute(aName).toString(), ",");
                numToks = st.countTokens();
                if (numToks > 1) {
                    if (numToks < 3) {
                        mode = st.nextToken(",");
                        level = st.nextToken();
                        ok_to_mod = true;
                    } else if (numToks < 4) {
                        mode = st.nextToken(",");
                        level = st.nextToken(",");
                        dtag = st.nextToken();
                        ok_to_mod = true;
                    }
                }
            } else {
                System.out.println(" OGSA logfactory: persistent attribute not found in cache n=" + aName);
            }
            if (ok_to_mod) {
                this.setLevelOnInstance(level, log);
                if (mode.equalsIgnoreCase("console")) {
                    boolean console = true;
                } else {
                    filename = mode;
                    boolean console = false;
                }
            }
        }
    }

    public String[] getAttributeNames() {
        Vector<String> names = new Vector<String>();
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            names.addElement((String)keys.nextElement());
        }
        String[] results = new String[names.size()];
        int i = 0;
        while (i < results.length) {
            results[i] = (String)names.elementAt(i);
            ++i;
        }
        return results;
    }

    public String[] getAttributeNamesConfig() throws UnableToPersistFaultElement {
        Vector<String> names = new Vector<String>();
        this.loadTempProperties();
        if (this.c_oProps != null) {
            Enumeration<Object> keys = this.c_oProps.keys();
            while (keys.hasMoreElements()) {
                names.addElement((String)keys.nextElement());
            }
        }
        String[] results = new String[names.size()];
        int i = 0;
        while (i < results.length) {
            results[i] = (String)names.elementAt(i);
            ++i;
        }
        return results;
    }

    public Object getAttribute(String aName) {
        if (this.attributes.containsKey(aName)) {
            return this.attributes.get(aName);
        }
        return "";
    }

    public boolean hasAttribute(String aName) {
        return this.attributes.containsKey(aName);
    }

    public void removeAttribute(String aName) {
        if (this.attributes.containsKey(aName)) {
            this.attributes.remove(aName);
        }
    }

    public Log getInstance(String aName) throws LogConfigurationException {
        Log instance = (Log)this.instances.get(aName);
        if (instance == null) {
            instance = this.createInstance(aName);
            this.instances.put(aName, instance);
        }
        return instance;
    }

    public Log getInstance(Class aClass) throws LogConfigurationException {
        Log instance = (Log)this.instances.get(aClass.getName());
        if (instance == null) {
            instance = this.createInstance(aClass.getName());
            this.instances.put(aClass.getName(), instance);
        }
        return instance;
    }

    protected Log createInstance(String aName) throws LogConfigurationException {
        OGSALog4jLog log;
        StringTokenizer st;
        int numToks;
        boolean console = true;
        String mode = "console";
        String level = "default";
        String filename = "unknown";
        String dtag = null;
        if (this.hasAttribute("default") && (numToks = (st = new StringTokenizer(this.getAttribute("default").toString(), ",")).countTokens()) > 1) {
            if (numToks < 3) {
                mode = st.nextToken(",");
                level = st.nextToken();
            } else if (numToks < 4) {
                mode = st.nextToken(",");
                level = st.nextToken(",");
                dtag = st.nextToken();
            }
        }
        if (this.hasAttribute(aName)) {
            st = new StringTokenizer(this.getAttribute(aName).toString(), ",");
            numToks = st.countTokens();
            if (numToks > 1) {
                if (numToks < 3) {
                    mode = st.nextToken(",");
                    level = st.nextToken();
                } else if (numToks < 4) {
                    mode = st.nextToken(",");
                    level = st.nextToken(",");
                    dtag = st.nextToken();
                }
            }
        } else {
            String attributes = dtag == null ? mode + ',' + level : mode + ',' + level + "," + dtag;
            this.setAttribute(aName, attributes);
        }
        if (mode.equalsIgnoreCase("console")) {
            console = true;
        } else {
            filename = mode;
            console = false;
        }
        if (console) {
            log = new OGSALog4jLog(Logger.getLogger((String)aName), this, aName);
            log.getLogger().setLevel(Level.ALL);
            log.getLogger().setAdditivity(false);
            log.getLogger().addAppender((Appender)log.consoleAppender);
        } else {
            log = new OGSALog4jLog(Logger.getLogger((String)aName), this, aName);
            filename = this.logDestinationBasePath.trim() + filename;
            try {
                FileAppender fileApp = new FileAppender((Layout)log.thePattern, filename, true);
                log.getLogger().setLevel(Level.ALL);
                log.getLogger().setAdditivity(false);
                log.getLogger().addAppender((Appender)fileApp);
            }
            catch (Exception e) {
                System.out.println("OGSA log4j error with file=" + filename + " exception was:" + e.toString());
                throw new LogConfigurationException("OGSA log4j error with file=" + filename + " exception was:" + e.toString());
            }
        }
        this.setLevelOnInstance(level, log);
        return log;
    }

    private void setLevelOnInstance(String level, Log log) {
        ((OGSALogUtil)log).disableTrace();
        ((OGSALogUtil)log).disableDebug();
        ((OGSALogUtil)log).disableInfo();
        ((OGSALogUtil)log).disableWarn();
        ((OGSALogUtil)log).disableError();
        ((OGSALogUtil)log).disableFatal();
        if (level.equals("default")) {
            ((OGSALogUtil)log).enableWarn();
            ((OGSALogUtil)log).enableError();
            ((OGSALogUtil)log).enableFatal();
        } else if (level.equalsIgnoreCase("debug") || level.equalsIgnoreCase("all")) {
            ((OGSALogUtil)log).enableDebug();
            ((OGSALogUtil)log).enableInfo();
            ((OGSALogUtil)log).enableTrace();
            ((OGSALogUtil)log).enableWarn();
            ((OGSALogUtil)log).enableError();
            ((OGSALogUtil)log).enableFatal();
        } else if (level.equalsIgnoreCase("trace")) {
            ((OGSALogUtil)log).enableInfo();
            ((OGSALogUtil)log).enableTrace();
            ((OGSALogUtil)log).enableWarn();
            ((OGSALogUtil)log).enableError();
            ((OGSALogUtil)log).enableFatal();
        } else if (level.equalsIgnoreCase("info")) {
            ((OGSALogUtil)log).enableInfo();
            ((OGSALogUtil)log).enableWarn();
            ((OGSALogUtil)log).enableError();
            ((OGSALogUtil)log).enableFatal();
        } else if (level.equalsIgnoreCase("warn")) {
            ((OGSALogUtil)log).enableWarn();
            ((OGSALogUtil)log).enableError();
            ((OGSALogUtil)log).enableFatal();
        } else if (level.equalsIgnoreCase("error")) {
            ((OGSALogUtil)log).enableError();
            ((OGSALogUtil)log).enableFatal();
        } else if (level.equalsIgnoreCase("fatal")) {
            ((OGSALogUtil)log).enableFatal();
        } else if (level.equalsIgnoreCase("off")) {
            // empty if block
        }
    }

    public void release() {
        if (!this.instances.isEmpty()) {
            this.instances.clear();
        }
    }

    public boolean rasLogFactorySelfTest(OgsiLogging ls) {
        this.log_service = ls;
        return true;
    }

    public synchronized void writeToServiceData(LogMessageElement aMsg) {
        if (this.logging_service_active) {
            String msg = aMsg.getMessage();
            String lev = aMsg.getLevel().trim();
            Date dd = Calendar.getInstance(Locale.US).getTime();
            String stamp = "[" + dd.toString() + "] ";
            aMsg.setMessage(stamp + " " + lev.substring(0, 1) + "- " + msg);
            this.log_service.addToMessageBucket(aMsg);
        }
    }

    public void logging_service_ActiveState(boolean state) {
        this.logging_service_active = state;
    }

    public static ResourceBundle getConfig() {
        configBundle = null;
        try {
            configBundle = ResourceBundle.getBundle(conFile, Locale.getDefault());
        }
        catch (Exception e) {
            System.out.println("OGSA failed to locate ogsilogging_parms.properties " + e.toString());
        }
        return configBundle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

