/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.service;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataListener;
import org.globus.ogsa.ServiceDataSet;
import org.gridforum.ogsi.ExtensibilityNotSupportedFaultType;
import org.gridforum.ogsi.FaultType;

public class ServiceDataSetImpl
implements ServiceDataSet {
    private Hashtable serviceDataEntries = new Hashtable();
    private Hashtable serviceDataListeners = new Hashtable();
    private Hashtable serviceDataEntryCache = new Hashtable();
    private boolean cacheDirty = false;

    public Object evaluate(Object expression) throws FaultType {
        throw new ExtensibilityNotSupportedFaultType();
    }

    public ServiceData create(String name) throws GridServiceException {
        return this.create(new QName("", name));
    }

    public ServiceData create(QName name) throws GridServiceException {
        QName qname = this.checkMatching(name);
        ServiceData serviceData = null;
        if (qname != null) {
            serviceData = this.get(qname);
        }
        if (serviceData == null) {
            serviceData = new ServiceData(name, this);
        }
        return serviceData;
    }

    public void add(ServiceData serviceData) throws GridServiceException {
        this.serviceDataEntries.put(serviceData.getName(), serviceData);
        this.setCacheDirty(true);
    }

    public QName checkMatching(QName qname) throws GridServiceException {
        Object obj = this.serviceDataEntries.get(qname);
        if (obj != null) {
            return qname;
        }
        if (qname.getNamespaceURI().equals("")) {
            String localName = qname.getLocalPart();
            Enumeration enumeration = this.serviceDataEntries.keys();
            while (enumeration.hasMoreElements()) {
                QName key = (QName)enumeration.nextElement();
                if (!key.getLocalPart().equals(localName)) continue;
                return key;
            }
        }
        return null;
    }

    public ServiceData get(String name) throws GridServiceException {
        return this.get(new QName("", name));
    }

    public ServiceData get(QName name) throws GridServiceException {
        return (ServiceData)this.serviceDataEntries.get(name);
    }

    public ServiceData remove(String name) throws GridServiceException {
        return this.remove(new QName("", name));
    }

    public ServiceData remove(QName name) throws GridServiceException {
        ServiceData data = (ServiceData)this.serviceDataEntries.remove(name);
        this.setCacheDirty(true);
        return data;
    }

    public void delete(String name) throws GridServiceException {
        this.delete(new QName("", name));
    }

    public void delete(QName name) throws GridServiceException {
        this.serviceDataEntries.remove(name);
        this.setCacheDirty(true);
    }

    public void registerListener(ServiceDataListener listener) {
        this.serviceDataListeners.put(listener, listener);
    }

    public void removeListener(ServiceDataListener listener) {
        this.serviceDataListeners.remove(listener);
    }

    public QName[] getNames() {
        QName[] qname = new QName[this.serviceDataEntries.size()];
        int i = 0;
        Enumeration enumeration = this.serviceDataEntries.elements();
        while (enumeration.hasMoreElements()) {
            qname[i] = ((ServiceData)enumeration.nextElement()).getName();
            ++i;
        }
        return qname;
    }

    public QName[] getNotifiableNames() {
        ArrayList<ServiceData> notifiables = new ArrayList<ServiceData>();
        Enumeration enumeration = this.serviceDataEntries.elements();
        while (enumeration.hasMoreElements()) {
            ServiceData serviceData = (ServiceData)enumeration.nextElement();
            if (!serviceData.isNotifiable()) continue;
            notifiables.add(serviceData);
        }
        QName[] qname = new QName[notifiables.size()];
        int i = 0;
        Iterator iterator = notifiables.iterator();
        while (iterator.hasNext()) {
            qname[i] = ((ServiceData)iterator.next()).getName();
            ++i;
        }
        return qname;
    }

    public synchronized Iterator iterator() {
        if (this.isCacheDirty()) {
            this.serviceDataEntryCache = (Hashtable)this.serviceDataEntries.clone();
            this.setCacheDirty(false);
        }
        return this.serviceDataEntryCache.values().iterator();
    }

    private boolean isCacheDirty() {
        return this.cacheDirty;
    }

    private synchronized void setCacheDirty(boolean dirty) {
        this.cacheDirty = dirty;
    }

    public int size() {
        return this.serviceDataEntries.values().size();
    }

    public synchronized void notifyListeners(ServiceData serviceData) {
        Enumeration enumeration = this.serviceDataListeners.elements();
        while (enumeration.hasMoreElements()) {
            ServiceDataListener listener = (ServiceDataListener)enumeration.nextElement();
            listener.serviceDataChanged(serviceData, false);
        }
    }

    public synchronized void notifyListenersWithAck(ServiceData serviceData) {
        Enumeration enumeration = this.serviceDataListeners.elements();
        while (enumeration.hasMoreElements()) {
            ServiceDataListener listener = (ServiceDataListener)enumeration.nextElement();
            listener.serviceDataChanged(serviceData, true);
        }
    }
}

