/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.ogsi;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.DestroyListener;
import org.globus.ogsa.FactoryCallback;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceCallback;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.OperationProvider;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataSet;
import org.globus.ogsa.ServiceGroupEntryGenerator;
import org.globus.ogsa.ServiceLifecycleMonitor;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.WSDLGenerator;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.deployment.DeploymentException;
import org.globus.ogsa.deployment.ServiceDeployment;
import org.globus.ogsa.impl.core.factory.RegistryUpdateTask;
import org.globus.ogsa.impl.core.factory.ServiceSweeperTask;
import org.globus.ogsa.repository.ServiceActivator;
import org.globus.ogsa.repository.ServiceLoader;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.utils.CalendarUtils;
import org.globus.ogsa.utils.ExtendedDateTimeHelper;
import org.globus.ogsa.utils.FaultHelper;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.SweeperPool;
import org.globus.ogsa.wsdl.GSR;
import org.globus.ogsa.wsdl.GSRDescription;
import org.globus.ogsa.wsdl.extensions.PortTypeExtensibilityElement;
import org.gridforum.ogsi.CreateServiceExtensibilityType;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.ExtensibilityNotSupportedFaultType;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.ExtensibilityTypeFaultType;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.InfinityType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.ReferenceType;
import org.gridforum.ogsi.ServiceAlreadyExistsFaultType;
import org.gridforum.ogsi.TerminationTimeType;
import org.gridforum.ogsi.WSDLReferenceType;
import org.gridforum.ogsi.holders.ExtensibilityTypeHolder;
import org.gridforum.ogsi.holders.LocatorTypeHolder;
import org.gridforum.ogsi.holders.TerminationTimeTypeHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FactoryProvider
implements OperationProvider,
DestroyListener,
GridServiceCallback {
    public static final QName[] operations = new QName[]{new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "createService")};
    protected GridServiceBase base;
    private ServiceNode factoryNode;
    private ServiceLoader loader;
    private ServiceDeployment deployment = null;
    private ServiceLifecycleMonitor lifecycleMonitor = null;
    private ServiceSweeperTask sweeperTask = null;
    private RegistryUpdateTask registryTask = null;
    protected FactoryCallback factoryCallback = null;
    private boolean disableFactoryRegistry;
    private boolean dirty = false;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$ogsi$FactoryProvider == null ? (class$org$globus$ogsa$impl$ogsi$FactoryProvider = FactoryProvider.class$("org.globus.ogsa.impl.ogsi.FactoryProvider")) : class$org$globus$ogsa$impl$ogsi$FactoryProvider).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$ogsi$FactoryProvider;
    static /* synthetic */ Class class$org$gridforum$ogsi$ServiceAlreadyExistsFaultType;

    public QName[] getOperations() {
        return operations;
    }

    private void checkPersistence() {
        String lifecycle = (String)this.base.getProperty("lifecycle");
        if (lifecycle != null && lifecycle.equalsIgnoreCase("persistent")) {
            this.deployment.setPersistentProperties(this.base, (String)this.base.getProperty("servicePath"));
        }
    }

    public void initialize(GridServiceBase base) throws GridServiceException {
        try {
            String loaderClass;
            this.base = base;
            this.deployment = new ServiceDeployment();
            this.checkPersistence();
            WSDLGenerator.getInstanceWSDL(this.base);
            String name = (String)base.getProperty("name");
            if (name == null || name.equals("")) {
                base.setProperty("name", "Factory of " + (String)base.getProperty("instance-portType"));
            }
            base.setProperty("factoryProvider", this);
            this.factoryNode = (ServiceNode)base.getProperty("serviceNode");
            String activatorClass = (String)base.getProperty("serviceActivator");
            if (activatorClass != null) {
                Class<?> javaClass = Class.forName(activatorClass);
                this.factoryNode.setActivator((ServiceActivator)javaClass.newInstance());
            }
            if ((loaderClass = (String)base.getProperty("serviceLoader")) != null) {
                Class<?> javaClass = Class.forName(loaderClass);
                this.loader = (ServiceLoader)javaClass.newInstance();
                this.factoryNode.setLoader(this.loader);
            }
            this.sweeperTask = new ServiceSweeperTask(this.factoryNode);
            this.registryTask = new RegistryUpdateTask(this);
            SweeperPool.getDefaultPool().addTask(this.sweeperTask);
            SweeperPool.getDefaultPool().addTask(this.registryTask);
            String monitorClass = (String)base.getProperty("lifecycleMonitorClass");
            if (monitorClass != null) {
                Class<?> javaClass = MessageContext.getCurrentContext().getClassLoader().loadClass(monitorClass);
                this.lifecycleMonitor = (ServiceLifecycleMonitor)javaClass.newInstance();
            }
            this.addServiceData();
            String disableFactoryRegistryProperty = (String)base.getProperty("disableFactoryRegistry");
            this.disableFactoryRegistry = disableFactoryRegistryProperty != null && disableFactoryRegistryProperty.equalsIgnoreCase("true");
            this.setDirty(true);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public void cancelSweeper() {
        if (this.sweeperTask != null) {
            this.sweeperTask.cancel();
        }
        if (this.registryTask != null) {
            this.registryTask.cancel();
        }
    }

    public GridServiceBase activateService(Calendar dateTime, String instanceID) throws GridServiceException {
        try {
            String factoryPath = (String)this.base.getProperty("servicePath");
            boolean persistentActivation = ContainerConfig.getConfig().getPersistentServicesOptions().get(factoryPath + "/" + instanceID) != null;
            ExtendedDateTimeType extendedDateTime = new ExtendedDateTimeType();
            if (dateTime != null) {
                extendedDateTime.setValue(dateTime);
            } else {
                extendedDateTime.setValue(InfinityType.infinity);
            }
            TerminationTimeType terminationTime = new TerminationTimeType();
            terminationTime.setAfter(extendedDateTime);
            terminationTime.setBefore(extendedDateTime);
            this.createService(terminationTime, new ExtensibilityType(), new LocatorTypeHolder(), new TerminationTimeTypeHolder(), instanceID, true, persistentActivation);
        }
        catch (GridServiceException gse) {
            throw gse;
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        return (GridServiceBase)this.factoryNode.resolve(instanceID);
    }

    public void createService(TerminationTimeType terminationTime, ExtensibilityType creationParameters, LocatorTypeHolder locator, TerminationTimeTypeHolder currentTerminationTime, ExtensibilityTypeHolder extensibilityOutput) throws RemoteException, FaultType, ServiceAlreadyExistsFaultType, ExtensibilityNotSupportedFaultType, ExtensibilityTypeFaultType {
        this.createService(terminationTime, creationParameters, locator, currentTerminationTime, this.getInvocationID(), false, false);
    }

    public void createPersistentService(TerminationTimeType terminationTime, ExtensibilityType creationParameters, LocatorTypeHolder locator, TerminationTimeTypeHolder currentTerminationTime, ExtensibilityTypeHolder extensibilityOutput) throws RemoteException, FaultType, ServiceAlreadyExistsFaultType, ExtensibilityNotSupportedFaultType, ExtensibilityTypeFaultType {
        this.createService(terminationTime, creationParameters, locator, currentTerminationTime, this.getInvocationID(), false, true);
    }

    private String getInvocationID() {
        return (String)MessageContext.getCurrentContext().getProperty("org.globus.ogsa.InvocationID");
    }

    public HandleType lazyCreate() {
        String factoryHandle = (String)this.base.getProperty("Handle");
        String instanceHandle = factoryHandle + "/" + this.getID();
        HandleType handle = new HandleType(instanceHandle);
        return handle;
    }

    private String getID() {
        return "hash-" + Thread.currentThread().hashCode() + "-" + System.currentTimeMillis();
    }

    public synchronized void setCallback(FactoryCallback callback) {
        this.factoryCallback = callback;
    }

    private synchronized void initCallback() throws GridServiceException {
        if (this.factoryCallback == null) {
            String factoryCallbackClass = (String)this.base.getProperty("factoryCallback");
            if (factoryCallbackClass == null) {
                throw new GridServiceException(MessageUtils.getMessage("factoryCallbackNotFound"));
            }
            try {
                this.factoryCallback = (FactoryCallback)(class$org$globus$ogsa$impl$ogsi$FactoryProvider == null ? (class$org$globus$ogsa$impl$ogsi$FactoryProvider = FactoryProvider.class$("org.globus.ogsa.impl.ogsi.FactoryProvider")) : class$org$globus$ogsa$impl$ogsi$FactoryProvider).getClassLoader().loadClass(factoryCallbackClass).newInstance();
            }
            catch (Exception e) {
                throw new GridServiceException(factoryCallbackClass, e);
            }
            this.factoryCallback.initialize(this.base);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createService(TerminationTimeType terminationTime, ExtensibilityType creationParameters, LocatorTypeHolder locator, TerminationTimeTypeHolder currentTerminationTime, String path, boolean activation, boolean persistent) throws RemoteException, FaultType, ServiceAlreadyExistsFaultType, ExtensibilityNotSupportedFaultType, ExtensibilityTypeFaultType {
        try {
            this.initCallback();
            GridServiceBase node = this.factoryCallback.createServiceObject(creationParameters);
            if (path == null) {
                path = this.getID();
            }
            String servicePath = (String)this.base.getProperty("servicePath");
            String instancePath = servicePath + "/" + path;
            logger.debug((Object)("Creating " + instancePath));
            this.base.populateInstanceProperties(node);
            String instanceSchemaPath = (String)this.base.getInstanceProperty("schemaPath");
            logger.debug((Object)("Loading WSDL from: " + instanceSchemaPath));
            String instanceLifecycle = (String)node.getProperty("lifecycle");
            if (instanceLifecycle == null) {
                instanceLifecycle = "transient";
            }
            if (persistent) {
                instanceLifecycle = "persistent";
            }
            node.setProperty("lifecycle", instanceLifecycle);
            String factoryHandle = (String)this.base.getProperty("Handle");
            if (this.lifecycleMonitor != null) {
                node.setProperty("lifecycleMonitor", this.lifecycleMonitor);
            }
            node.setProperty("port", this.base.getProperty("port"));
            node.setProperty("protocol", this.base.getProperty("protocol"));
            node.setProperty("factory", this.base);
            node.setProperty("factoryProvider", this);
            node.setProperty("destroyListener", this);
            node.setProperty("servicePath", instancePath);
            node.setProperty("FactoryHandle", factoryHandle);
            FactoryProvider factoryProvider = this;
            synchronized (factoryProvider) {
                Object obj = this.factoryNode.resolve(path);
                if (!activation && obj != null) {
                    throw FaultHelper.makeFault(class$org$gridforum$ogsi$ServiceAlreadyExistsFaultType == null ? (class$org$gridforum$ogsi$ServiceAlreadyExistsFaultType = FactoryProvider.class$("org.gridforum.ogsi.ServiceAlreadyExistsFaultType")) : class$org$gridforum$ogsi$ServiceAlreadyExistsFaultType, path);
                }
            }
            WSDLGenerator.getWSDL(node);
            Document doc = (Document)node.getProperty("WSDL");
            Element element = doc.getDocumentElement();
            LocatorType locatorValue = new LocatorType();
            WSDLReferenceType reference = new WSDLReferenceType();
            MessageElement messageElement = new MessageElement(element);
            reference.set_any(new MessageElement[]{messageElement});
            locatorValue.setReference(new ReferenceType[]{reference});
            locator.value = locatorValue;
            this.deployment.deploy(instancePath, node);
            ExtendedDateTimeType dateTime = null;
            if (terminationTime == null) {
                dateTime = new ExtendedDateTimeType();
                dateTime.setValue(InfinityType.infinity);
            } else {
                dateTime = terminationTime.getAfter();
            }
            if (!ExtendedDateTimeHelper.isInfinity(dateTime)) {
                node.setPersistentProperty("timeout", CalendarUtils.toString(dateTime.getDateTimeValue()));
            }
            try {
                node.setProperty("serviceNode", ServiceNode.getRootNode().getNode(instancePath));
                node.preCreate(this.base);
                GridContext context = new GridContext((javax.xml.rpc.handler.MessageContext)MessageContext.getCurrentContext(), this.base, this.base.getServiceDataSet());
                if (activation) {
                    node.activate(context);
                }
                node.postCreate(context);
                if (this.lifecycleMonitor != null) {
                    context.setServiceProperties(node);
                    context.setProperty("activation", activation ? Boolean.TRUE : Boolean.FALSE);
                    this.lifecycleMonitor.create(context);
                }
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("instanceCreationError"), (Throwable)e);
                node.destroy();
                throw e;
            }
            if (instanceLifecycle != null && instanceLifecycle.equalsIgnoreCase("persistent")) {
                node.setPersistentProperty("persistent", "true");
                node.setPersistentProperty("type", "transient");
                this.deployment.saveServiceAsync(instancePath);
            }
            this.setDirty(true);
            currentTerminationTime.value = node.getTerminationTime();
        }
        catch (GridServiceException gse) {
            throw gse;
        }
        catch (RuntimeException runtimeExc) {
            throw runtimeExc;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw FaultHelper.makeFault(MessageUtils.getMessage("createServiceError"), e);
        }
        MessageContext context = MessageContext.getCurrentContext();
        if (context != null) {
            context.setProperty("org.globus.ogsa.ContainsReference", (Object)Boolean.TRUE);
        }
    }

    public void notifyDestroy(String service) throws GridServiceException {
        ServiceProperties properties = (ServiceProperties)ServiceNode.getRootNode().resolve(service);
        String instanceLifecycle = (String)properties.getProperty("lifecycle");
        this.deployment.undeploy(service);
        if (this.lifecycleMonitor != null) {
            try {
                this.lifecycleMonitor.destroy(new GridContext(null, properties));
            }
            catch (Exception e) {
                throw new DeploymentException(e);
            }
        }
        if (instanceLifecycle != null && instanceLifecycle.equalsIgnoreCase("persistent")) {
            this.deployment.removeService(service);
        }
        this.setDirty(true);
        if (this.loader != null) {
            this.loader.remove(service);
        }
    }

    public void deactivateInstance(String service) throws GridServiceException {
        try {
            if (this.loader != null) {
                this.deployment.undeploy(service);
                this.loader.store(service);
            }
            this.setDirty(true);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    private synchronized boolean isDirty() {
        return this.dirty;
    }

    private synchronized void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public synchronized void updateRegistry() throws GridServiceException {
        if (!this.isDirty()) {
            return;
        }
        this.setDirty(false);
        try {
            if (this.disableFactoryRegistry) {
                return;
            }
            Collection collection = ServiceGroupEntryGenerator.nodeToEntries(this.factoryNode);
            ServiceGroupEntryGenerator.updateServiceDataEntries(collection, this.base);
        }
        catch (GridServiceException e) {
            throw new GridServiceException(MessageUtils.getMessage("getFactoryRegistryError", new String[]{(String)this.base.getProperty("servicePath")}), e);
        }
    }

    private void addServiceData() throws GridServiceException {
        ServiceDataSet serviceDataSet = this.base.getServiceDataSet();
        ServiceData createsInterface = new ServiceData(ServiceData.CREATE_EXTENSIBILITY, serviceDataSet);
        GSRDescription description = (GSRDescription)this.base.getProperty("instance-GSRDescription");
        GSR gsr = description.getGSR();
        Collection portTypes = gsr.getGWSDLPortTypes();
        if (portTypes.size() > 0) {
            CreateServiceExtensibilityType createService = new CreateServiceExtensibilityType();
            createService.setCreatesInterface(new QName[]{((PortTypeExtensibilityElement)portTypes.iterator().next()).getName()});
            createsInterface.setValue(createService);
            serviceDataSet.add(createsInterface);
        }
    }

    public void preCreate(GridServiceBase base) throws GridServiceException {
        this.initCallback();
        if (!this.factoryCallback.equals(this) && this.factoryCallback instanceof GridServiceCallback) {
            ((GridServiceCallback)((Object)this.factoryCallback)).preCreate(base);
        }
    }

    public void postCreate(GridContext context) throws GridServiceException {
        if (!this.factoryCallback.equals(this) && this.factoryCallback instanceof GridServiceCallback) {
            ((GridServiceCallback)((Object)this.factoryCallback)).postCreate(context);
        }
    }

    public void activate(GridContext context) throws GridServiceException {
        Vector nodes = this.factoryNode.getAllServices();
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            ServiceProperties node = (ServiceProperties)iterator.next();
            if (node.equals(this.base)) continue;
            ServiceNode.getRootNode().activate((String)node.getProperty("servicePath"));
        }
        if (!this.factoryCallback.equals(this) && this.factoryCallback instanceof GridServiceCallback) {
            ((GridServiceCallback)((Object)this.factoryCallback)).activate(context);
        }
    }

    public void deactivate(GridContext context) throws GridServiceException {
        Vector nodes = this.factoryNode.getAllServices();
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            ServiceProperties node = (ServiceProperties)iterator.next();
            if (node.equals(this.base)) continue;
            ServiceNode.getRootNode().deactivate((String)node.getProperty("servicePath"));
        }
        if (!this.factoryCallback.equals(this) && this.factoryCallback instanceof GridServiceCallback) {
            ((GridServiceCallback)((Object)this.factoryCallback)).deactivate(context);
        }
    }

    public void preDestroy(GridContext context) throws GridServiceException {
        if (!this.factoryCallback.equals(this) && this.factoryCallback instanceof GridServiceCallback) {
            ((GridServiceCallback)((Object)this.factoryCallback)).deactivate(context);
        }
        this.cancelSweeper();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

