/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.ogsi;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.DestroyListener;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceCallback;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.OperationProvider;
import org.globus.ogsa.QueryEngine;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataSet;
import org.globus.ogsa.ServiceDataValueCallback;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.core.registry.ServiceDataSweeperTask;
import org.globus.ogsa.impl.core.service.ServiceDataAnnotation;
import org.globus.ogsa.impl.core.service.ServiceDataSetImpl;
import org.globus.ogsa.impl.core.service.ServicePropertiesImpl;
import org.globus.ogsa.impl.ogsi.FactoryProvider;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.CalendarUtils;
import org.globus.ogsa.utils.ExtendedDateTimeHelper;
import org.globus.ogsa.utils.FaultHelper;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QNameUtils;
import org.globus.ogsa.utils.QueryHelper;
import org.globus.ogsa.utils.SweeperPool;
import org.globus.ogsa.wsdl.GSR;
import org.globus.ogsa.wsdl.GSRDescription;
import org.globus.ogsa.wsdl.extensions.PortTypeExtensibilityElement;
import org.gridforum.ogsi.CardinalityViolationFaultType;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.ExtensibilityNotSupportedFaultType;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.ExtensibilityTypeFaultType;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.IncorrectValueFaultType;
import org.gridforum.ogsi.InfinityType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.ModifiabilityViolationFaultType;
import org.gridforum.ogsi.MutabilityViolationFaultType;
import org.gridforum.ogsi.PartialFailureFaultType;
import org.gridforum.ogsi.ServiceDataType;
import org.gridforum.ogsi.ServiceNotDestroyedFaultType;
import org.gridforum.ogsi.StaticServiceDataValues;
import org.gridforum.ogsi.TargetInvalidFaultType;
import org.gridforum.ogsi.TerminationTimeType;
import org.gridforum.ogsi.TerminationTimeUnchangedFaultType;
import org.gridforum.ogsi.TypeViolationFaultType;
import org.gridforum.ogsi.WSDLReferenceType;
import org.w3c.dom.Document;

public class GridServiceImpl
extends ServicePropertiesImpl
implements GridServiceBase,
ServiceDataValueCallback {
    protected ServiceDataSet serviceData = new ServiceDataSetImpl();
    protected QueryEngine queryEngine = null;
    private boolean isDestroyed = false;
    private ServiceData terminationServiceDataElement;
    private HashMap operationProviders = new HashMap();
    private ArrayList operationProviderList = new ArrayList();
    private ServiceDataSweeperTask sweeper;
    private Class interfaceClass = null;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$ogsi$GridServiceImpl == null ? (class$org$globus$ogsa$impl$ogsi$GridServiceImpl = GridServiceImpl.class$("org.globus.ogsa.impl.ogsi.GridServiceImpl")) : class$org$globus$ogsa$impl$ogsi$GridServiceImpl).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$ogsi$GridServiceImpl;
    static /* synthetic */ Class class$org$gridforum$ogsi$ServiceNotDestroyedFaultType;

    public GridServiceImpl() {
        this("Base Grid Service");
    }

    public GridServiceImpl(String name) {
        this.setProperty("name", name);
        this.setProperty("serviceData", this.serviceData);
        this.setProperty("destructionSkeleton", this);
    }

    public Class getServiceInterface() {
        String interfaceClass = (String)this.getProperty("className");
        if (interfaceClass == null) {
            return this.getClass();
        }
        try {
            if (this.interfaceClass == null) {
                this.interfaceClass = (class$org$globus$ogsa$impl$ogsi$GridServiceImpl == null ? (class$org$globus$ogsa$impl$ogsi$GridServiceImpl = GridServiceImpl.class$("org.globus.ogsa.impl.ogsi.GridServiceImpl")) : class$org$globus$ogsa$impl$ogsi$GridServiceImpl).getClassLoader().loadClass(interfaceClass);
            }
            return this.interfaceClass;
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.getMessage("interfaceLoadError", new String[]{"" + interfaceClass}), (Throwable)e);
            return this.getClass();
        }
    }

    public OperationProvider getOperationProvider(QName operation) {
        return (OperationProvider)this.operationProviders.get(operation);
    }

    public void addOperationProvider(OperationProvider provider) throws GridServiceException {
        QName[] operations = provider.getOperations();
        int i = 0;
        while (i < operations.length) {
            this.operationProviders.put(operations[i], provider);
            ++i;
        }
        this.operationProviderList.add(provider);
        provider.initialize(this);
    }

    private void registerQueries() throws GridServiceException {
        this.queryEngine = QueryHelper.getQueryEngine((String)this.getProperty("queryEngine"));
        QueryHelper.registerEvaluators(this.queryEngine, (String)this.getProperty("queryEvaluators"));
    }

    private void registerOperationProviders() throws GridServiceException {
        String providers = (String)this.getProperty("operationProviders");
        if (providers == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(providers, " ");
        while (tokenizer.hasMoreElements()) {
            String provider = (String)tokenizer.nextElement();
            try {
                this.addOperationProvider((OperationProvider)(class$org$globus$ogsa$impl$ogsi$GridServiceImpl == null ? GridServiceImpl.class$("org.globus.ogsa.impl.ogsi.GridServiceImpl") : class$org$globus$ogsa$impl$ogsi$GridServiceImpl).getClassLoader().loadClass(provider).newInstance());
            }
            catch (Exception e) {
                throw new GridServiceException(e);
            }
        }
    }

    public Object getInstanceProperty(String key) {
        return this.getProperty("instance-" + key);
    }

    public void populateInstanceProperties(GridServiceBase properties) {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith("instance-")) continue;
            properties.setProperty(key.substring(9), this.getProperty(key));
        }
    }

    public void preCreate(GridServiceBase factory) throws GridServiceException {
        this.addServiceData();
        String date = (String)this.getPersistentProperty("timeout");
        if (date != null) {
            this.setDefaultTermination(new ExtendedDateTimeType(date));
        }
        this.registerOperationProviders();
        this.registerQueries();
        String sweep = (String)this.getProperty("sweepServiceData");
        if (sweep != null && sweep.equalsIgnoreCase("true")) {
            this.sweeper = new ServiceDataSweeperTask(this.serviceData);
            SweeperPool.getDefaultPool().addTask(this.sweeper);
        }
        this.callPreCreate(factory);
    }

    public void postCreate(GridContext context) throws GridServiceException {
        ServiceDataAnnotation.setupServiceData(this, this.serviceData);
        this.callPostCreate(context);
    }

    public void activate(GridContext context) throws GridServiceException {
        this.callActivate(context);
    }

    public void deactivate(GridContext context) throws GridServiceException {
        this.callDeactivate(context);
        FactoryProvider factory = (FactoryProvider)this.getProperty("factoryProvider");
        if (factory != null) {
            factory.deactivateInstance((String)this.getProperty("servicePath"));
        }
    }

    public void preDestroy(GridContext context) throws GridServiceException {
        this.callPreDestroy(context);
    }

    public ServiceDataSet getServiceDataSet() {
        return this.serviceData;
    }

    public void setServiceDataSet(ServiceDataSet serviceData) {
        this.serviceData = serviceData;
        this.setProperty("serviceData", serviceData);
    }

    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    public void setQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
        this.setProperty("queryEngine", queryEngine);
    }

    public Collection getServiceDataValues(QName qname) {
        try {
            if (QNameUtils.equalsLocally(qname, ServiceData.NAME)) {
                ArrayList<QName> list = new ArrayList<QName>();
                Iterator iterator = this.serviceData.iterator();
                while (iterator.hasNext()) {
                    ServiceData data = (ServiceData)iterator.next();
                    list.add(data.getName());
                }
                return list;
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
        }
        return new ArrayList();
    }

    public ExtensibilityType setServiceData(ExtensibilityType updateExpression) throws RemoteException, MutabilityViolationFaultType, ExtensibilityTypeFaultType, PartialFailureFaultType, CardinalityViolationFaultType, IncorrectValueFaultType, TypeViolationFaultType, FaultType, ExtensibilityNotSupportedFaultType, ModifiabilityViolationFaultType {
        return this.executeQuery(updateExpression);
    }

    public TerminationTimeType requestTerminationAfter(ExtendedDateTimeType terminationTime) throws RemoteException, TerminationTimeUnchangedFaultType, FaultType {
        return this.setDefaultTermination(terminationTime);
    }

    protected TerminationTimeType setDefaultTermination(ExtendedDateTimeType terminationTime) {
        if (!ExtendedDateTimeHelper.isInfinity(terminationTime)) {
            this.setTimeout(terminationTime.getDateTimeValue());
        }
        TerminationTimeType termination = new TerminationTimeType();
        termination.setAfter(terminationTime);
        termination.setBefore(terminationTime);
        termination.setTimestamp(Calendar.getInstance());
        this.terminationServiceDataElement.setValue(termination);
        this.terminationServiceDataElement.notifyChange();
        return termination;
    }

    public TerminationTimeType requestTerminationBefore(ExtendedDateTimeType terminationTime) throws RemoteException, TerminationTimeUnchangedFaultType, FaultType {
        return this.setDefaultTermination(terminationTime);
    }

    private ExtensibilityType executeQuery(ExtensibilityType expression) throws RemoteException {
        Object result = this.queryEngine.executeQuery(expression, this.serviceData);
        return AnyHelper.getServiceDataValues(result);
    }

    public ExtensibilityType findServiceData(ExtensibilityType queryExpression) throws RemoteException, FaultType, TargetInvalidFaultType, ExtensibilityNotSupportedFaultType, ExtensibilityTypeFaultType {
        return this.executeQuery(queryExpression);
    }

    public TerminationTimeType getTerminationTime() {
        TerminationTimeType result = new TerminationTimeType();
        result.setTimestamp(Calendar.getInstance());
        ExtendedDateTimeType terminationTime = new ExtendedDateTimeType();
        Calendar dateTime = this.getTimeout();
        if (dateTime == null) {
            terminationTime.setValue(InfinityType.infinity);
        } else {
            terminationTime.setValue(dateTime);
        }
        result.setBefore(terminationTime);
        result.setAfter(terminationTime);
        return result;
    }

    private void setTimeout(Calendar timeout) {
        try {
            if (timeout != null) {
                this.setProperty("timeout", timeout);
                this.setPersistentProperty("timeout", CalendarUtils.toString(timeout));
                this.flush();
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
        }
    }

    private Calendar getTimeout() {
        Object obj = this.getProperty("timeout");
        if (obj instanceof Calendar) {
            return (Calendar)obj;
        }
        if (obj != null) {
            Calendar cal = CalendarUtils.toCalendar((String)obj);
            this.setProperty("timeout", cal);
            return cal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws RemoteException, FaultType, ServiceNotDestroyedFaultType {
        GridServiceImpl gridServiceImpl = this;
        synchronized (gridServiceImpl) {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        if (this.sweeper != null) {
            this.sweeper.cancel();
        }
        String servicePath = (String)this.getProperty("servicePath");
        try {
            this.preDestroy(new GridContext((javax.xml.rpc.handler.MessageContext)MessageContext.getCurrentContext(), this));
        }
        catch (Exception e) {
            throw FaultHelper.makeFault(class$org$gridforum$ogsi$ServiceNotDestroyedFaultType == null ? (class$org$gridforum$ogsi$ServiceNotDestroyedFaultType = GridServiceImpl.class$("org.gridforum.ogsi.ServiceNotDestroyedFaultType")) : class$org$gridforum$ogsi$ServiceNotDestroyedFaultType, MessageUtils.getMessage("preDestroyError"), e);
        }
        logger.debug((Object)("Destroying service: " + servicePath));
        DestroyListener destroyListener = (DestroyListener)this.getProperty("destroyListener");
        try {
            if (destroyListener != null) {
                destroyListener.notifyDestroy(servicePath);
            }
        }
        catch (Exception e) {
            throw FaultHelper.makeFault(class$org$gridforum$ogsi$ServiceNotDestroyedFaultType == null ? (class$org$gridforum$ogsi$ServiceNotDestroyedFaultType = GridServiceImpl.class$("org.gridforum.ogsi.ServiceNotDestroyedFaultType")) : class$org$gridforum$ogsi$ServiceNotDestroyedFaultType, MessageUtils.getMessage("notifyDestroyError"), e);
        }
    }

    private void addServiceData() throws GridServiceException {
        GSRDescription gsrDesc = (GSRDescription)this.getProperty("GSRDescription");
        GSR gsr = gsrDesc.getGSR();
        Collection portTypes = gsr.getGWSDLPortTypes();
        ServiceData interfaceServiceDataElement = this.serviceData.create(ServiceData.INTERFACE);
        Iterator iterator = portTypes.iterator();
        while (iterator.hasNext()) {
            PortTypeExtensibilityElement element = (PortTypeExtensibilityElement)iterator.next();
            ServiceDataType[] serviceData = element.getServiceData();
            int i = 0;
            while (serviceData != null && i < serviceData.length) {
                ServiceData serviceDataElement = this.serviceData.create(new QName(element.getName().getNamespaceURI(), serviceData[i].getName().toString()));
                serviceDataElement.init(serviceData[i]);
                this.serviceData.add(serviceDataElement);
                ++i;
            }
            interfaceServiceDataElement.addValue(element.getName());
            StaticServiceDataValues serviceDataValues = element.getServiceDataValues();
            if (serviceDataValues == null) continue;
            MessageElement[] staticServiceData = serviceDataValues.get_any();
            int i2 = 0;
            while (i2 < staticServiceData.length) {
                ServiceData serviceDataWrapper = this.serviceData.get(staticServiceData[i2].getQName());
                if (serviceDataWrapper == null) {
                    logger.error((Object)MessageUtils.getMessage("sdeNotFound", new String[]{" " + staticServiceData[i2].getQName()}));
                } else {
                    serviceDataWrapper.addValue(staticServiceData[i2]);
                    serviceDataWrapper.setMutability(ServiceData.STATIC);
                    this.serviceData.add(serviceDataWrapper);
                }
                ++i2;
            }
        }
        this.serviceData.add(interfaceServiceDataElement);
        String handle = (String)this.getProperty("Handle");
        ServiceData handleServiceDataElement = this.serviceData.create(ServiceData.HANDLE);
        handleServiceDataElement.setValue(new HandleType(handle));
        this.serviceData.add(handleServiceDataElement);
        ServiceProperties factory = (ServiceProperties)this.getProperty("factory");
        if (factory != null) {
            LocatorType locator = new LocatorType();
            locator.setHandle(new HandleType[]{new HandleType((String)factory.getProperty("Handle"))});
            ServiceData factoryLocatorServiceDataElement = this.serviceData.create(ServiceData.FACTORY_LOCATOR);
            factoryLocatorServiceDataElement.setValue(locator);
            this.serviceData.add(factoryLocatorServiceDataElement);
        }
        Document reference = (Document)this.getProperty("WSDL");
        WSDLReferenceType wsdlReference = new WSDLReferenceType();
        wsdlReference.set_any(new MessageElement[]{new MessageElement(reference.getDocumentElement())});
        ServiceData referenceServiceDataElement = this.serviceData.create(ServiceData.REFERENCE);
        referenceServiceDataElement.setValue(wsdlReference);
        this.serviceData.add(referenceServiceDataElement);
        this.terminationServiceDataElement = this.serviceData.create(ServiceData.TERMINATION);
        this.terminationServiceDataElement.setValue(this.getTerminationTime());
        this.serviceData.add(this.terminationServiceDataElement);
        ServiceData serviceDataNameServiceDataElement = this.serviceData.create(ServiceData.NAME);
        serviceDataNameServiceDataElement.setCallback(this);
        this.serviceData.add(serviceDataNameServiceDataElement);
    }

    private void callPreCreate(GridServiceBase base) throws GridServiceException {
        Iterator iterator = this.operationProviderList.iterator();
        while (iterator.hasNext()) {
            Object operationProvider = iterator.next();
            if (!(operationProvider instanceof GridServiceCallback)) continue;
            ((GridServiceCallback)operationProvider).preCreate(base);
        }
    }

    private void callPostCreate(GridContext context) throws GridServiceException {
        Iterator iterator = this.operationProviderList.iterator();
        while (iterator.hasNext()) {
            Object operationProvider = iterator.next();
            if (!(operationProvider instanceof GridServiceCallback)) continue;
            ((GridServiceCallback)operationProvider).postCreate(context);
        }
    }

    private void callActivate(GridContext context) throws GridServiceException {
        Iterator iterator = this.operationProviderList.iterator();
        while (iterator.hasNext()) {
            Object operationProvider = iterator.next();
            if (!(operationProvider instanceof GridServiceCallback)) continue;
            ((GridServiceCallback)operationProvider).activate(context);
        }
    }

    private void callDeactivate(GridContext context) throws GridServiceException {
        Iterator iterator = this.operationProviderList.iterator();
        while (iterator.hasNext()) {
            Object operationProvider = iterator.next();
            if (!(operationProvider instanceof GridServiceCallback)) continue;
            ((GridServiceCallback)operationProvider).deactivate(context);
        }
    }

    private void callPreDestroy(GridContext context) throws GridServiceException {
        Iterator iterator = this.operationProviderList.iterator();
        while (iterator.hasNext()) {
            Object operationProvider = iterator.next();
            if (!(operationProvider instanceof GridServiceCallback)) continue;
            ((GridServiceCallback)operationProvider).preDestroy(context);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

