/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.ogsi;

import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.NotificationProvider;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.core.notification.NotificationSubscriptionData;
import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.repository.ServiceActivationException;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.utils.QNameUtils;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.SubscribeByNameType;

public class NotificationSubscriptionImpl
extends GridServiceImpl {
    private boolean persistent = false;
    private NotificationSubscriptionData input;
    private NotificationProvider provider;
    private String[] subscriptionID = null;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$ogsi$NotificationSubscriptionImpl == null ? (class$org$globus$ogsa$impl$ogsi$NotificationSubscriptionImpl = NotificationSubscriptionImpl.class$("org.globus.ogsa.impl.ogsi.NotificationSubscriptionImpl")) : class$org$globus$ogsa$impl$ogsi$NotificationSubscriptionImpl).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$ogsi$NotificationSubscriptionImpl;

    public NotificationSubscriptionImpl() {
        super("Notification Subscription Service");
        this.input = (NotificationSubscriptionData)MessageContext.getCurrentContext().getProperty("or.globus.ogsa.startupState");
    }

    public NotificationSubscriptionImpl(NotificationSubscriptionData input) {
        super("Notification Subscription Service");
        this.input = input;
    }

    public void postCreate(GridContext context) throws GridServiceException {
        super.postCreate(context);
        try {
            this.initState();
            ServiceData subscriptionExpressionData = this.serviceData.create(ServiceData.SUBSCRIPTION_EXPRESSION);
            SubscribeByNameType nameExpression = new SubscribeByNameType();
            nameExpression.setName(this.input.getServiceDataNames());
            subscriptionExpressionData.setValue(nameExpression);
            this.serviceData.add(subscriptionExpressionData);
            ServiceData sinkLocatorData = this.serviceData.create(ServiceData.SINK_LOCATOR);
            LocatorType serviceLocator = new LocatorType();
            serviceLocator.setHandle(new HandleType[]{this.input.getSink()});
            sinkLocatorData.setValue(serviceLocator);
            this.serviceData.add(sinkLocatorData);
            String subscriptionIDBase = (String)this.getProperty("servicePath");
            QName[] serviceDataName = this.input.getServiceDataNames();
            this.subscriptionID = new String[serviceDataName.length];
            int i = 0;
            while (i < serviceDataName.length) {
                this.subscriptionID[i] = subscriptionIDBase + "-" + serviceDataName[i];
                this.provider.addSubscription(serviceDataName[i], this.input.getSink(), this.subscriptionID[i]);
                ++i;
            }
            this.checkPointState();
        }
        catch (GridServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public void preDestroy(GridContext context) throws GridServiceException {
        super.preDestroy(context);
        if (this.provider != null) {
            try {
                int i = 0;
                while (i < this.subscriptionID.length) {
                    this.provider.removeSubscription(this.subscriptionID[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new GridServiceException(e);
            }
        }
    }

    private void initState() throws ServiceActivationException {
        String lifecycle = (String)this.getProperty("lifecycle");
        if (lifecycle.equalsIgnoreCase("persistent")) {
            this.persistent = true;
            if (this.input == null) {
                QName[] qname = QNameUtils.toQNames((String)this.getPersistentProperty("SDENames"));
                String handle = (String)this.getPersistentProperty("sink");
                String source = (String)this.getPersistentProperty("source");
                this.input = new NotificationSubscriptionData(qname, new HandleType(handle), source);
            }
        }
        this.setProperty("deactivatedState", this.input);
        ServiceProperties properties = (ServiceProperties)ServiceNode.getRootNode().activate(this.input.getSource());
        this.provider = (NotificationProvider)properties.getProperty("notificationSource");
    }

    private void checkPointState() {
        if (!this.persistent) {
            return;
        }
        this.setPersistentProperty("SDENames", QNameUtils.toString(this.input.getServiceDataNames()));
        this.setPersistentProperty("sink", this.input.getSink().toString());
        this.setPersistentProperty("source", this.input.getSource());
        this.setPersistentProperty("activateOnStartup", "true");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

