/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.security.SecurityException;
import org.globus.ogsa.impl.security.authentication.SecureServicePropertiesHelper;
import org.globus.ogsa.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.ogsa.impl.security.descriptor.SecurityConfig;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class SecurityManager {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$SecurityManager == null ? (class$org$globus$ogsa$impl$security$SecurityManager = SecurityManager.class$("org.globus.ogsa.impl.security.SecurityManager")) : class$org$globus$ogsa$impl$security$SecurityManager).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.resource", (ClassLoader)(class$org$globus$ogsa$impl$security$SecurityManager == null ? (class$org$globus$ogsa$impl$security$SecurityManager = SecurityManager.class$("org.globus.ogsa.impl.security.SecurityManager")) : class$org$globus$ogsa$impl$security$SecurityManager).getClassLoader());
    private static SecurityManager manager;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$SecurityManager;
    static /* synthetic */ Class class$org$globus$gsi$jaas$GlobusPrincipal;

    public static synchronized SecurityManager getManager() {
        if (manager == null) {
            manager = new SecurityManager();
        }
        return manager;
    }

    public Subject getSystemSubject() {
        try {
            return ContainerSecurityConfig.getConfig().getSubject();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get system subject", (Throwable)e);
            return null;
        }
    }

    public Subject getServiceSubject(ServiceProperties props) {
        try {
            SecurityConfig.refresh(props);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to refresh service subject", (Throwable)e);
        }
        return SecureServicePropertiesHelper.getSubject(props);
    }

    public Subject getSubject(ServiceProperties props) {
        Subject subject = this.getServiceSubject(props);
        return subject == null ? this.getSystemSubject() : subject;
    }

    public String getCaller() {
        Principal p = this.getCallerPrincipal();
        return p == null ? null : p.getName();
    }

    public Principal getCallerPrincipal() {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return null;
        }
        Subject caller = (Subject)ctx.getProperty("callerSubject");
        if (caller == null) {
            return null;
        }
        Set<Principal> principals = caller.getPrincipals();
        if (principals == null || principals.isEmpty()) {
            return null;
        }
        return principals.iterator().next();
    }

    public Subject setServiceOwnerFromContext(ServiceProperties props) throws SecurityException {
        Subject subject = JaasSubject.getCurrentSubject();
        if (subject == null) {
            throw new SecurityException(i18n.getMessage("noSubject"));
        }
        Set<Object> creds = subject.getPrivateCredentials();
        if (creds == null || creds.isEmpty()) {
            throw new SecurityException(i18n.getMessage("noPrivateCred"));
        }
        subject.setReadOnly();
        SecureServicePropertiesHelper.setSubject(props, subject);
        Set principals = subject.getPrincipals(class$org$globus$gsi$jaas$GlobusPrincipal == null ? (class$org$globus$gsi$jaas$GlobusPrincipal = SecurityManager.class$("org.globus.gsi.jaas.GlobusPrincipal")) : class$org$globus$gsi$jaas$GlobusPrincipal);
        if (principals != null && !principals.isEmpty()) {
            Iterator iter = principals.iterator();
            while (iter.hasNext()) {
                Principal principal = (Principal)iter.next();
                this.addAuthorizedUser(props, principal.getName());
            }
        }
        return subject;
    }

    public Subject setServiceOwnerFromContext(ServiceProperties props, GridContext context) throws SecurityException {
        return this.setServiceOwnerFromContext(props);
    }

    public void addAuthorizedUser(ServiceProperties props, GSSCredential cred) throws SecurityException {
        if (cred == null) {
            throw new IllegalArgumentException("cred == null");
        }
        String id = null;
        try {
            id = cred.getName().toString();
        }
        catch (GSSException e) {
            throw new SecurityException(e);
        }
        this.addAuthorizedUser(props, id);
    }

    public void addAuthorizedUser(ServiceProperties props, String userId) throws SecurityException {
        if (userId == null) {
            throw new IllegalArgumentException("userId == null");
        }
        GridMap gridMap = SecureServicePropertiesHelper.getGridMap(props);
        if (gridMap == null) {
            gridMap = new GridMap();
            SecureServicePropertiesHelper.setGridMap(props, gridMap);
        }
        logger.debug((Object)("Setting service owner : " + userId));
        gridMap.map(userId, System.getProperty("user.name"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

