/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.security.authentication.CredentialRefreshListener;
import org.globus.ogsa.impl.security.authentication.DescriptorHandler;
import org.globus.ogsa.impl.security.authentication.SecContext;
import org.globus.ogsa.impl.security.authentication.SecureServicePropertiesHelper;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class CredentialRefreshHandler
extends BasicHandler {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$CredentialRefreshHandler == null ? (class$org$globus$ogsa$impl$security$authentication$CredentialRefreshHandler = CredentialRefreshHandler.class$("org.globus.ogsa.impl.security.authentication.CredentialRefreshHandler")) : class$org$globus$ogsa$impl$security$authentication$CredentialRefreshHandler).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$CredentialRefreshHandler;

    public void invoke(MessageContext messageContext) throws AxisFault {
        SecContext ctx = (SecContext)messageContext.getProperty("org.globus.security.context");
        if (ctx == null) {
            return;
        }
        ServiceProperties props = DescriptorHandler.getService(messageContext);
        if (props == null || !(props instanceof CredentialRefreshListener)) {
            return;
        }
        logger.debug((Object)"Attempting credential refresh");
        try {
            this.refreshCredential(props, ctx.getContext().getDelegCred(), (CredentialRefreshListener)((Object)props));
        }
        catch (GSSException e) {
            logger.error((Object)"Error during credential refresh", (Throwable)e);
        }
    }

    private void refreshCredential(ServiceProperties props, GSSCredential newCredential, CredentialRefreshListener credRefreshListener) throws GSSException {
        if (props == null || newCredential == null) {
            return;
        }
        GSSCredential ownerCred = SecureServicePropertiesHelper.getCredential(props);
        if (ownerCred == null) {
            return;
        }
        if (!ownerCred.getName().equals(newCredential.getName())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Service credential not updated: identities do not match. Service cred identity: '" + ownerCred + "' new cred identity: '" + newCredential + "'"));
            }
            return;
        }
        if (newCredential.getRemainingLifetime() > ownerCred.getRemainingLifetime()) {
            SecureServicePropertiesHelper.setCredential(props, newCredential);
            logger.debug((Object)"Service credential refreshed.");
            if (credRefreshListener != null) {
                credRefreshListener.refreshCredentials(newCredential);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

