/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import javax.security.auth.Subject;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.security.authentication.ContextManager;
import org.globus.ogsa.impl.security.descriptor.SecurityDescriptor;
import org.globus.security.gridmap.GridMap;
import org.ietf.jgss.GSSCredential;

public class SecureServicePropertiesHelper {
    public static final String CONTEXT_MANAGER = "org.globus.sec.context.manager";
    public static final String GRIDMAP = "org.globus.sec.gridmap";
    public static final String CREDENTIAL = "org.globus.sec.credential";
    public static final String GRIM_HANDLER = "org.globus.sec.grim.handler";
    public static final String DESCRIPTOR = "org.globus.sec.descriptor";
    public static final String SUBJECT = "org.globus.sec.subject";

    public static ContextManager getContextManager(ServiceProperties props) {
        return (ContextManager)props.getProperty(CONTEXT_MANAGER);
    }

    public static void setContextManager(ServiceProperties props, ContextManager manager) {
        props.setProperty(CONTEXT_MANAGER, manager);
    }

    public static void setGridMap(ServiceProperties props, GridMap map) {
        props.setProperty(GRIDMAP, map);
    }

    public static GridMap getGridMap(ServiceProperties props) {
        return (GridMap)props.getProperty(GRIDMAP);
    }

    public static void setCredential(ServiceProperties props, GSSCredential cred) {
        try {
            SecureServicePropertiesHelper.setSubject(props, JaasGssUtil.createSubject((GSSCredential)cred));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static GSSCredential getCredential(ServiceProperties props) {
        return JaasGssUtil.getCredential((Subject)SecureServicePropertiesHelper.getSubject(props));
    }

    public static void setGrimProxyPolicyHandler(ServiceProperties props, ProxyPolicyHandler handler) {
        props.setProperty(GRIM_HANDLER, handler);
    }

    public static ProxyPolicyHandler getGrimProxyPolicyHandler(ServiceProperties props) {
        return (ProxyPolicyHandler)props.getProperty(GRIM_HANDLER);
    }

    public static void setSecurityDescriptor(ServiceProperties props, SecurityDescriptor descriptor) {
        props.setProperty(DESCRIPTOR, descriptor);
    }

    public static SecurityDescriptor getSecurityDescriptor(ServiceProperties props) {
        return (SecurityDescriptor)props.getProperty(DESCRIPTOR);
    }

    public static void setSubject(ServiceProperties props, Subject subject) {
        props.setProperty(SUBJECT, subject);
    }

    public static Subject getSubject(ServiceProperties props) {
        return (Subject)props.getProperty(SUBJECT);
    }
}

