/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.ogsa.impl.security.authentication.X509WSSignedSOAPEnvelopeBuilder;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityFault;
import org.ietf.jgss.GSSCredential;

public class X509SignHandler
extends GenericHandler {
    private static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$X509SignHandler == null ? (class$org$globus$ogsa$impl$security$authentication$X509SignHandler = X509SignHandler.class$("org.globus.ogsa.impl.security.authentication.X509SignHandler")) : class$org$globus$ogsa$impl$security$authentication$X509SignHandler).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$X509SignHandler;

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context, JaasSubject.getCurrentSubject());
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context, (Subject)context.getProperty("invocationSubject"));
    }

    public boolean handleMessage(SOAPMessageContext ctx, Subject subject) {
        Object tmp = ctx.getProperty("org.globus.ogsa.security.sign.msg");
        if (!Boolean.TRUE.equals(tmp)) {
            log.debug((Object)"Signature not requested.");
            return true;
        }
        log.debug((Object)"Enter: sign");
        SOAPMessage msg = ctx.getMessage();
        SOAPMessage signedMsg = null;
        try {
            SOAPEnvelope unsignedEnvelope = msg.getSOAPPart().getEnvelope();
            GSSCredential cred = null;
            if (subject != null) {
                log.debug((Object)"Getting credentials from subject");
                cred = JaasGssUtil.getCredential((Subject)subject);
            }
            if (cred == null) {
                log.debug((Object)"Getting credentials from property");
                cred = (GSSCredential)ctx.getProperty("org.globus.gsi.credentials");
            }
            X509WSSignedSOAPEnvelopeBuilder builder = new X509WSSignedSOAPEnvelopeBuilder((MessageContext)ctx, cred);
            builder.setActor((String)ctx.getProperty("x509Actor"));
            signedMsg = builder.buildMessage(unsignedEnvelope);
        }
        catch (Exception e) {
            log.error((Object)"Failed to sign message", (Throwable)e);
            throw WSSecurityFault.makeFault(e);
        }
        ctx.setMessage(signedMsg);
        log.debug((Object)"Exit: sign");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

