/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication.service;

import java.rmi.RemoteException;
import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.ogsa.impl.security.SecurityManager;
import org.globus.ogsa.impl.security.authentication.ContextManager;
import org.globus.ogsa.impl.security.authentication.SecContext;
import org.globus.ogsa.impl.security.authentication.SecureServicePropertiesHelper;
import org.globus.ogsa.impl.security.authentication.service.AuthenticationServiceConstants;
import org.globus.ogsa.impl.security.descriptor.SecurityConfig;
import org.globus.ogsa.impl.security.util.UUID;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.security.authentication.ContextTokenOutType;
import org.globus.ogsa.security.authentication.ContextTokenType;
import org.globus.ogsa.security.authentication.InitContextTokenType;
import org.globus.ogsa.security.authentication.InvalidContextIdFault;
import org.globus.ogsa.security.authentication.MechanismTypeNotSupportedFault;
import org.globus.ogsa.security.authentication.SecureContextEstablishmentPortType;
import org.globus.ogsa.utils.ChainedRemoteException;
import org.globus.ogsa.utils.MessageUtils;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.gridforum.ogsi.NoSuchServiceFaultType;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class AuthenticationServiceImpl
extends PersistentGridServiceImpl
implements SecureContextEstablishmentPortType,
AuthenticationServiceConstants {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$service$AuthenticationServiceImpl == null ? (class$org$globus$ogsa$impl$security$authentication$service$AuthenticationServiceImpl = AuthenticationServiceImpl.class$("org.globus.ogsa.impl.security.authentication.service.AuthenticationServiceImpl")) : class$org$globus$ogsa$impl$security$authentication$service$AuthenticationServiceImpl).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$service$AuthenticationServiceImpl;

    public AuthenticationServiceImpl() {
        super("Authentication Service");
    }

    protected GSSManager getGSSManager(String mechanismType) throws MechanismTypeNotSupportedFault {
        if (mechanismType == null) {
            throw new MechanismTypeNotSupportedFault();
        }
        if (mechanismType.equalsIgnoreCase("http://www.globus.org/2002/04/xmlenc#gssapi-gsi")) {
            return ExtendedGSSManager.getInstance();
        }
        throw new MechanismTypeNotSupportedFault();
    }

    protected ServiceProperties getTargetService(boolean activate) throws RemoteException {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            throw new RemoteException("No MessageContext");
        }
        String url = (String)ctx.getProperty("targetService");
        if (url == null) {
            throw new RemoteException("No target service set");
        }
        ServiceNode root = ServiceNode.getRootNode();
        ServiceProperties service = null;
        if (activate) {
            service = (ServiceProperties)root.activate(url);
            try {
                SecurityConfig.initialize(service);
            }
            catch (Exception e) {
                throw new ChainedRemoteException(e);
            }
        } else {
            service = (ServiceProperties)root.resolve(url);
        }
        return service;
    }

    protected GSSCredential getCredential(ServiceProperties props) {
        Subject s = SecurityManager.getManager().getSubject(props);
        return JaasGssUtil.getCredential((Subject)s);
    }

    protected ProxyPolicyHandler getGrimProxyPolicyHandler(ServiceProperties props) {
        return SecureServicePropertiesHelper.getGrimProxyPolicyHandler(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContextManager getContextManager(ServiceProperties props) {
        ServiceProperties serviceProperties = props;
        synchronized (serviceProperties) {
            ContextManager manager = SecureServicePropertiesHelper.getContextManager(props);
            if (manager == null) {
                manager = new ContextManager();
                SecureServicePropertiesHelper.setContextManager(props, manager);
            }
            return manager;
        }
    }

    public ContextTokenOutType initTokenExchange(InitContextTokenType token) throws RemoteException, MechanismTypeNotSupportedFault {
        logger.debug((Object)"Enter initContext");
        ServiceProperties targetService = this.getTargetService(true);
        if (targetService == null) {
            throw new NoSuchServiceFaultType();
        }
        GSSManager manager = this.getGSSManager(token.getMechanismType());
        GSSContext context = null;
        try {
            context = manager.createContext(this.getCredential(targetService));
        }
        catch (GSSException e) {
            throw new RemoteException(MessageUtils.toString(e));
        }
        ProxyPolicyHandler grimPolicyHandler = this.getGrimProxyPolicyHandler(targetService);
        if (grimPolicyHandler != null && context instanceof ExtendedGSSContext) {
            try {
                ((ExtendedGSSContext)context).setOption(GSSConstants.GRIM_POLICY_HANDLER, (Object)grimPolicyHandler);
            }
            catch (GSSException e) {
                throw new RemoteException(MessageUtils.toString(e));
            }
        }
        UUID id = null;
        String contextId = token.getContextId();
        if (contextId == null) {
            id = new UUID(System.currentTimeMillis(), context.hashCode());
        } else {
            id = new UUID(contextId);
            id.setLeastSignificant(context.hashCode());
        }
        contextId = id.toString();
        logger.debug((Object)("init context: " + contextId));
        token.setContextId(contextId);
        SecContext secContext = new SecContext(context, contextId);
        this.getContextManager(targetService).put(secContext);
        return this.continueTokenExchange(token);
    }

    public ContextTokenOutType continueTokenExchange(ContextTokenType token) throws RemoteException, InvalidContextIdFault {
        logger.debug((Object)"Enter establishContext");
        ServiceProperties targetService = this.getTargetService(false);
        if (targetService == null) {
            throw new NoSuchServiceFaultType();
        }
        String contextId = token.getContextId();
        ContextManager manager = SecureServicePropertiesHelper.getContextManager(targetService);
        SecContext secContext = manager.get(contextId);
        if (secContext == null) {
            throw new InvalidContextIdFault(MessageUtils.getMessage("invalidContextId"));
        }
        GSSContext context = secContext.getContext();
        byte[] inToken = token.getBase64Token();
        byte[] outToken = null;
        try {
            outToken = context.acceptSecContext(inToken, 0, inToken.length);
        }
        catch (GSSException e) {
            throw new RemoteException(MessageUtils.toString(e));
        }
        ContextTokenOutType response = new ContextTokenOutType();
        response.setContinueNeeded(!context.isEstablished());
        response.setBase64Token(outToken);
        response.setContextId(contextId);
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

