/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication.wssec;

import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.impl.security.Constants;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityBasicHandler;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityException;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityFault;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityResponseEngine;
import org.globus.ogsa.impl.security.authorization.Authorization;
import org.globus.ogsa.impl.security.authorization.AuthorizationException;
import org.globus.ogsa.impl.security.authorization.HostAuthorization;

public class WSSecurityClientHandler
extends WSSecurityBasicHandler {
    private static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityClientHandler == null ? (class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityClientHandler = WSSecurityClientHandler.class$("org.globus.ogsa.impl.security.authentication.wssec.WSSecurityClientHandler")) : class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityClientHandler).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityClientHandler;

    public boolean handleRequest(MessageContext context) {
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        Object gssSec;
        Object xmlSig = context.getProperty("org.globus.ogsa.security.sign.msg");
        if (xmlSig != null) {
            context.setProperty("org.globus.ogsa.security.sign.msg", (Object)Boolean.FALSE);
        }
        if ((gssSec = context.getProperty("org.globus.security.msg.type")) != null) {
            context.setProperty("org.globus.security.msg.type", (Object)Constants.NONE);
        }
        SOAPMessageContext ctx = (SOAPMessageContext)context;
        boolean v = this.handleMessage(ctx, WSSecurityResponseEngine.getEngine());
        SOAPMessage msg = ctx.getMessage();
        SOAPBody body = null;
        try {
            SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
            body = env.getBody();
        }
        catch (SOAPException e) {
            log.error((Object)"Failed to get envelope", (Throwable)e);
            return false;
        }
        if (!body.hasFault()) {
            try {
                this.checkGSIXMLSignature(xmlSig, context.getProperty("org.globus.ogsa.security.sign.msg"), context);
                this.checkGSISecConv(gssSec, context.getProperty("org.globus.security.msg.type"));
            }
            catch (Exception e) {
                log.error((Object)"Client security checks failed", (Throwable)e);
                throw WSSecurityFault.makeFault(e);
            }
        }
        return v;
    }

    private void checkGSIXMLSignature(Object before, Object after, MessageContext context) throws WSSecurityException, AuthorizationException {
        if (before != null && before.equals(Boolean.TRUE)) {
            if (!before.equals(after)) {
                throw new WSSecurityException(0, "gsiXmlSigError");
            }
            Subject peer = (Subject)context.getProperty("callerSubject");
            Authorization author = (Authorization)context.getProperty("org.globus.ogsa.security.authorization");
            if (author == null) {
                author = HostAuthorization.getInstance();
            }
            author.authorize(peer, context);
        }
    }

    private void checkGSISecConv(Object before, Object after) throws WSSecurityException {
        if (before != null && (before.equals(Constants.SIGNATURE) || before.equals(Constants.ENCRYPTION)) && !before.equals(after)) {
            throw new WSSecurityException(0, "gsiSecConvError");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

