/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication.wssec;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.DataReference;
import org.apache.xml.security.encryption.ReferenceList;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.IdResolver;
import org.globus.gsi.CertUtil;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.ogsa.impl.security.authentication.GSSEncryptedData;
import org.globus.ogsa.impl.security.authentication.GssXMLSignature;
import org.globus.ogsa.impl.security.authentication.SOAPBodyIdResolver;
import org.globus.ogsa.impl.security.authentication.wssec.BinarySecurityToken;
import org.globus.ogsa.impl.security.authentication.wssec.BinarySecurityTokenFactory;
import org.globus.ogsa.impl.security.authentication.wssec.PKIPathSecurityToken;
import org.globus.ogsa.impl.security.authentication.wssec.Reference;
import org.globus.ogsa.impl.security.authentication.wssec.SecurityTokenReference;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityException;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityIdResolver;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityUtil;
import org.globus.ogsa.impl.security.util.EnvelopeConverter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class WSSecurityEngine {
    private static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityEngine == null ? (class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityEngine = WSSecurityEngine.class$("org.globus.ogsa.impl.security.authentication.wssec.WSSecurityEngine")) : class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityEngine).getName());
    public static final String SIG_LN = "Signature";
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityEngine;

    public boolean handleSignatureElement(Element element, MessageContext msgCtx) throws Exception {
        WSSecurityEngine.normalize(element);
        element.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xenc");
        GssXMLSignature sig = new GssXMLSignature(element, null);
        sig.addResourceResolver(SOAPBodyIdResolver.getInstance());
        SignedInfo info = sig.getSignedInfo();
        if (info.getSignatureMethodURI().equalsIgnoreCase("http://www.globus.org/2002/04/xmlenc#gssapi-sign")) {
            log.info((Object)"Found GSS XML signature");
            return this.verifyGssXMLSignature(sig, msgCtx);
        }
        log.info((Object)"Found XML signature");
        return this.verifyXMLSignature(sig, msgCtx);
    }

    public abstract boolean verifyGssXMLSignature(GssXMLSignature var1, MessageContext var2) throws Exception;

    protected X509Certificate[] getCertificatesX509Data(KeyInfo info) throws Exception {
        int len = info.lengthX509Data();
        if (len != 1) {
            throw new WSSecurityException(0, "invalidX509Data", new Object[]{new Integer(len)});
        }
        X509Data data = info.itemX509Data(0);
        int certLen = data.lengthCertificate();
        if (certLen <= 0) {
            throw new WSSecurityException(0, "invalidCertData", new Object[]{new Integer(certLen)});
        }
        X509Certificate[] certs = new X509Certificate[certLen];
        int i = 0;
        while (i < certLen) {
            XMLX509Certificate xmlCert = data.itemCertificate(i);
            ByteArrayInputStream input = new ByteArrayInputStream(xmlCert.getCertificateBytes());
            certs[i] = CertUtil.loadCertificate((InputStream)input);
            ++i;
        }
        return certs;
    }

    protected X509Certificate[] getCertificatesTokenReference(Element elem) throws Exception {
        SecurityTokenReference secRef = new SecurityTokenReference(elem);
        Reference ref = secRef.getReference();
        if (ref == null) {
            throw new WSSecurityException(3, "noReference");
        }
        String uri = ref.getURI();
        log.debug((Object)("Token reference uri: " + uri));
        if (uri == null) {
            throw new WSSecurityException(3, "badReferenceURI");
        }
        WSSecurityIdResolver resolver = WSSecurityIdResolver.getInstance();
        Element tokElement = resolver.getElementById(elem.getOwnerDocument(), uri);
        if (tokElement == null) {
            throw new WSSecurityException(7, "noToken", new Object[]{uri});
        }
        BinarySecurityTokenFactory tokenFactory = BinarySecurityTokenFactory.getInstance();
        BinarySecurityToken token = tokenFactory.createSecurityToken(tokElement);
        if (token instanceof PKIPathSecurityToken) {
            return ((PKIPathSecurityToken)token).getX509Certificates(true);
        }
        throw new WSSecurityException(1, "unhandledToken", new Object[]{token.getClass().getName()});
    }

    protected abstract ProxyPolicyHandler getGrimProxyHandler(XMLSignature var1, MessageContext var2) throws Exception;

    public boolean verifyXMLSignature(XMLSignature sig, MessageContext msgCtx) throws Exception {
        log.debug((Object)"Verify XML Signature");
        X509Certificate[] certs = null;
        KeyInfo info = sig.getKeyInfo();
        if (info.containsX509Data()) {
            certs = this.getCertificatesX509Data(info);
        } else {
            Node node = WSSecurityUtil.getDirectChild(info.getElement(), SecurityTokenReference.TOKEN.getLocalPart(), SecurityTokenReference.TOKEN.getNamespaceURI());
            if (node == null) {
                throw new WSSecurityException(3, "unsupportedKeyInfo", null);
            }
            certs = this.getCertificatesTokenReference((Element)node);
        }
        if (!sig.checkSignatureValue(certs[0])) {
            throw new WSSecurityException(6);
        }
        X509Certificate[] trustedCerts = null;
        TrustedCertificates crts = TrustedCertificates.getDefaultTrustedCertificates();
        if (crts != null) {
            trustedCerts = crts.getCertificates();
        }
        ProxyPathValidator validator = new ProxyPathValidator();
        ProxyPolicyHandler grimPolicyHandler = this.getGrimProxyHandler(sig, msgCtx);
        if (grimPolicyHandler != null) {
            log.debug((Object)"Grim policy handler set");
            validator.setProxyPolicyHandler("1.3.6.1.4.1.3536.1.1.1.7", grimPolicyHandler);
        }
        validator.validate(certs, trustedCerts);
        String identity = validator.getIdentity();
        msgCtx.setProperty("org.globus.ogsa.security.sign.msg", (Object)Boolean.TRUE);
        Subject subject = this.getSubject(msgCtx);
        subject.getPublicCredentials().add(certs);
        subject.getPrincipals().add((Principal)new GlobusPrincipal(identity));
        return false;
    }

    protected Subject getSubject(MessageContext msgCtx) {
        Subject subject = (Subject)msgCtx.getProperty("callerSubject");
        if (subject == null) {
            subject = new Subject();
            msgCtx.setProperty("callerSubject", (Object)subject);
        }
        return subject;
    }

    public boolean handleEncryptionElement(Element element, MessageContext msgCtx) throws Exception {
        ReferenceList ref = new ReferenceList(element, null);
        int len = ref.getLengthDataReference();
        if (len != 1) {
            throw new WSSecurityException(0, "invalidDataRef", new Object[]{new Integer(len)});
        }
        DataReference data = ref.itemDataReference(0);
        log.debug((Object)("Looking for : " + data.getURI()));
        Element encryptedDataElem = IdResolver.getElementById((Document)element.getOwnerDocument(), (String)data.getURI());
        if (encryptedDataElem == null) {
            throw new WSSecurityException(0, "noEncryptedData", new Object[]{data.getURI()});
        }
        GSSEncryptedData encData = new GSSEncryptedData(encryptedDataElem, null);
        return this.decryptGssXMLEncryption(encData, msgCtx);
    }

    public abstract boolean decryptGssXMLEncryption(GSSEncryptedData var1, MessageContext var2) throws Exception;

    public Document processSecurityHeader(SOAPEnvelope env, MessageContext msgCtx) throws Exception {
        return this.processSecurityHeader(env, (String)msgCtx.getProperty("actor"), msgCtx);
    }

    public Document processSecurityHeader(SOAPEnvelope env, String actor, MessageContext msgCtx) throws Exception {
        SOAPHeaderElement he;
        if (actor == null) {
            actor = "";
        }
        if ((he = WSSecurityUtil.getSecurityHeader(env, actor)) == null) {
            return null;
        }
        log.info((Object)"Found WS-Security header(s)");
        Document doc = EnvelopeConverter.getInstance().toDocument(env);
        NodeList list = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2002/04/secext", "Security");
        int len = list.getLength();
        int i = 0;
        while (i < len) {
            Element elem = (Element)list.item(i);
            Attr attr = elem.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor");
            String headerActor = attr.getValue();
            if (headerActor == null || headerActor.length() == 0 || headerActor.equalsIgnoreCase(actor) || headerActor.equals("http://schemas.xmlsoap.org/soap/actor/next")) {
                this.processSecurityHeader(elem, msgCtx, headerActor);
            }
            ++i;
        }
        return doc;
    }

    public void processSecurityHeader(Element securityHeader, MessageContext msgCtx, String actor) throws Exception {
        boolean route;
        log.info((Object)("Processing WS-Security header for '" + actor + "' actor."));
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        int i = 0;
        while (i < len) {
            Node elem = list.item(i);
            if ("http://www.w3.org/2000/09/xmldsig#".equalsIgnoreCase(elem.getNamespaceURI()) && SIG_LN.equalsIgnoreCase(elem.getLocalName())) {
                log.info((Object)"Found signature element");
                this.handleSignatureElement((Element)elem, msgCtx);
            } else if ("http://www.w3.org/2001/04/xmlenc#".equalsIgnoreCase(elem.getNamespaceURI())) {
                log.info((Object)"Found encryption element");
                this.handleEncryptionElement((Element)elem, msgCtx);
            } else {
                log.debug((Object)(elem.getLocalName() + " " + elem.getNamespaceURI()));
            }
            ++i;
        }
        boolean bl = route = "".equals(actor) && Boolean.TRUE.equals(msgCtx.getProperty("org.globus.ogsa.router"));
        if (!route) {
            securityHeader.getParentNode().removeChild(securityHeader);
        } else {
            log.debug((Object)"Header not removed");
        }
    }

    public static void normalize(Node node) {
        String data;
        if (node.getNodeType() == 3 && (data = ((Text)node).getData()).length() > 1 && data.charAt(0) == '\n' && (data.charAt(1) == '\n' || data.charAt(1) == ' ')) {
            ((Text)node).setData("\n");
        }
        Node currentChild = node.getFirstChild();
        while (currentChild != null) {
            WSSecurityEngine.normalize(currentChild);
            currentChild = currentChild.getNextSibling();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
    }
}

