/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication.wssec;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import org.globus.gsi.CertUtil;
import org.globus.ogsa.impl.security.authentication.wssec.BinarySecurityToken;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509SecurityToken
extends BinarySecurityToken {
    public static final QName TYPE = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "X509v3");

    public X509SecurityToken(Element elem) throws WSSecurityException {
        super(elem);
        if (!this.getValueType().equals(TYPE)) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{TYPE, this.getValueType()});
        }
    }

    public X509SecurityToken(Document doc) {
        super(doc);
        this.setValueType(TYPE);
    }

    public X509Certificate getX509Certificate() throws GeneralSecurityException {
        byte[] data = this.getToken();
        if (data == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        return CertUtil.loadCertificate((InputStream)in);
    }

    public void setX509Certificate(X509Certificate cert) throws CertificateEncodingException {
        if (cert == null) {
            throw new IllegalArgumentException("data == null");
        }
        this.setToken(cert.getEncoded());
    }
}

