/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.descriptor;

import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.globus.ogsa.impl.security.descriptor.AuthMethod;
import org.globus.ogsa.impl.security.descriptor.AuthMethodParserCallback;
import org.globus.ogsa.impl.security.descriptor.GSIAuthMethodParserImpl;
import org.globus.ogsa.impl.security.descriptor.NoneAuthMethod;
import org.globus.ogsa.impl.security.descriptor.PublicKeyAuthMethod;
import org.globus.ogsa.impl.security.descriptor.SecurityDescriptorException;
import org.globus.ogsa.impl.security.descriptor.util.ElementHandler;
import org.globus.ogsa.impl.security.descriptor.util.ElementParser;
import org.globus.ogsa.impl.security.descriptor.util.ElementParserException;
import org.globus.util.I18n;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AuthMethodParser
implements ElementHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.descriptor.errors");
    public static final QName QNAME = new QName("http://www.globus.org", "auth-method");
    protected AuthMethodParserCallback callback;

    public AuthMethodParser(AuthMethodParserCallback callback) {
        this.callback = callback;
    }

    public void parse(Element elem) throws ElementParserException {
        ElementParser.checkElement(elem, QNAME);
        Vector<AuthMethod> methods = new Vector<AuthMethod>();
        boolean none = false;
        Node currentChild = elem.getFirstChild();
        while (currentChild != null) {
            if (currentChild.getNodeType() == 1) {
                String name = currentChild.getLocalName();
                if (name.equalsIgnoreCase("gsi")) {
                    if (none) {
                        throw new SecurityDescriptorException(i18n.getMessage("cannotMix"));
                    }
                    GSIAuthMethodParserImpl gsiParser = new GSIAuthMethodParserImpl();
                    gsiParser.parse((Element)currentChild);
                    methods.add(gsiParser.getMethod());
                } else if (name.equalsIgnoreCase("pkey")) {
                    if (none) {
                        throw new SecurityDescriptorException(i18n.getMessage("cannotMix"));
                    }
                    methods.add(PublicKeyAuthMethod.getInstance());
                } else if (name.equalsIgnoreCase("none")) {
                    if (methods.size() > 0) {
                        throw new SecurityDescriptorException(i18n.getMessage("cannotMix"));
                    }
                    none = true;
                    methods.add(NoneAuthMethod.getInstance());
                } else {
                    throw new SecurityDescriptorException(i18n.getMessage("badAuthMethod", (Object)name));
                }
            }
            currentChild = currentChild.getNextSibling();
        }
        this.callback.setAuthMethods(methods);
    }

    public static String getAuthMethodsAsString(List methods) {
        StringBuffer buf = new StringBuffer();
        int size = methods.size();
        int i = 0;
        while (i < size) {
            AuthMethod method = (AuthMethod)methods.get(i);
            buf.append(method.getName());
            if (i + 1 < size) {
                buf.append(i18n.getMessage("methodOr"));
            }
            ++i;
        }
        return buf.toString();
    }
}

