/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.descriptor;

import org.globus.ogsa.impl.security.descriptor.AuthMethod;
import org.globus.ogsa.impl.security.descriptor.GSIAuthMethod;
import org.globus.ogsa.impl.security.descriptor.GSIAuthMethodParser;
import org.globus.ogsa.impl.security.descriptor.SecurityDescriptorException;
import org.globus.ogsa.impl.security.descriptor.util.ElementParserException;
import org.globus.util.I18n;
import org.w3c.dom.Element;

public class SimpleGSIAuthMethodParser
implements GSIAuthMethodParser {
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.descriptor.errors");
    private AuthMethod method = null;

    public void parse(Element elem) throws ElementParserException {
        String type = elem.getAttribute("type");
        if (type == null || type.length() == 0) {
            this.method = GSIAuthMethod.BOTH;
        } else if (type.equalsIgnoreCase("signature")) {
            this.method = GSIAuthMethod.INTEGRITY;
        } else if (type.equalsIgnoreCase("encryption")) {
            this.method = GSIAuthMethod.PRIVACY;
        } else {
            throw new SecurityDescriptorException(i18n.getMessage("badGsiTypeMethod", (Object)type));
        }
    }

    public AuthMethod getMethod() {
        return this.method == null ? GSIAuthMethod.BOTH : this.method;
    }
}

