/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.repository;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.PersistentGridServiceBase;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.impl.core.handle.HandleHelper;
import org.globus.ogsa.impl.ogsi.FactoryProvider;
import org.globus.ogsa.repository.ServiceActivationException;
import org.globus.ogsa.repository.ServiceActivator;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.server.ServiceHost;
import org.globus.ogsa.utils.MessageUtils;

public class DefaultServiceActivator
implements ServiceActivator {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$repository$DefaultServiceActivator == null ? (class$org$globus$ogsa$repository$DefaultServiceActivator = DefaultServiceActivator.class$("org.globus.ogsa.repository.DefaultServiceActivator")) : class$org$globus$ogsa$repository$DefaultServiceActivator).getName());
    ServiceNode root = ServiceNode.getRootNode();
    static /* synthetic */ Class class$org$globus$ogsa$repository$DefaultServiceActivator;

    public GridServiceBase activate(String servicePath, GridContext context) throws ServiceActivationException {
        try {
            String parent = HandleHelper.getParentID(servicePath);
            GridServiceBase factory = (GridServiceBase)this.root.activate(parent);
            FactoryProvider provider = (FactoryProvider)factory.getOperationProvider(FactoryProvider.operations[0]);
            Calendar timeout = (Calendar)context.getServiceProperties().getProperty("timeout");
            Object deactivatedState = context.getServiceProperties().getProperty("deactivatedState");
            if (deactivatedState != null) {
                context.getMessageContext().setProperty("or.globus.ogsa.startupState", deactivatedState);
            }
            return provider.activateService(timeout, HandleHelper.getInstanceID(servicePath));
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw new ServiceActivationException(e.toString());
        }
    }

    public PersistentGridServiceBase activatePersistent(String servicePath, GridContext context) throws ServiceActivationException {
        try {
            MessageContext messageContext = (MessageContext)context.getMessageContext();
            String port = ServiceHost.getDefaultPort(context);
            String protocol = ServiceHost.getDefaultProtocol(context);
            if (logger.isDebugEnabled()) {
                if (messageContext != null) {
                    logger.debug((Object)((String)messageContext.getProperty("transport.url")));
                }
                logger.debug((Object)("Setting property port to: " + port));
                logger.debug((Object)("Setting property protocol to: " + protocol));
            }
            ContainerConfig config = ContainerConfig.getConfig();
            Hashtable persistentServicesOptions = config.getPersistentServicesOptions();
            if (servicePath.startsWith("/")) {
                servicePath = servicePath.substring(1, servicePath.length());
            }
            if (servicePath.endsWith("/")) {
                servicePath = servicePath.substring(0, servicePath.length() - 1);
            }
            Hashtable serviceOptions = (Hashtable)persistentServicesOptions.get(servicePath);
            String persistentClass = (String)serviceOptions.get("className");
            String baseClass = (String)serviceOptions.get("baseClassName");
            if (baseClass != null) {
                persistentClass = baseClass;
            }
            ClassLoader loader = (class$org$globus$ogsa$repository$DefaultServiceActivator == null ? (class$org$globus$ogsa$repository$DefaultServiceActivator = DefaultServiceActivator.class$("org.globus.ogsa.repository.DefaultServiceActivator")) : class$org$globus$ogsa$repository$DefaultServiceActivator).getClassLoader();
            Class<?> javaClass = loader.loadClass(persistentClass);
            logger.debug((Object)("Creating new persistent object: " + persistentClass));
            PersistentGridServiceBase obj = (PersistentGridServiceBase)javaClass.newInstance();
            obj.setProperty("port", port);
            obj.setProperty("protocol", protocol);
            Enumeration enumeration = serviceOptions.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting property " + key + " to: " + serviceOptions.get(key)));
                }
                obj.setProperty(key, serviceOptions.get(key));
            }
            logger.debug((Object)"Invoking postCreate...");
            obj.postCreate(context);
            logger.debug((Object)"Invoked postCreate");
            return obj;
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw new ServiceActivationException(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

