/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.router;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.router.ProxyTargetStarter;
import org.globus.ogsa.router.RedirectProvider;

public class ProxySetupHelper {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$router$ProxySetupHelper == null ? (class$org$globus$ogsa$router$ProxySetupHelper = ProxySetupHelper.class$("org.globus.ogsa.router.ProxySetupHelper")) : class$org$globus$ogsa$router$ProxySetupHelper).getName());
    static /* synthetic */ Class class$org$globus$ogsa$router$ProxySetupHelper;

    public static void setupProxy(ServiceProperties proxyService) throws GridServiceException {
        String localServicePath = (String)proxyService.getProperty("servicePath");
        String targetEndpoint = (String)proxyService.getProperty("targetEndpoint");
        String starterClass = (String)proxyService.getProperty("starterClass");
        String createdInstanceSchemaPath = (String)((GridServiceBase)proxyService).getInstanceProperty("schemaPath");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Proxy creation: " + localServicePath + " endpoint: " + targetEndpoint + " starter: " + starterClass + " schemaPath: " + createdInstanceSchemaPath));
        }
        try {
            ProxyTargetStarter starter = null;
            if (starterClass != null && starterClass.trim().length() > 0) {
                starter = (ProxyTargetStarter)Class.forName(starterClass).newInstance();
            }
            RedirectProvider.addTarget(localServicePath, targetEndpoint, starter, true, createdInstanceSchemaPath);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public static void destroyProxy(ServiceProperties proxyService) {
        String localServicePath = (String)proxyService.getProperty("servicePath");
        RedirectProvider.removeTarget(localServicePath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

