/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.server;

import java.net.ServerSocket;
import java.net.URL;
import java.util.Map;
import org.globus.axis.util.Util;
import org.globus.net.ServerSocketFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.server.GSIServiceDispatcher;
import org.globus.ogsa.server.ServiceContainer;
import org.globus.ogsa.server.ServiceHost;
import org.globus.security.gridmap.GridMap;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class GSIServiceContainer
extends ServiceContainer {
    public static final String CREDENTIAL = "container.credential";
    public static final String GRIDMAP = "container.gridmap";

    public GSIServiceContainer(Map properties) throws GridServiceException {
        try {
            this.initGSI(properties);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    private void initGSI(Map properties) throws Exception {
        GridMap gridMap;
        GSSCredential creds;
        if (properties == null) {
            throw new IllegalArgumentException("Container properties must be specified");
        }
        int port = 0;
        Integer portProp = (Integer)properties.get("container.port");
        if (portProp != null) {
            port = portProp;
        }
        boolean isMainThread = false;
        Boolean threadProp = (Boolean)properties.get("container.mainThread");
        if (threadProp != null) {
            isMainThread = threadProp;
        }
        int threads = -1;
        Integer threadsProp = (Integer)properties.get("container.threads");
        if (threadsProp != null) {
            threads = threadsProp;
        }
        if ((creds = (GSSCredential)properties.get(CREDENTIAL)) == null) {
            GSSManager manager = ExtendedGSSManager.getInstance();
            creds = manager.createCredential(0);
        }
        if ((gridMap = (GridMap)properties.get(GRIDMAP)) == null) {
            gridMap = new GridMap();
            gridMap.map(creds.getName().toString(), System.getProperty("user.name"));
        }
        this.init(isMainThread, port, threads, creds, gridMap, true);
    }

    private void init(boolean isMainThread, int port, int threads, GSSCredential creds, GridMap gridMap, boolean gsiMode) throws GridServiceException {
        ServerSocket socket;
        ServerSocketFactory factory = ServerSocketFactory.getDefault();
        try {
            socket = factory.createServerSocket(port);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        GSIServiceDispatcher myDispatcher = new GSIServiceDispatcher();
        myDispatcher.setServerSocket(socket);
        myDispatcher.setGridMap(gridMap);
        myDispatcher.setGSIMode(gsiMode);
        myDispatcher.setCredentials(creds);
        myDispatcher.setThreads(threads);
        this.dispatcher = myDispatcher;
        Thread serverThread = new Thread(this.dispatcher);
        serverThread.setDaemon(!isMainThread);
        serverThread.start();
        port = socket.getLocalPort();
        String baseURL = "httpg://" + ServiceHost.getHost() + ":" + port + "/" + ContainerConfig.getOgsiLocation();
        ServiceContainer.logger.debug((Object)baseURL);
        try {
            this.url = new URL(baseURL);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    static {
        Util.registerTransport();
    }
}

