/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.axis.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.config.ConfigException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.server.Semaphore;
import org.globus.ogsa.server.ServiceRequest;
import org.globus.ogsa.server.ServiceRequestQueue;
import org.globus.ogsa.server.ServiceThreadPool;
import org.globus.ogsa.utils.MessageUtils;

public class ServiceDispatcher
implements Runnable {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$server$ServiceDispatcher == null ? (class$org$globus$ogsa$server$ServiceDispatcher = ServiceDispatcher.class$("org.globus.ogsa.server.ServiceDispatcher")) : class$org$globus$ogsa$server$ServiceDispatcher).getName());
    private static AxisEngine myAxisEngine = null;
    private ServerSocket serverSocket;
    private volatile Thread worker = null;
    private volatile boolean stopped = false;
    private Semaphore semaphore = new Semaphore();
    protected ServiceRequestQueue queue;
    protected ServiceThreadPool threadPool;
    protected int numThreads = -1;
    protected int maxThreads;
    protected int highWaterMark;
    static /* synthetic */ Class class$org$globus$ogsa$server$ServiceDispatcher;

    protected static synchronized AxisEngine getAxisEngine() throws ConfigException {
        if (myAxisEngine == null) {
            myAxisEngine = ContainerConfig.getConfig().getEngine();
        }
        return myAxisEngine;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void init() throws ConfigException {
        AxisEngine engine = ServiceDispatcher.getAxisEngine();
        this.queue = new ServiceRequestQueue();
        this.threadPool = new ServiceThreadPool(this.queue, engine);
    }

    public void setThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public synchronized void waitForInit() throws InterruptedException {
        this.semaphore.waitForSignal();
    }

    public void run() {
        try {
            this.init();
        }
        catch (ConfigException e) {
            logger.debug((Object)e.toString());
            return;
        }
        if (this.numThreads <= 0) {
            try {
                String containerWaterMarkThreads;
                String containerMaxThreads;
                ContainerConfig config = ContainerConfig.getConfig();
                String containerThreads = config.getOption("containerThreads");
                if (containerThreads != null) {
                    this.numThreads = Integer.parseInt(containerThreads);
                }
                if ((containerMaxThreads = config.getOption("containerThreadsMax")) != null) {
                    this.maxThreads = Integer.parseInt(containerMaxThreads);
                }
                if ((containerWaterMarkThreads = config.getOption("containerThreadsHighWaterMark")) != null) {
                    this.highWaterMark = Integer.parseInt(containerWaterMarkThreads);
                }
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("configError", new String[]{"containerThreads"}));
                logger.error((Object)MessageUtils.toString(e));
            }
        }
        if (this.numThreads < 2) {
            this.numThreads = 2;
        }
        if (this.maxThreads == 0) {
            this.maxThreads = this.numThreads * 4;
        }
        if (this.highWaterMark == 0) {
            this.highWaterMark = this.numThreads * 2;
        }
        logger.debug((Object)("Starting up Container with " + this.numThreads + " threads"));
        this.threadPool.startThreads(this.numThreads);
        this.semaphore.sendSignal();
        int addedThreads = 0;
        while (!this.stopped) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException ioe) {
                break;
            }
            int waitingThreads = this.queue.enqueue(new ServiceRequest(socket, this.serverSocket));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("waiting threads: " + waitingThreads));
            }
            if (waitingThreads == 0 && this.threadPool.getThreads() < this.maxThreads) {
                logger.debug((Object)("added threads " + ++addedThreads));
                this.threadPool.startThreads(1);
                continue;
            }
            if (waitingThreads <= this.highWaterMark) continue;
            int stoppingThreads = waitingThreads - this.numThreads;
            logger.debug((Object)("requesting " + stoppingThreads + " threads to be stopped - water mark: " + this.highWaterMark));
            if (addedThreads < stoppingThreads) continue;
            this.threadPool.stopThreads(stoppingThreads);
            addedThreads -= stoppingThreads;
        }
    }

    public synchronized void waitForStop() throws InterruptedException {
        this.threadPool.waitForThreads();
        logger.debug((Object)"Stopping dispatcher");
    }

    public void stop() throws GridServiceException {
        this.stopped = true;
        logger.debug((Object)"Stopping threads");
        if (this.threadPool != null) {
            this.threadPool.stopThreads();
        }
        logger.debug((Object)"threads stopped interrupting worker");
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        if (this.worker != null) {
            this.worker.interrupt();
        }
        logger.debug((Object)"Stopped threads");
    }

    public void start(boolean daemon) throws GridServiceException {
        this.worker = new Thread(this);
        this.worker.setDaemon(daemon);
        this.worker.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

