/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.serviceData;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.globus.ogsa.tools.utils.MessagePrintingUtil;
import org.globus.ogsa.tools.utils.ResourceBundleUtil;

public class ServiceAnnotatorSimpleWriter {
    private String m_theFilename;
    private BufferedReader m_theReader;
    private BufferedWriter m_theWriter;
    private File m_theFile;
    private Vector m_theDataVector;
    private int m_thePosition;
    private int m_removePos = 0;
    private boolean isArray = false;
    private String[] m_annotation = null;
    private final String IS_PUBLIC = "public";
    private final String IS_VOID = "public void";

    public ServiceAnnotatorSimpleWriter(String filename) throws Exception {
        boolean result = false;
        this.m_theFilename = filename;
        this.m_theFile = new File(filename);
        try {
            this.m_theReader = new BufferedReader(new FileReader(filename));
        }
        catch (Exception e) {
            MessagePrintingUtil.info(true, ResourceBundleUtil.getMessage("openErr", filename));
            MessagePrintingUtil.error(e.getMessage());
            throw e;
        }
        this.m_theDataVector = new Vector(100);
    }

    public boolean findMethod(String methodName) {
        boolean result = false;
        Object line = null;
        int foundNotPublic = 0;
        int foundIsVoid = 0;
        String tempMethodSig = null;
        int pos = this.m_theDataVector.size();
        int i = 0;
        while (i < pos) {
            String temp = (String)this.m_theDataVector.elementAt(i);
            if (temp.indexOf(methodName) != -1) {
                if (temp.indexOf("public") != -1) {
                    if (temp.indexOf("public void") == -1) {
                        result = true;
                        this.m_thePosition = i;
                        tempMethodSig = temp;
                        break;
                    }
                    ++foundIsVoid;
                } else {
                    ++foundNotPublic;
                }
            }
            ++i;
        }
        if (result) {
            this.getMethodData(tempMethodSig, methodName);
            MessagePrintingUtil.info(true, ResourceBundleUtil.getMessage("methCorrSig", methodName));
        } else {
            if (foundIsVoid != 0) {
                MessagePrintingUtil.info(true, ResourceBundleUtil.getMessage("methVoidRet", methodName, Integer.toString(foundIsVoid)));
            }
            if (foundNotPublic != 0) {
                MessagePrintingUtil.info(true, ResourceBundleUtil.getMessage("methNotPub", methodName, Integer.toString(foundIsVoid)));
            }
            if (foundIsVoid == 0 && foundNotPublic == 0) {
                MessagePrintingUtil.info(true, ResourceBundleUtil.getMessage("methNotFound", methodName));
            }
        }
        return result;
    }

    public boolean findServiceData(String service_data_name) {
        String sd_tag = "@ogsa:service-data";
        boolean result = false;
        int pos = this.m_theDataVector.size();
        int pos_b = 0;
        int i = 0;
        while (i < pos) {
            String temp = (String)this.m_theDataVector.elementAt(i);
            pos_b = temp.indexOf(service_data_name);
            if (pos_b != -1) {
                int x;
                String work;
                int pos_a;
                temp.trim();
                if (temp.startsWith("*") && (pos_a = temp.indexOf("name")) != -1 && pos_a < pos_b && (work = (String)this.m_theDataVector.elementAt(x = i - 1)).indexOf(sd_tag) != -1) {
                    int bckwds = 5;
                    while (bckwds > 0) {
                        work = (String)this.m_theDataVector.elementAt(x);
                        work.trim();
                        if (work.startsWith("/**")) {
                            this.m_removePos = x;
                            result = true;
                            break;
                        }
                        --x;
                    }
                    if (result) break;
                }
            }
            ++i;
        }
        return result;
    }

    private void getMethodData(String theMethodInfo, String methodName) {
        int namePos = theMethodInfo.indexOf(methodName);
        int arrayPos = theMethodInfo.lastIndexOf("[]");
        if (arrayPos != -1 && arrayPos < namePos) {
            this.isArray = true;
        }
    }

    public boolean removeServiceData(String sdName) {
        boolean result = false;
        this.renameFile();
        result = this.m_theFile.delete();
        this.m_theFile = new File(this.m_theFilename);
        try {
            this.m_theWriter = new BufferedWriter(new FileWriter(this.m_theFile));
        }
        catch (IOException e) {
            MessagePrintingUtil.info(true, e.toString());
            return false;
        }
        int pos = this.m_theDataVector.size();
        int i = 0;
        while (i < this.m_removePos) {
            String temp = (String)this.m_theDataVector.elementAt(i);
            try {
                this.m_theWriter.write(temp);
                this.m_theWriter.newLine();
            }
            catch (IOException e) {
                MessagePrintingUtil.info(true, e.toString());
                return false;
            }
            ++i;
        }
        String ttemp = null;
        int x = this.m_removePos;
        while (true) {
            ttemp = (String)this.m_theDataVector.elementAt(x);
            ttemp.trim();
            if (ttemp.startsWith("*/") || x == 10) break;
            ++x;
        }
        ++x;
        try {
            int i2 = x;
            while (i2 < pos) {
                String temp = (String)this.m_theDataVector.elementAt(i2);
                this.m_theWriter.write(temp);
                this.m_theWriter.newLine();
                ++i2;
            }
            this.m_theWriter.flush();
            this.m_theWriter.close();
        }
        catch (IOException e) {
            MessagePrintingUtil.info(true, e.toString());
            return false;
        }
        return true;
    }

    public boolean addServiceData(String sdName) {
        boolean result = false;
        this.renameFile();
        result = this.m_theFile.delete();
        this.m_theFile = new File(this.m_theFilename);
        try {
            this.m_theWriter = new BufferedWriter(new FileWriter(this.m_theFile));
        }
        catch (IOException e) {
            MessagePrintingUtil.info(true, e.toString());
            return false;
        }
        int pos = this.m_theDataVector.size();
        int i = 0;
        while (i < this.m_thePosition) {
            String temp = (String)this.m_theDataVector.elementAt(i);
            try {
                this.m_theWriter.write(temp);
                this.m_theWriter.newLine();
            }
            catch (IOException e) {
                MessagePrintingUtil.info(true, e.toString());
                return false;
            }
            ++i;
        }
        this.buildServiceData(sdName);
        try {
            int x = 0;
            while (x < this.m_annotation.length) {
                this.m_theWriter.write(this.m_annotation[x]);
                this.m_theWriter.newLine();
                ++x;
            }
        }
        catch (IOException e) {
            MessagePrintingUtil.info(true, e.toString());
            return false;
        }
        try {
            int i2 = this.m_thePosition;
            while (i2 < pos) {
                String temp = (String)this.m_theDataVector.elementAt(i2);
                this.m_theWriter.write(temp);
                this.m_theWriter.newLine();
                ++i2;
            }
            this.m_theWriter.flush();
            this.m_theWriter.close();
        }
        catch (IOException e) {
            MessagePrintingUtil.info(true, e.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void readFile() throws Exception {
        if (this.m_theReader == null) {
            throw new Exception(ResourceBundleUtil.getMessage("sda_not_initialized"));
        }
        try {
            String line;
            int pos = 0;
            while ((line = this.m_theReader.readLine()) != null) {
                void var1_3;
                this.m_theDataVector.add(pos, var1_3);
                ++pos;
            }
        }
        catch (IOException e) {
            MessagePrintingUtil.info(true, "I/O error reading " + this.m_theFilename);
        }
        this.m_theReader.close();
    }

    private boolean renameFile() {
        boolean result = false;
        String ttemp = null;
        try {
            ttemp = this.m_theFile.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        String tempName = ttemp.substring(0, ttemp.lastIndexOf(46)) + ".bak";
        File newFile = new File(tempName);
        if (newFile.exists()) {
            newFile.delete();
        }
        result = this.m_theFile.renameTo(newFile);
        return result;
    }

    private void buildServiceData(String sdname) {
        this.m_annotation = new String[]{"/**", "* Current value for this member", "* @ogsa:service-data", null, null, null, "* mutability = \"mutable\"", "* modifiable = \"false\"", "* nillable = \"false\"", "*/ "};
        this.m_annotation[3] = "* name = \"" + sdname + "\"";
        if (this.isArray) {
            this.m_annotation[4] = "* minOccurs = \"0\"";
            this.m_annotation[5] = "* maxOccurs = \"unbounded\"";
        } else {
            this.m_annotation[4] = "* minOccurs = \"1\"";
            this.m_annotation[5] = "* maxOccurs = \"1\"";
        }
    }
}

