/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.tools.CommandLineTool;
import org.globus.ogsa.tools.wsdl.RelativePathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DecorateWSDL
extends CommandLineTool {
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    public static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: DecorateWSDL <wsdl binding file> <wsdl service file> |locator prefix|");
            CommandLineTool.sysExit(1);
        }
        FileOutputStream output = null;
        FileInputStream bindingInput = null;
        FileInputStream serviceInput = null;
        try {
            Element serviceDefinitionElement;
            String wsdlPrefix;
            NodeList serviceDefinitions;
            NodeList bindingDefinitions;
            File bindFileTest;
            int bindingIndex;
            String bindingFile = args[0];
            String bindingName = null;
            String serviceFile = args[1];
            String locatorPrefix = "";
            if (args.length > 2) {
                locatorPrefix = args[2];
            }
            if ((bindingIndex = bindingFile.indexOf(";")) != -1) {
                bindingName = bindingFile.substring(bindingIndex + 1, bindingFile.length());
                bindingFile = bindingFile.substring(0, bindingIndex);
            }
            if ((bindFileTest = new File(bindingFile)).isAbsolute()) {
                bindingFile = RelativePathUtil.getRelativeFileName(bindFileTest, new File(serviceFile));
            }
            System.out.println("Opening binding file: " + bindingFile);
            bindingInput = new FileInputStream(bindingFile);
            Document bindingDoc = XMLUtils.newDocument((InputStream)bindingInput);
            if (bindingDoc == null) {
                System.err.println("Error: binding file not found: " + bindingFile);
                CommandLineTool.sysExit(1);
            }
            System.out.println("Opening service file: " + serviceFile);
            serviceInput = new FileInputStream(serviceFile);
            Document serviceDoc = XMLUtils.newDocument((InputStream)serviceInput);
            if (serviceDoc == null) {
                System.err.println("Error: service file not found: " + serviceFile);
                CommandLineTool.sysExit(1);
            }
            if ((bindingDefinitions = bindingDoc.getElementsByTagNameNS(WSDL_NS, "definitions")).getLength() < 1) {
                System.err.println("Error: no definition found in " + bindingFile);
                CommandLineTool.sysExit(1);
            }
            String bindingNS = ((Element)bindingDefinitions.item(0)).getAttribute("targetNamespace");
            NodeList bindingNodes = bindingDoc.getElementsByTagNameNS(WSDL_NS, "binding");
            if (bindingNodes.getLength() < 1) {
                System.err.println("Error: no binding found in " + bindingFile);
                CommandLineTool.sysExit(1);
            }
            if (bindingName == null) {
                bindingName = ((Element)bindingNodes.item(0)).getAttribute("name");
            }
            if ((serviceDefinitions = serviceDoc.getElementsByTagNameNS(WSDL_NS, "definitions")).getLength() < 1) {
                System.err.println("Error: no definition found in " + serviceFile);
                CommandLineTool.sysExit(1);
            }
            wsdlPrefix = (wsdlPrefix = (serviceDefinitionElement = (Element)serviceDefinitions.item(0)).getPrefix()) == null ? "" : wsdlPrefix + ":";
            NodeList imports = serviceDoc.getElementsByTagNameNS(WSDL_NS, "import");
            boolean namespaceFound = false;
            int i = 0;
            while (i < imports.getLength()) {
                Element importedElement = (Element)imports.item(i);
                if (bindingNS.equals(importedElement.getAttribute("namespace"))) {
                    namespaceFound = true;
                    break;
                }
                ++i;
            }
            if (!namespaceFound) {
                Element importElement = serviceDoc.createElement(wsdlPrefix + "import");
                importElement.setAttribute("namespace", bindingNS);
                importElement.setAttribute("location", bindingFile);
                serviceDefinitionElement.insertBefore(importElement, serviceDefinitionElement.getFirstChild());
            }
            serviceDefinitionElement.setAttribute("xmlns:" + bindingName.toLowerCase(), bindingNS);
            Element portElement = serviceDoc.createElement(wsdlPrefix + "port");
            portElement.setAttribute("name", bindingName + "Port");
            portElement.setAttribute("binding", bindingName.toLowerCase() + ":" + bindingName);
            NodeList addresses = serviceDoc.getElementsByTagNameNS(SOAP_NS, "address");
            if (addresses.getLength() < 1) {
                System.err.println("Error: no addresses found in " + serviceFile);
                CommandLineTool.sysExit(1);
            }
            Element existingAddress = (Element)addresses.item(0);
            String addressLocation = existingAddress.getAttribute("location");
            String soapPrefix = existingAddress.getPrefix();
            soapPrefix = soapPrefix == null ? "" : soapPrefix + ":";
            Element addressElement = serviceDoc.createElement(soapPrefix + "address");
            addressElement.setAttribute("location", addressLocation);
            portElement.appendChild(addressElement);
            NodeList services = serviceDoc.getElementsByTagNameNS(WSDL_NS, "service");
            if (services.getLength() < 1) {
                System.err.println("Error: no services found in " + serviceFile);
                CommandLineTool.sysExit(1);
            }
            services.item(0).appendChild(portElement);
            Element serviceElement = (Element)services.item(0);
            String serviceName = serviceElement.getAttribute("name");
            serviceElement.setAttribute("name", locatorPrefix + serviceName);
            serviceInput.close();
            serviceInput = null;
            output = new FileOutputStream(serviceFile);
            XMLUtils.DocumentToStream((Document)serviceDoc, (OutputStream)output);
            output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandLineTool.sysExit(1);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception io) {}
            }
            if (bindingInput != null) {
                try {
                    bindingInput.close();
                }
                catch (Exception io) {}
            }
            if (serviceInput != null) {
                try {
                    serviceInput.close();
                }
                catch (Exception io) {}
            }
        }
    }
}

