/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis.utils.CLArgsParser;
import org.apache.axis.utils.CLOption;
import org.apache.axis.utils.CLOptionDescriptor;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.GeneratorFactory;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.gen.WSDL2;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.Utils;
import org.globus.ogsa.tools.CommandLineTool;
import org.globus.ogsa.tools.utils.MessagePrintingUtil;
import org.globus.ogsa.tools.utils.ResourceBundleUtil;
import org.globus.ogsa.tools.utils.RuntimeDirectoryUtil;
import org.globus.ogsa.tools.utils.SchemaDirectory;
import org.globus.ogsa.tools.utils.wsdl.FlattenedWSDLDefinition;
import org.globus.ogsa.tools.wsdl.JavaGridGeneratorFactory;
import org.globus.ogsa.tools.wsdl.toJava.JavaDirectImplWriter;

public class FlattenedWSDL2Impl
extends WSDL2 {
    private HashMap namespaceMap = null;
    private String namespaceFile = null;
    private String namespaceGlobal = null;
    private Emitter m_toJavaEmitter = (Emitter)this.parser;
    private String m_output_dir = null;
    private boolean m_persistent = false;
    private static final CLOptionDescriptor[] wsdl2implOptions = new CLOptionDescriptor[]{new CLOptionDescriptor("output", 2, 111, Messages.getMessage((String)"optionOutput00")), new CLOptionDescriptor("all", 8, 97, Messages.getMessage((String)"optionAll00")), new CLOptionDescriptor("persistent", 8, 101, ResourceBundleUtil.getMessage("persistent")), new CLOptionDescriptor("namespace file", 2, 102, Messages.getMessage((String)"optionFileNStoPkg00")), new CLOptionDescriptor("namespace override", 34, 78, Messages.getMessage((String)"j2woptnamespaceImpl00")), new CLOptionDescriptor("global namespace", 2, 112, Messages.getMessage((String)"j2woptPkgtoNS00"))};

    public FlattenedWSDL2Impl() {
        this.addOptions(wsdl2implOptions);
    }

    protected Parser createParser() {
        return new Emitter();
    }

    public Parser getParser() {
        return this.m_toJavaEmitter;
    }

    protected void parseOption(CLOption option) {
        switch (option.getId()) {
            case 111: {
                this.m_output_dir = option.getArgument();
                break;
            }
            case 97: {
                this.m_toJavaEmitter.setAllWanted(true);
                break;
            }
            case 101: {
                this.m_persistent = true;
                break;
            }
            case 102: {
                this.namespaceFile = option.getArgument();
                break;
            }
            case 78: {
                if (this.namespaceMap == null) {
                    this.namespaceMap = new HashMap();
                }
                String temp = option.getArgument();
                String namespace = temp.substring(0, temp.indexOf(61));
                String packageName = temp.substring(temp.indexOf(61) + 1);
                this.namespaceMap.put(namespace, packageName);
                break;
            }
            case 112: {
                this.namespaceGlobal = option.getArgument();
                break;
            }
            default: {
                super.parseOption(option);
            }
        }
    }

    private void parseArgs(String[] args) throws Exception {
        CLArgsParser argsParser = new CLArgsParser(args, this.options);
        if (null != argsParser.getErrorString()) {
            System.err.println(Messages.getMessage((String)"error01", (String)argsParser.getErrorString()));
            this.printUsage();
        }
        Vector clOptions = argsParser.getArguments();
        int size = clOptions.size();
        int i = 0;
        while (i < size) {
            this.parseOption((CLOption)clOptions.get(i));
            ++i;
        }
        this.validateOptions();
    }

    private void writeImplClass() throws Exception {
        String temp;
        Definition def = this.parser.getCurrentDefinition();
        Collection services = def.getServices().values();
        if (services.isEmpty()) {
            throw new Exception(ResourceBundleUtil.getMessage("noServiceElt"));
        }
        Service service = (Service)services.iterator().next();
        PortType custPortType = FlattenedWSDLDefinition.getCustomerPortType(service);
        String className = FlattenedWSDLDefinition.getGridServiceName(custPortType);
        QName qname = custPortType.getQName();
        String packageName = Utils.makePackageName((String)qname.getNamespaceURI());
        String fullClassName = packageName + "." + className;
        if (((Emitter)this.parser).getNamespaces().containsKey((Object)qname.getNamespaceURI())) {
            temp = ((Emitter)this.parser).getNamespaces().get((Object)qname.getNamespaceURI()).toString();
            fullClassName = temp + "." + className;
        }
        if (((Emitter)this.parser).getNamespaceMap().containsKey(qname.getNamespaceURI())) {
            temp = ((Emitter)this.parser).getNamespaceMap().get(qname.getNamespaceURI()).toString();
            fullClassName = temp + "." + className;
        }
        JavaDirectImplWriter jdiw = new JavaDirectImplWriter((Emitter)this.parser, fullClassName, "impl", service);
        jdiw.generate();
    }

    public void run(String[] args) {
        try {
            this.parseArgs(args);
            RuntimeDirectoryUtil.createCodeGenDir(this.m_output_dir);
            this.m_toJavaEmitter.setOutputDir(RuntimeDirectoryUtil.getCodeGenDir());
            if (this.namespaceMap != null) {
                ((Emitter)this.parser).setNamespaceMap(this.namespaceMap);
            } else if (this.namespaceFile != null) {
                ((Emitter)this.parser).setNStoPkg(this.namespaceFile);
            } else if (this.namespaceGlobal != null) {
                ((Emitter)this.parser).setPackageName(this.namespaceGlobal);
            } else {
                String nsToPkgMapFileName = SchemaDirectory.getSchemaRoot() + "/NStoPkg.properties";
                ((Emitter)this.parser).setNStoPkg(nsToPkgMapFileName);
            }
            this.parser.setFactory((GeneratorFactory)new JavaGridGeneratorFactory((Emitter)this.parser));
            MessagePrintingUtil.info(this.parser.isVerbose(), ResourceBundleUtil.getMessage("emitting", this.m_toJavaEmitter.getOutputDir()));
            File fileLoc = new File(this.wsdlURI.replace('\\', '/'));
            this.parser.run(fileLoc.toURL().toString());
            this.writeImplClass();
        }
        catch (Exception e) {
            MessagePrintingUtil.error(e.getMessage());
            e.printStackTrace();
            CommandLineTool.sysExit(1);
        }
    }

    public static void main(String[] args) {
        FlattenedWSDL2Impl gsdl2java = new FlattenedWSDL2Impl();
        gsdl2java.run(args);
    }
}

