/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.axis.utils.CLArgsParser;
import org.apache.axis.utils.CLOption;
import org.apache.axis.utils.CLOptionDescriptor;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.gen.WSDL2;
import org.globus.ogsa.tools.CommandLineTool;
import org.globus.ogsa.tools.utils.MessagePrintingUtil;
import org.globus.ogsa.tools.utils.ResourceBundleUtil;
import org.globus.ogsa.tools.utils.RuntimeDirectoryUtil;
import org.globus.ogsa.tools.wsdl.GenerateBinding;
import org.globus.ogsa.tools.wsdl.RelativePathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLCompletion
extends WSDL2 {
    private static final CLOptionDescriptor[] wsdl2compOptions = new CLOptionDescriptor[]{new CLOptionDescriptor("output", 2, 111, Messages.getMessage((String)"j2woptoutput00"))};
    private String m_output_dir = null;
    private boolean m_registry = false;
    private boolean m_handleResolver = false;
    private boolean m_notificationSource = false;
    private boolean m_notificationSink = false;
    private String m_outWsdlFilename = null;
    private String m_serviceFilename = null;

    public WSDLCompletion() {
        this.addOptions(wsdl2compOptions);
    }

    public String getOutputWSDLFilename() {
        return this.m_outWsdlFilename;
    }

    public static void main(String[] args) {
        WSDLCompletion wsdlcomp = new WSDLCompletion();
        wsdlcomp.run(args);
    }

    protected void parseOption(CLOption option) {
        switch (option.getId()) {
            case 111: {
                this.m_output_dir = option.getArgument();
                break;
            }
            default: {
                super.parseOption(option);
            }
        }
    }

    private void parseArgs(String[] args) throws Exception {
        CLArgsParser argsParser = new CLArgsParser(args, this.options);
        if (null != argsParser.getErrorString()) {
            System.err.println(Messages.getMessage((String)"error01", (String)argsParser.getErrorString()));
            this.printUsage();
        }
        Vector clOptions = argsParser.getArguments();
        int size = clOptions.size();
        int i = 0;
        while (i < size) {
            this.parseOption((CLOption)clOptions.get(i));
            ++i;
        }
        this.validateOptions();
    }

    private void completeWsdl(String wsdl_URI) throws Exception {
        block3: {
            File outWsdlFile;
            File inWsdlFile;
            block2: {
                inWsdlFile = new File(wsdl_URI);
                outWsdlFile = null;
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", this.parser.isVerbose());
                Definition inDef = reader.readWSDL(inWsdlFile.getCanonicalPath());
                Map services = inDef.getServices();
                if (!services.isEmpty()) break block2;
                String inWsdlFilename = inWsdlFile.getName().substring(0, inWsdlFile.getName().lastIndexOf(46));
                File bindingWsdlFile = null;
                Map bindings = inDef.getBindings();
                if (!bindings.isEmpty()) break block3;
                String bindingWsdlFilename = this.getBindingNameFromIntfName(inWsdlFilename).replace('/', '-');
                bindingWsdlFile = new File(RuntimeDirectoryUtil.getSchemaDirectory().getSchemaPath(inWsdlFile) + System.getProperty("file.separator") + bindingWsdlFilename + ".wsdl");
                MessagePrintingUtil.info(this.parser.isVerbose(), ResourceBundleUtil.getMessage("crBinding", bindingWsdlFile.getCanonicalPath(), inWsdlFile.getCanonicalPath()));
                GenerateBinding bindingGenerator = new GenerateBinding();
                String temp = inWsdlFile.getCanonicalPath().substring(0, inWsdlFile.getCanonicalPath().lastIndexOf(46));
                GenerateBinding.main(new String[]{inWsdlFile.getCanonicalPath(), temp});
                inWsdlFile = bindingWsdlFile;
                inWsdlFilename = inWsdlFile.getName().substring(0, inWsdlFile.getName().lastIndexOf(46));
                this.m_outWsdlFilename = temp + "_bindings.wsdl";
                this.m_outWsdlFilename = this.m_serviceFilename = temp + "_service.wsdl";
                break block3;
            }
            outWsdlFile = new File(RuntimeDirectoryUtil.getSchemaDirectory().getSchemaPath(inWsdlFile) + System.getProperty("file.separator") + inWsdlFile.getName());
            try {
                WSDLCompletion.moveWsdlFile(inWsdlFile, outWsdlFile.getParentFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void moveWsdlFile(File sourceWsdl, File targetDir) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            if (!sourceWsdl.isFile()) {
                throw new Exception(ResourceBundleUtil.getMessage("notFile", sourceWsdl.getCanonicalPath()));
            }
            if (!targetDir.isDirectory()) {
                throw new Exception(ResourceBundleUtil.getMessage("targetNotDir", targetDir.getCanonicalPath()));
            }
            File outFile = new File(targetDir, sourceWsdl.getName());
            outFile.createNewFile();
            fis = new FileInputStream(sourceWsdl);
            Document doc = XMLUtils.newDocument((InputStream)fis);
            fis.close();
            NodeList imports = doc.getElementsByTagName("wsdl:import");
            int i = 0;
            while (i < imports.getLength()) {
                Node importNode = imports.item(i);
                NamedNodeMap importAttrs = importNode.getAttributes();
                String location = null;
                int j = 0;
                while (j < importAttrs.getLength()) {
                    Node importAttr = importAttrs.item(j);
                    if (importAttr.getNodeName().equalsIgnoreCase("location")) {
                        location = importAttr.getNodeValue();
                        File impLocFile = new File(sourceWsdl.getParentFile(), location);
                        String newImpLoc = RelativePathUtil.getRelativeFileName(impLocFile, outFile);
                        importAttr.setNodeValue(newImpLoc);
                    }
                    ++j;
                }
                ++i;
            }
            fos = new FileOutputStream(outFile);
            XMLUtils.PrettyDocumentToStream((Document)doc, (OutputStream)fos);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception io) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception io) {}
            }
        }
    }

    public void run(String[] args) {
        try {
            this.parseArgs(args);
            RuntimeDirectoryUtil.createCodeGenDir(this.m_output_dir);
            File inWsdlFile = new File(this.wsdlURI);
            RuntimeDirectoryUtil.getSchemaDirectory().addAndUpdateWsdlFile(inWsdlFile, true);
            String newWsdlURI = RuntimeDirectoryUtil.getSchemaDirectory().getSchemaPath(inWsdlFile) + System.getProperty("file.separator") + inWsdlFile.getName();
            MessagePrintingUtil.info(this.parser.isVerbose(), ResourceBundleUtil.getMessage("compWsdlSchema", newWsdlURI));
            this.completeWsdl(newWsdlURI);
        }
        catch (IOException e) {
            MessagePrintingUtil.error(ResourceBundleUtil.getMessage("noWSDL", e.getMessage()));
            CommandLineTool.sysExit(1);
        }
        catch (Exception e) {
            MessagePrintingUtil.error(e.getMessage());
            e.printStackTrace();
            CommandLineTool.sysExit(1);
        }
    }

    public String getBindingNameFromIntfName(String intfString) {
        String INTFSTRING = intfString.toUpperCase();
        if (INTFSTRING.endsWith("INTERFACE") || INTFSTRING.endsWith("INTERFACE/") || INTFSTRING.endsWith("INTF") || INTFSTRING.endsWith("INTF/")) {
            if (intfString.endsWith("/")) {
                return intfString.substring(0, INTFSTRING.lastIndexOf("INT")) + "Binding/";
            }
            return intfString.substring(0, INTFSTRING.lastIndexOf("INT")) + "Binding";
        }
        if (INTFSTRING.endsWith("PORTTYPE")) {
            return intfString.substring(0, INTFSTRING.lastIndexOf("PORTTYPE")) + "Binding";
        }
        if (INTFSTRING.endsWith("PORTTYPE/")) {
            return intfString.substring(0, INTFSTRING.lastIndexOf("PORTTYPE/")) + "Binding/";
        }
        return intfString + "-Binding";
    }

    public String getServiceNameFromBindingName(String bindingString) {
        String BINDINGSTRING = bindingString.toUpperCase();
        if (BINDINGSTRING.endsWith("BINDING") || BINDINGSTRING.endsWith("BINDING/") || BINDINGSTRING.endsWith("BINDINGS") || BINDINGSTRING.endsWith("BINDINGS/")) {
            if (bindingString.endsWith("/")) {
                return bindingString.substring(0, BINDINGSTRING.lastIndexOf("BINDING")) + "Service/";
            }
            return bindingString.substring(0, BINDINGSTRING.lastIndexOf("BINDING")) + "Service";
        }
        return bindingString + "-Service";
    }
}

