/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl.toJava;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.AxisUtils;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.globus.ogsa.tools.utils.ResourceBundleUtil;

public class JavaGridClassWriter
extends JavaClassWriter {
    protected Service m_service;
    protected String m_fullClassName;
    protected SymbolTable m_symbolTable;
    protected Vector m_myImports = null;
    protected Vector m_myImplements = null;
    protected Hashtable m_myOpBodies = null;
    private static Vector importVectorBase = new Vector();

    public JavaGridClassWriter(Emitter emitter, String fullClassName, String type, Service service) {
        super(emitter, fullClassName, type);
        this.m_fullClassName = fullClassName;
        this.m_service = service;
        this.m_symbolTable = emitter.getSymbolTable();
    }

    protected String getImplementsText() {
        String ret = "implements OperationProvider, GridServiceCallback";
        if (!this.m_fullClassName.endsWith("Provider")) {
            StringBuffer portTypeStrings = new StringBuffer();
            Iterator<Object> i = this.m_service.getPorts().values().iterator();
            while (i.hasNext()) {
                Port port = (Port)i.next();
                Binding binding = port.getBinding();
                PortType pt = binding.getPortType();
                QName ptName = pt.getQName();
                portTypeStrings.append(" ");
                portTypeStrings.append(ptName.getLocalPart());
                portTypeStrings.append(",");
            }
            if (this.m_myImplements != null) {
                i = this.m_myImplements.iterator();
                while (i.hasNext()) {
                    portTypeStrings.append(" ");
                    portTypeStrings.append(i.next());
                    portTypeStrings.append(",");
                }
            }
            String returnString = portTypeStrings.toString();
            ret = " implements" + returnString.substring(0, returnString.lastIndexOf(","));
        }
        return ret;
    }

    protected void writeImports(PrintWriter pw) {
        Vector imports = new Vector();
        imports.addAll(importVectorBase);
        if (this.m_myImports != null) {
            imports.addAll(this.m_myImports);
        }
        int j = 0;
        while (j < imports.size()) {
            pw.println(imports.get(j));
            ++j;
        }
        pw.println();
    }

    protected void writeHeaderComments(PrintWriter pw) throws IOException {
        String localFile = this.getFileName();
        int lastSepChar = localFile.lastIndexOf(File.separatorChar);
        if (lastSepChar >= 0) {
            localFile = localFile.substring(lastSepChar + 1);
        }
        pw.println("/**");
        pw.println(" * " + localFile);
        pw.println(" *");
        pw.println(" * " + ResourceBundleUtil.getMessage("AutoGenNotice"));
        pw.println(" *  " + ResourceBundleUtil.getMessage("OGSALongName"));
        pw.println(" *");
        pw.println(" */");
        pw.println();
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
    }

    protected void writeOperation(PrintWriter pw, Parameters parms, boolean delegate) throws IOException {
        this.writeOperation(pw, parms, delegate, "super");
    }

    protected void writeOperation(PrintWriter pw, Parameters parms, boolean delegate, String delegatee) throws IOException {
        pw.println(parms.signature + " {");
        Iterator iparam = parms.list.iterator();
        while (iparam.hasNext()) {
            Parameter param = (Parameter)iparam.next();
            if (param.getMode() != 2) continue;
            BooleanHolder bThrow = new BooleanHolder(false);
            String constructorString = AxisUtils.getConstructorForParam(param, this.m_symbolTable, bThrow);
            if (bThrow.value) {
                pw.println("        try {");
            }
            pw.println("        " + AxisUtils.xmlNameToJava((String)param.getName()) + ".value = " + constructorString + ";");
            if (!bThrow.value) continue;
            pw.println("        } catch (Exception e) {");
            pw.println("          // TBD - constructor may throw");
            pw.println("        }");
        }
        Vector body = null;
        if (this.m_myOpBodies != null && (body = (Vector)this.m_myOpBodies.get(parms.signature.trim())) != null) {
            if (body != null) {
                Iterator ibody = body.iterator();
                while (ibody.hasNext()) {
                    pw.println("        " + ibody.next());
                }
            }
        } else if (delegate) {
            if (parms.returnParam != null) {
                pw.println("        return " + delegatee + "." + this.getSignatureOp(parms.signature) + "(" + this.getSignatureParmNames(parms.signature) + ");");
            } else {
                pw.println("        " + delegatee + "." + this.getSignatureOp(parms.signature) + "(" + this.getSignatureParmNames(parms.signature) + ");");
            }
        } else if (parms.returnParam != null) {
            TypeEntry returnType = parms.returnParam.getType();
            pw.print("        return ");
            if (AxisUtils.isPrimitiveType((TypeEntry)returnType)) {
                String returnString = returnType.getName();
                if ("boolean".equals(returnString)) {
                    pw.println("false;");
                } else if ("byte".equals(returnString)) {
                    pw.println("(byte)-3;");
                } else if ("short".equals(returnString)) {
                    pw.println("(short)-3;");
                } else {
                    pw.println("-3;");
                }
            } else {
                pw.println("null;");
            }
        }
        pw.println("    }");
        pw.println();
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
        this.writeHeaderComments(pw);
        this.writePackage(pw);
        this.writeImports(pw);
        pw.println(this.getClassModifiers() + this.getClassText() + this.getClassName() + ' ' + this.getExtendsText() + this.getImplementsText() + " {");
    }

    protected String getSignatureParmNames(String signature) throws IOException {
        StringBuffer buffer = new StringBuffer();
        boolean doneFirst = false;
        String inputParms = signature.substring(signature.indexOf("(") + 1, signature.lastIndexOf(")"));
        Vector<String> delegateParms = new Vector<String>();
        StringTokenizer st = new StringTokenizer(inputParms, ",");
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            StringTokenizer blankST = new StringTokenizer(token);
            if (blankST.countTokens() != 2) {
                throw new IOException(ResourceBundleUtil.getMessage("invalidTokenCount", Integer.toString(blankST.countTokens()), token));
            }
            blankST.nextToken();
            delegateParms.add(blankST.nextToken().trim());
        }
        int i = 0;
        while (i < delegateParms.size()) {
            if (doneFirst) {
                buffer.append(", ");
            }
            buffer.append((String)delegateParms.elementAt(i));
            doneFirst = true;
            ++i;
        }
        return buffer.toString();
    }

    protected String getSignatureOp(String signature) {
        String returnTypeAndOp = signature.substring(0, signature.indexOf("("));
        StringTokenizer st = new StringTokenizer(returnTypeAndOp);
        String token = null;
        while (st.hasMoreElements()) {
            token = st.nextToken();
        }
        return token;
    }

    public static boolean isUserOperation(Operation op, String custTargetNamespace) {
        Output out;
        boolean isUserOp = false;
        Input in = op.getInput();
        if (in != null) {
            String inputMessageNamespace = in.getMessage().getQName().getNamespaceURI();
            isUserOp = inputMessageNamespace.equals(custTargetNamespace);
        }
        if (!isUserOp && (out = op.getOutput()) != null) {
            String outputMessageNamespace = out.getMessage().getQName().getNamespaceURI();
            isUserOp = outputMessageNamespace.equals(custTargetNamespace);
        }
        return isUserOp;
    }

    static {
        importVectorBase.add("import java.rmi.RemoteException;");
        importVectorBase.add("import org.globus.ogsa.GridContext;");
        importVectorBase.add("import org.globus.ogsa.GridServiceCallback;");
        importVectorBase.add("import org.globus.ogsa.GridServiceException;");
        importVectorBase.add("import org.globus.ogsa.impl.core.service.ServiceDataAnnotation;");
        importVectorBase.add("import org.globus.ogsa.PersistentGridServiceCallback;");
        importVectorBase.add("import org.apache.commons.logging.Log;");
        importVectorBase.add("import org.apache.commons.logging.LogFactory;");
        importVectorBase.add("import org.globus.ogsa.OperationProvider;");
        importVectorBase.add("import org.globus.ogsa.GridServiceBase;");
        importVectorBase.add("import org.globus.ogsa.PersistentGridServiceBase;");
        importVectorBase.add("import javax.xml.namespace.QName;");
    }
}

