/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.globus.ogsa.tools.utils.SchemaDirectory;
import org.globus.ogsa.tools.utils.wsdl.FlattenedWSDLDefinition;
import org.globus.ogsa.tools.utils.wsdl.FlattenedWSDLReader;
import org.globus.ogsa.utils.GenerateSDD;

public class BatchSDDGenerator {
    private File m_outputDir = null;
    private String m_OutputSchemaDir = null;

    public BatchSDDGenerator(String outputDir) throws Exception {
        this.m_outputDir = new File(outputDir);
        if (!this.m_outputDir.isDirectory()) {
            this.m_outputDir = this.m_outputDir.getParentFile();
        }
        this.m_OutputSchemaDir = this.m_outputDir.getCanonicalPath() + File.separator + new SchemaDirectory(this.m_outputDir.getCanonicalPath() + File.separator + "schema").getRelativeSchemaSubDir();
    }

    public void execute() throws Exception {
        JarFileFilter filter = new JarFileFilter();
        File[] files = this.m_outputDir.listFiles(filter);
        int i = 0;
        while (i < files.length) {
            JarFile curJarFile = new JarFile(files[i]);
            Enumeration<JarEntry> entries = curJarFile.entries();
            while (entries.hasMoreElements()) {
                String providerClassName;
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !entryName.endsWith("-sdAnnotation") || !(providerClassName = entryName.substring(0, entryName.lastIndexOf("-sdAnnotation")).replace('/', '.')).endsWith("Provider")) continue;
                File annotationFile = new File(entryName);
                String packagePath = annotationFile.getParent();
                String annotationFileName = annotationFile.getName();
                String serviceName = annotationFileName.substring(0, annotationFileName.lastIndexOf("Provider-sdAnnotation"));
                String wsdlDir = this.m_OutputSchemaDir + File.separator + packagePath;
                WSDLFileFilter wFilter = new WSDLFileFilter();
                File[] wsdlFiles = new File(wsdlDir).listFiles(wFilter);
                File match = null;
                int j = 0;
                while (j < wsdlFiles.length) {
                    String curServiceName;
                    FlattenedWSDLDefinition def = new FlattenedWSDLDefinition(new FlattenedWSDLReader().readWSDL(wsdlFiles[j].getCanonicalPath()));
                    if (!def.getPortTypes().isEmpty() && serviceName.equals(curServiceName = def.getGridServiceName())) {
                        match = wsdlFiles[j];
                        break;
                    }
                    ++j;
                }
                if (match == null) continue;
                String[] generateSDDArgs = new String[]{match.getCanonicalPath(), providerClassName};
                GenerateSDD.main(generateSDDArgs);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: BatchSDDGenerator <tooling_output_directory>");
            System.exit(1);
        }
        try {
            BatchSDDGenerator gsdds = new BatchSDDGenerator(args[0]);
            gsdds.execute();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private class JarFileFilter
    implements FileFilter {
        private static final String JAR_FILE_EXTENSION = ".jar";

        private JarFileFilter() {
        }

        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(JAR_FILE_EXTENSION);
        }
    }

    private class WSDLFileFilter
    implements FileFilter {
        private static final String WSDL_FILE_EXTENSION = ".wsdl";

        private WSDLFileFilter() {
        }

        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(WSDL_FILE_EXTENSION);
        }
    }
}

