/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.ServicePropertiesHelper;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.LocatorType;

public class FaultHelper {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$utils$FaultHelper == null ? (class$org$globus$ogsa$utils$FaultHelper = FaultHelper.class$("org.globus.ogsa.utils.FaultHelper")) : class$org$globus$ogsa$utils$FaultHelper).getName());
    static /* synthetic */ Class class$org$globus$ogsa$utils$FaultHelper;
    static /* synthetic */ Class class$org$gridforum$ogsi$FaultType;

    public static FaultType makeFault(GridServiceException exception, ServiceProperties properties) {
        FaultType fault = FaultHelper.makeFault(exception.toString(), properties);
        Throwable chained = exception.getChained();
        while (chained != null) {
            if (chained instanceof FaultType) {
                fault.setFaultcause(new FaultType[]{(FaultType)((Object)chained)});
                break;
            }
            chained = chained instanceof GridServiceException ? ((GridServiceException)chained).getChained() : null;
        }
        return fault;
    }

    public static FaultType populateFault(FaultType fault, ServiceProperties properties) {
        block2: {
            if (properties == null) break block2;
            HandleType handle = new HandleType((String)properties.getProperty("Handle"));
            LocatorType locator = new LocatorType();
            locator.setHandle(new HandleType[]{handle});
            fault.setOriginator(locator);
            try {
                fault.setExtension(ServicePropertiesHelper.getAsAny(properties));
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.toString(e));
            }
        }
        return fault;
    }

    public static FaultType makeFault(Class exceptionClass, String debugMessage, Exception exception, ServiceProperties properties) {
        ExtensibilityType extension = null;
        FaultType chainedFault = null;
        chainedFault = exception != null && !(exception instanceof FaultType) ? FaultHelper.makeFault(MessageUtils.toString(exception)) : (FaultType)((Object)exception);
        LocatorType locator = null;
        if (properties != null) {
            HandleType handle = new HandleType((String)properties.getProperty("Handle"));
            try {
                extension = ServicePropertiesHelper.getAsAny(properties);
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.toString(e));
            }
            locator = new LocatorType();
            locator.setHandle(new HandleType[]{handle});
        }
        if (exceptionClass != null && (class$org$gridforum$ogsi$FaultType == null ? (class$org$gridforum$ogsi$FaultType = FaultHelper.class$("org.gridforum.ogsi.FaultType")) : class$org$gridforum$ogsi$FaultType).isAssignableFrom(exceptionClass)) {
            try {
                FaultType fault = (FaultType)exceptionClass.newInstance();
                fault.setDescription(new String[]{debugMessage});
                fault.setOriginator(locator);
                fault.setFaultcause(new FaultType[]{chainedFault});
                fault.setExtension(extension);
                fault.setTimestamp(Calendar.getInstance());
                return fault;
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.toString(e));
            }
        }
        return new FaultType(new String[]{debugMessage}, locator, Calendar.getInstance(), new FaultType[]{chainedFault}, null, extension);
    }

    public static FaultType makeFault(Class exceptionClass, String debugMessage, Exception e) {
        return FaultHelper.makeFault(exceptionClass, debugMessage, e, null);
    }

    public static FaultType makeFault(Class exceptionClass, String debugMessage, ServiceProperties properties) {
        return FaultHelper.makeFault(exceptionClass, debugMessage, null, properties);
    }

    public static FaultType makeFault(Class exceptionClass, String debugMessage) {
        return FaultHelper.makeFault(exceptionClass, debugMessage, null, null);
    }

    public static FaultType makeFault(Class exceptionClass, Exception exception) {
        return FaultHelper.makeFault(exceptionClass, exception.toString(), exception, null);
    }

    public static FaultType makeFault(Class exceptionClass, GridServiceException exception) {
        return FaultHelper.makeFault(exceptionClass, exception.toString(), exception, null);
    }

    public static FaultType makeFault(Class exceptionClass) {
        return FaultHelper.makeFault(exceptionClass, null, null, null);
    }

    public static FaultType makeFault(String debugMessage, Exception exception, ServiceProperties properties) {
        return FaultHelper.makeFault(null, debugMessage, exception, properties);
    }

    public static FaultType makeFault(String debugMessage, Exception exception) {
        return FaultHelper.makeFault(null, debugMessage, exception, null);
    }

    public static FaultType makeFault(String debugMessage, ServiceProperties properties) {
        return FaultHelper.makeFault(null, debugMessage, null, properties);
    }

    public static FaultType makeFault(String debugMessage) {
        return FaultHelper.makeFault(null, debugMessage, null, null);
    }

    public static String toString(FaultType fault) {
        FaultType[] chained;
        ExtensibilityType extension;
        if (fault == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        out.println();
        out.println("Fault Class: " + fault.getClass());
        String[] descriptions = fault.getDescription();
        int i = 0;
        while (descriptions != null && i < descriptions.length) {
            out.println("Description [" + i + "]: " + descriptions[i]);
            ++i;
        }
        LocatorType locator = fault.getOriginator();
        if (locator != null && locator.getHandle() != null && locator.getHandle().length > 0) {
            out.println("Originator: " + locator.getHandle()[0]);
        }
        if ((extension = fault.getExtension()) != null) {
            out.println("Details:");
            try {
                out.println("      " + AnyHelper.getAsString(fault.getExtension()));
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.toString(e));
            }
        }
        if ((chained = fault.getFaultcause()) != null) {
            int i2 = 0;
            while (i2 < chained.length) {
                out.println("Chained [" + i2 + "]:");
                out.println(FaultHelper.toString(chained[i2]));
                ++i2;
            }
        }
        out.println();
        String exceptionString = writer.toString();
        out.close();
        return exceptionString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

