/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import javax.xml.rpc.Stub;
import org.globus.gsi.proxy.IgnoreProxyPolicyHandler;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.ogsa.impl.security.Constants;
import org.globus.ogsa.impl.security.authorization.HostAuthorization;
import org.globus.ogsa.impl.security.authorization.IdentityAuthorization;
import org.globus.ogsa.impl.security.authorization.NoAuthorization;
import org.globus.ogsa.impl.security.authorization.SelfAuthorization;
import org.globus.ogsa.utils.MessageUtils;

public class GetOpts {
    private static final String optionsDesc = "Where [options] are:\n -gsiSecConv <type>\n\tEnables GSI Secure Conversation. <type> one of:\n\t 'sig' - for XML Signature\n\t 'enc' - for XML Encryption\n -gsiSecConvActor <actor>\n\tSets actor name for GSI Secure Conversation\n -gsiXmlSig\n\tEnables GSI XML Signature\n\t(can be used together with -gssxml)\n -gsiXmlSigActor <actor>\n\tSets actor name for GSI XML Signature\n -deleg <mode>\n\tPerforms delegation. <mode> one of:\n\t 'limited' - performs limited delegation\n\t 'full'    - performs full delegation\n -auth <type>\n\tPerforms authorization type. If <type> is:\n\t 'host' - performs host authorization\n\t 'self' - performs self authorization\n\t 'none' - disables authorization\n\tOtherwise, identity authorization is performed\n\twith <type> identity.\n -grimPolicyHandler <policyClass>\n\tSets GRIM policy handler\n -debug\n\tEnables debug mode\n";
    String usageMsg;
    int reqArgs;
    int skippedArgs;
    String[] args;
    protected Object msgProtection;
    protected Object delegation;
    protected Object authorization;
    protected Object x509Signature;
    protected ProxyPolicyHandler grimPolicyHandler;
    String gssActor;
    String x509Actor;
    boolean debug = false;
    static /* synthetic */ Class class$org$globus$gsi$proxy$ProxyPolicyHandler;

    public GetOpts(String usageMsg, int reqArgs) {
        this.usageMsg = usageMsg;
        this.reqArgs = reqArgs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parse(String[] args) {
        this.args = args;
        if (args.length > 0 && args[0].equalsIgnoreCase("-help")) {
            StringBuffer buf = new StringBuffer(this.usageMsg);
            buf.append(System.getProperty("line.separator"));
            buf.append(System.getProperty("line.separator"));
            buf.append(optionsDesc);
            String customDesc = this.getCustomOptionsDesc();
            if (customDesc == null) return buf.toString();
            buf.append(customDesc);
            return buf.toString();
        }
        int i = 0;
        while (i < args.length) {
            String arg;
            if (args[i].length() <= 0 || args[i].charAt(0) != '-') break;
            if (args[i].equalsIgnoreCase("-gssxml") || args[i].equalsIgnoreCase("-gsiSecConv")) {
                if (i + 1 >= args.length) {
                    return "-gsiSecConv requries argument";
                }
                if ((arg = args[++i]).equalsIgnoreCase("sig")) {
                    this.msgProtection = Constants.SIGNATURE;
                } else {
                    if (!arg.equalsIgnoreCase("enc")) return "unsupported -gsiSecConv argument: " + arg;
                    this.msgProtection = Constants.ENCRYPTION;
                }
            } else if (args[i].equalsIgnoreCase("-gssxmlActor") || args[i].equalsIgnoreCase("-gsiSecConvActor")) {
                if (i + 1 >= args.length) {
                    return "-gsiSecConvActor requries argument";
                }
                this.gssActor = args[++i];
            } else if (args[i].equalsIgnoreCase("-xmlx509sig") || args[i].equalsIgnoreCase("-gsiXmlSig")) {
                this.x509Signature = Boolean.TRUE;
            } else if (args[i].equalsIgnoreCase("-xmlx509sigActor") || args[i].equalsIgnoreCase("-gsiXmlSigActor")) {
                if (i + 1 >= args.length) {
                    return "-gsiXmlSigActor requries argument";
                }
                this.x509Actor = args[++i];
            } else if (args[i].equalsIgnoreCase("-deleg")) {
                if (i + 1 >= args.length) {
                    return "-deleg requries argument";
                }
                if ((arg = args[++i]).equalsIgnoreCase("full")) {
                    this.delegation = "gsifull";
                } else if (arg.equalsIgnoreCase("limited")) {
                    this.delegation = "gsilimited";
                } else {
                    if (!arg.equalsIgnoreCase("none")) return "unsupported -deleg argument: " + arg;
                    this.delegation = "gsi";
                }
            } else if (args[i].equalsIgnoreCase("-auth")) {
                if (i + 1 >= args.length) {
                    return "-auth requries argument";
                }
                this.authorization = (arg = args[++i]).equalsIgnoreCase("none") ? NoAuthorization.getInstance() : (arg.equalsIgnoreCase("self") ? SelfAuthorization.getInstance() : (arg.equalsIgnoreCase("host") ? HostAuthorization.getInstance() : new IdentityAuthorization(arg)));
            } else if (args[i].equalsIgnoreCase("-grimPolicyHandler")) {
                if (i + 1 >= args.length) {
                    return "-grimPolicyHandler requries argument";
                }
                if ((arg = args[++i]).equalsIgnoreCase("ignore")) {
                    this.grimPolicyHandler = new IgnoreProxyPolicyHandler();
                } else {
                    try {
                        Class<?> clazz = Class.forName(arg);
                        if (!(class$org$globus$gsi$proxy$ProxyPolicyHandler == null ? GetOpts.class$("org.globus.gsi.proxy.ProxyPolicyHandler") : class$org$globus$gsi$proxy$ProxyPolicyHandler).isAssignableFrom(clazz)) {
                            return "Grim proxy policy handler must be of " + (class$org$globus$gsi$proxy$ProxyPolicyHandler == null ? (class$org$globus$gsi$proxy$ProxyPolicyHandler = GetOpts.class$("org.globus.gsi.proxy.ProxyPolicyHandler")) : class$org$globus$gsi$proxy$ProxyPolicyHandler).getName() + " type.";
                        }
                        this.grimPolicyHandler = (ProxyPolicyHandler)clazz.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        return "Grim proxy policy handler class not found";
                    }
                    catch (InstantiationException e) {
                        return "Failed to instantiate Grim proxy policy handler: " + e.getMessage();
                    }
                    catch (IllegalAccessException e) {
                        return "Failed to instantiate Grim proxy policy handler: " + e.getMessage();
                    }
                }
            } else if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
            } else {
                String tmp = this.parseCustomOptions(args[i]);
                if (tmp != null) {
                    return tmp;
                }
            }
            ++i;
        }
        this.skippedArgs = i;
        if (args.length - this.skippedArgs >= this.reqArgs) return null;
        return this.usageMsg;
    }

    protected String parseCustomOptions(String option) {
        return "Invalid option argument: " + option;
    }

    protected String getCustomOptionsDesc() {
        return null;
    }

    public String getArg(int n) {
        return this.args[this.skippedArgs + n];
    }

    public String getOptionalArg(int n) {
        int lc = this.skippedArgs + n;
        if (lc >= this.args.length) {
            return null;
        }
        return this.args[lc];
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setOptions(Stub stub) {
        if (this.msgProtection != null) {
            stub._setProperty("org.globus.security.msg.type", this.msgProtection);
            if (this.gssActor != null) {
                stub._setProperty("gssActor", (Object)this.gssActor);
            }
        }
        if (this.delegation != null) {
            stub._setProperty("org.globus.gsi.mode", this.delegation);
        }
        if (this.authorization != null) {
            stub._setProperty("org.globus.ogsa.security.authorization", this.authorization);
        }
        if (this.x509Signature != null) {
            stub._setProperty("org.globus.ogsa.security.sign.msg", this.x509Signature);
            if (this.x509Actor != null) {
                stub._setProperty("x509Actor", (Object)this.x509Actor);
            }
        }
        if (this.grimPolicyHandler != null) {
            stub._setProperty("org.globus.ogsa.security.grim.policy.handler", (Object)this.grimPolicyHandler);
        }
    }

    public String getErrorMessage(Exception e) {
        return MessageUtils.getErrorMessage(e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

