/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.globus.ogsa.impl.core.service.ServiceDataAnnotation;

public class ServiceDataDoclet {
    private static String destDirName = ".";

    public static boolean start(RootDoc root) {
        String[][] opt = root.options();
        int i = 0;
        while (i < opt.length) {
            if (opt[i][0].equals("-dest")) {
                destDirName = opt[i][1];
            }
            ++i;
        }
        ClassDoc[] classes = root.classes();
        int i2 = 0;
        while (i2 < classes.length) {
            ServiceDataDoclet.parseClass(classes[i2]);
            ++i2;
        }
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals("-dest")) {
            return 2;
        }
        return 0;
    }

    public static void parseClass(ClassDoc classDoc) {
        block4: {
            ArrayList<ServiceDataAnnotation> annotationList = new ArrayList<ServiceDataAnnotation>();
            MethodDoc[] methods = classDoc.methods();
            int i = 0;
            while (i < methods.length) {
                Tag[] sdTags = methods[i].tags("ogsa:service-data");
                if (sdTags.length > 0) {
                    annotationList.add(ServiceDataDoclet.parseMethod(methods[i].name(), sdTags[0].text(), methods[i]));
                }
                ++i;
            }
            if (annotationList.isEmpty()) break block4;
            try {
                String fileName = destDirName + "/" + classDoc.qualifiedName().replace('.', '/') + "-sdAnnotation";
                System.out.println("writing " + fileName);
                ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
                out.writeObject(annotationList);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ServiceDataAnnotation parseMethod(String methodName, String sdTagText, MethodDoc methDoc) {
        boolean isArray;
        ServiceDataAnnotation sd = new ServiceDataAnnotation();
        HashMap params = ServiceDataDoclet.parseParameters(sdTagText);
        boolean bl = isArray = methDoc.returnType().dimension().indexOf(91) != -1;
        if (params.containsKey("name")) {
            sd.name = (String)params.get("name");
        } else {
            sd.name = methodName;
            if (methodName.startsWith("get")) {
                sd.name = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            }
            if (isArray && sd.name.endsWith("s")) {
                sd.name = sd.name.substring(0, sd.name.length() - 1);
            }
        }
        if (params.containsKey("minoccurs")) {
            sd.minOccurs = (String)params.get("minoccurs");
        } else if (isArray) {
            sd.minOccurs = "0";
        }
        if (params.containsKey("maxoccurs")) {
            sd.maxOccurs = (String)params.get("maxoccurs");
        } else if (isArray) {
            sd.maxOccurs = "unbounded";
        }
        if (params.containsKey("mutability")) {
            sd.mutability = (String)params.get("mutability");
        }
        if (params.containsKey("modifiable")) {
            sd.modifiable = (String)params.get("modifiable");
        }
        if (params.containsKey("nillable")) {
            sd.nillable = (String)params.get("nillable");
        }
        sd.documentation = methDoc.commentText();
        sd.callbackMethodName = methodName;
        sd.goodFrom = (String)params.get("goodfrom");
        sd.goodUntil = (String)params.get("gooduntil");
        sd.availableUntil = (String)params.get("availableuntil");
        return sd;
    }

    public static HashMap parseParameters(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tok = new StringTokenizer(str, "= \t\n\r");
        while (tok.hasMoreTokens()) {
            String name = ServiceDataDoclet.removeQuotes(tok.nextToken()).toLowerCase();
            if (name.startsWith("xmlns:")) {
                name = name.substring(6);
            }
            String value = ServiceDataDoclet.removeQuotes(tok.nextToken());
            map.put(name, value);
        }
        return map;
    }

    public static String removeQuotes(String str) {
        if ((str = str.trim()).startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

