/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.util.Calendar;
import javax.xml.namespace.QName;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.types.properties.FactoryDetailType;
import org.globus.ogsa.types.properties.LifeCycleType;
import org.globus.ogsa.types.properties.PropertiesDetailElementType;
import org.globus.ogsa.types.properties.PropertiesDetailType;
import org.globus.ogsa.types.properties.StateType;
import org.globus.ogsa.utils.AnyHelper;
import org.gridforum.ogsi.ExtensibilityType;

public class ServicePropertiesHelper {
    public static ExtensibilityType getAsAny(ServiceProperties properties) throws GridServiceException {
        PropertiesDetailType propertiesDetail = new PropertiesDetailType();
        if (properties.getProperty("deactivatedPersistent") == null && properties.getProperty("deactivatedTransient") == null) {
            propertiesDetail.setState(StateType.ACTIVE);
        } else {
            propertiesDetail.setState(StateType.INACTIVE);
        }
        propertiesDetail.setName((String)properties.getProperty("name"));
        propertiesDetail.setTimeout((Calendar)properties.getProperty("timeout"));
        propertiesDetail.setPortType(new QName((String)properties.getProperty("portTypeNS"), (String)properties.getProperty("portType")));
        String lifecycle = (String)properties.getProperty("lifecycle");
        if (lifecycle != null && lifecycle.equalsIgnoreCase("persistent")) {
            propertiesDetail.setPropertiesLifecycle(LifeCycleType.PERSISTENT);
        } else {
            propertiesDetail.setPropertiesLifecycle(LifeCycleType.TRANSIENT);
        }
        String persistent = (String)properties.getProperty("persistent");
        if (persistent != null && persistent.equalsIgnoreCase("true")) {
            propertiesDetail.setDeploymentLifecycle(LifeCycleType.PERSISTENT);
        } else {
            propertiesDetail.setDeploymentLifecycle(LifeCycleType.TRANSIENT);
        }
        propertiesDetail.setSchemaPath((String)properties.getProperty("schemaPath"));
        String activate = (String)properties.getProperty("activateOnStartup");
        propertiesDetail.setActivateOnStartup(new Boolean(activate != null && activate.equalsIgnoreCase("true")));
        Object deactivation = properties.getProperty("deactivation");
        if (deactivation != null) {
            if (deactivation instanceof Long) {
                propertiesDetail.setDeactivation((Long)deactivation);
            } else {
                propertiesDetail.setDeactivation(Long.valueOf((String)deactivation));
            }
        }
        propertiesDetail.setEndpoint((String)properties.getProperty("Endpoint"));
        propertiesDetail.setHandle((String)properties.getProperty("Handle"));
        propertiesDetail.setRegistry((String)properties.getProperty("registry"));
        String instanceSchemaPath = (String)properties.getProperty("instance-schemaPath");
        QName qname = PropertiesDetailElementType.getTypeDesc().getFields()[0].getXmlName();
        if (instanceSchemaPath != null) {
            FactoryDetailType factory = new FactoryDetailType();
            propertiesDetail.setFactory(factory);
            factory.setInstanceSchemaPath(instanceSchemaPath);
            String instancePropertiesLifecycle = (String)properties.getProperty("instance-lifecycle");
            if (instancePropertiesLifecycle != null && instancePropertiesLifecycle.equalsIgnoreCase("persistent")) {
                factory.setInstanceLifeCycle(LifeCycleType.PERSISTENT);
            } else {
                factory.setInstanceLifeCycle(LifeCycleType.TRANSIENT);
            }
            factory.setInstancePortType(new QName((String)properties.getProperty("instance-portTypeNS"), (String)properties.getProperty("instance-portType")));
            factory.setInstanceRegistry((String)properties.getProperty("instance-registry"));
            String instanceDeactivation = (String)properties.getProperty("instance-deactivation");
            if (instanceDeactivation != null) {
                factory.setInstanceDeactivation(Long.getLong(instanceDeactivation));
            }
        }
        ExtensibilityType extensibility = AnyHelper.getExtensibility(propertiesDetail, qname);
        return extensibility;
    }
}

